/*
 * Decompiled with CFR 0.152.
 */
package org.jutils.jhardware.info.memory.unix;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.jutils.jhardware.info.memory.AbstractMemoryInfo;
import org.jutils.jhardware.util.HardwareInfoUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UnixMemoryInfo
extends AbstractMemoryInfo {
    private static final String MEMINFO = "/proc/meminfo";

    private String getMemoryData() {
        Stream<String> streamMemoryInfo = HardwareInfoUtils.readFile(MEMINFO);
        final StringBuilder buffer = new StringBuilder();
        streamMemoryInfo.forEach(new Consumer<String>(){

            @Override
            public void accept(String line) {
                buffer.append(line).append("\r\n");
            }
        });
        return buffer.toString();
    }

    @Override
    protected Map<String, String> parseInfo() {
        String[] dataStringLines;
        HashMap<String, String> memoryDataMap = new HashMap<String, String>();
        for (String dataLine : dataStringLines = this.getMemoryData().split("\\r?\\n")) {
            String[] dataStringInfo = dataLine.split(":");
            memoryDataMap.put(dataStringInfo[0].trim(), dataStringInfo.length == 2 ? dataStringInfo[1].trim() : "");
        }
        return memoryDataMap;
    }
}

