/*
 * Decompiled with CFR 0.152.
 */
package org.jutils.jhardware.info.os.unix;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.jutils.jhardware.info.os.AbstractOSInfo;
import org.jutils.jhardware.util.HardwareInfoUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UnixOSInfo
extends AbstractOSInfo {
    private static final String OS_RELEASE = "/etc/os-release";

    private String getOSLsbReleaseData() {
        String fullData = "";
        fullData = fullData + HardwareInfoUtils.executeCommand("lsb_release", "-a");
        return fullData;
    }

    private String getOSStartTimeData() {
        String fullData = "";
        fullData = fullData + HardwareInfoUtils.executeCommand("last", "-x");
        return fullData;
    }

    private String getOSReleaseData() {
        Stream<String> streamProcessorInfo = HardwareInfoUtils.readFile(OS_RELEASE);
        final StringBuilder buffer = new StringBuilder();
        streamProcessorInfo.forEach(new Consumer<String>(){

            @Override
            public void accept(String line) {
                buffer.append(line).append("\r\n");
            }
        });
        return buffer.toString();
    }

    @Override
    protected Map<String, String> parseInfo() {
        String[] dataStringLines;
        HashMap<String, String> osDataMap = new HashMap<String, String>();
        String lsbRelease = this.getOSLsbReleaseData();
        for (String dataLine : dataStringLines = lsbRelease.split("\\r?\\n")) {
            String[] dataStringInfo = dataLine.split(":");
            osDataMap.put(dataStringInfo[0].trim(), dataStringInfo.length == 2 ? dataStringInfo[1].trim() : "");
        }
        String osRelease = this.getOSReleaseData();
        for (String dataLine : dataStringLines = osRelease.split("\\r?\\n")) {
            String[] dataStringInfo = dataLine.split("=");
            osDataMap.put(HardwareInfoUtils.toCamelCase("OS_" + dataStringInfo[0].trim()), dataStringInfo.length == 2 ? dataStringInfo[1].trim().replaceAll("\"", "") : "");
        }
        String startTimeFullData = this.getOSStartTimeData();
        for (String dataLine : dataStringLines = startTimeFullData.split("\\r?\\n")) {
            if (!dataLine.startsWith("reboot")) continue;
            osDataMap.put("LastBootTime", this.normalizeBootUpDate(dataLine.substring(39, 55)));
            break;
        }
        osDataMap.put("Manufacturer", (String)osDataMap.get("Distributor ID"));
        osDataMap.put("Name", (String)osDataMap.get("Description"));
        osDataMap.put("Version", (String)osDataMap.get("Release"));
        return osDataMap;
    }

    private String normalizeBootUpDate(String rawBootUpdate) {
        Date returnedDate;
        SimpleDateFormat df = new SimpleDateFormat("EEE MMM dd kk:mm yyyy", Locale.ENGLISH);
        try {
            returnedDate = df.parse(rawBootUpdate + " " + Calendar.getInstance().get(1));
        }
        catch (ParseException pe) {
            return rawBootUpdate;
        }
        return returnedDate.toString();
    }
}

