/*
 * Decompiled with CFR 0.152.
 */
package org.jutils.jhardware.info.processor.unix;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.jutils.jhardware.info.processor.AbstractProcessorInfo;
import org.jutils.jhardware.util.HardwareInfoUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UnixProcessorInfo
extends AbstractProcessorInfo {
    private static final String CPUINFO = "/proc/cpuinfo";
    private static final String CPUTEMP = "/sys/class/thermal/thermal_zone2/temp";

    public String getProcessorData() {
        Stream<String> streamProcessorInfo = HardwareInfoUtils.readFile(CPUINFO);
        final StringBuilder buffer = new StringBuilder();
        streamProcessorInfo.forEach(new Consumer<String>(){

            @Override
            public void accept(String line) {
                buffer.append(line).append("\r\n");
            }
        });
        return buffer.toString();
    }

    public String getTemperatureData() {
        final StringBuilder buffer = new StringBuilder();
        if (new File(CPUTEMP).exists()) {
            Stream<String> streamProcessorInfo = HardwareInfoUtils.readFile(CPUTEMP);
            streamProcessorInfo.forEach(new Consumer<String>(){

                @Override
                public void accept(String line) {
                    buffer.append(line).append("\r\n");
                }
            });
        }
        return buffer.toString();
    }

    @Override
    protected Map<String, String> parseInfo() {
        String[] dataStringLines;
        HashMap<String, String> processorDataMap = new HashMap<String, String>();
        for (String dataLine : dataStringLines = this.getProcessorData().split("\\r?\\n")) {
            String[] dataStringInfo = dataLine.split(":");
            processorDataMap.put(dataStringInfo[0].trim(), dataStringInfo.length == 2 ? dataStringInfo[1].trim() : "");
        }
        String temperature = this.getTemperatureData();
        if (temperature != null && !temperature.isEmpty()) {
            processorDataMap.put("Temperature", String.valueOf(Integer.valueOf(temperature) / 2) + "C");
        } else {
            processorDataMap.put("Temperature", "NOT DETECTED");
        }
        return processorDataMap;
    }
}

