/*
 * Decompiled with CFR 0.152.
 */
package org.jutils.jhardware.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HardwareInfoUtils {
    private static final String CRLF = "\r\n";

    public static Stream<String> readFile(String filePath) {
        Path path = Paths.get(filePath, new String[0]);
        Stream<String> fileLines = null;
        try {
            fileLines = Files.lines(path);
        }
        catch (IOException ex) {
            Logger.getLogger(HardwareInfoUtils.class.getName()).log(Level.SEVERE, null, ex);
        }
        return fileLines;
    }

    public static String executeCommand(String ... command) {
        StringBuilder commandOutput = new StringBuilder();
        try {
            String line;
            Process process = Runtime.getRuntime().exec(command);
            try {
                process.waitFor();
            }
            catch (InterruptedException ex) {
                Logger.getLogger(HardwareInfoUtils.class.getName()).log(Level.SEVERE, null, ex);
            }
            BufferedReader processOutput = process.exitValue() == 0 ? new BufferedReader(new InputStreamReader(process.getInputStream())) : new BufferedReader(new InputStreamReader(process.getErrorStream()));
            while ((line = processOutput.readLine()) != null) {
                if (line.isEmpty()) continue;
                commandOutput.append(line).append(CRLF);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(HardwareInfoUtils.class.getName()).log(Level.SEVERE, null, ex);
        }
        return commandOutput.toString();
    }

    public static boolean isSudo() {
        return !HardwareInfoUtils.executeCommand("sudo", "-n", "true").contains("a password is required");
    }

    public static String toCamelCase(String s) {
        String[] parts = s.split("_");
        String camelCaseString = "";
        for (String part : parts) {
            camelCaseString = camelCaseString + HardwareInfoUtils.toProperCase(part);
        }
        return camelCaseString;
    }

    private static String toProperCase(String s) {
        return s.substring(0, 1).toUpperCase() + s.substring(1).toLowerCase();
    }
}

