/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.labos.iu.orm.queryll2.path;

import ch.epfl.labos.iu.orm.queryll2.path.CFG;
import ch.epfl.labos.iu.orm.queryll2.path.PathAnalysisMethodChecker;
import ch.epfl.labos.iu.orm.queryll2.symbolic.BasicSymbolicInterpreter;
import ch.epfl.labos.iu.orm.queryll2.symbolic.FrameWithHelpers;
import ch.epfl.labos.iu.orm.queryll2.symbolic.SymbolicInterpreterWithFieldAccess;
import ch.epfl.labos.iu.orm.queryll2.symbolic.TypedValue;
import java.util.List;
import java.util.Vector;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TableSwitchInsnNode;
import org.objectweb.asm.tree.analysis.AnalyzerException;

public class CodePath {
    List<PathInstruction> path;

    public CodePath(List<PathInstruction> path) {
        this.path = new Vector<PathInstruction>(path);
    }

    static boolean breakIntoPaths(List<CodePath> paths, List<PathInstruction> previousInstructions, int index, CFG cfg, MethodNode m) {
        AbstractInsnNode instruction = m.instructions.get(index);
        if (instruction instanceof LookupSwitchInsnNode) {
            return false;
        }
        if (instruction instanceof TableSwitchInsnNode) {
            return false;
        }
        if (instruction.getOpcode() == 168) {
            return false;
        }
        if (instruction.getOpcode() == 169) {
            return false;
        }
        if (instruction instanceof JumpInsnNode && instruction.getOpcode() != 167) {
            int nextIndex = index + 1;
            int branchIndex = index + 1;
            for (int next : cfg.succsOf(index)) {
                if (next == nextIndex) continue;
                branchIndex = next;
            }
            previousInstructions.add(PathInstruction.branch(instruction, true));
            if (!CodePath.breakIntoPaths(paths, previousInstructions, branchIndex, cfg, m)) {
                return false;
            }
            previousInstructions.remove(previousInstructions.size() - 1);
            previousInstructions.add(PathInstruction.branch(instruction, false));
            if (!CodePath.breakIntoPaths(paths, previousInstructions, nextIndex, cfg, m)) {
                return false;
            }
            previousInstructions.remove(previousInstructions.size() - 1);
        } else if (cfg.succsOf(index) != null) {
            assert (cfg.succsOf(index).size() == 1);
            int nextIndex = cfg.succsOf(index).get(0);
            previousInstructions.add(new PathInstruction(instruction));
            if (!CodePath.breakIntoPaths(paths, previousInstructions, nextIndex, cfg, m)) {
                return false;
            }
            previousInstructions.remove(previousInstructions.size() - 1);
        } else {
            previousInstructions.add(new PathInstruction(instruction));
            paths.add(new CodePath(previousInstructions));
            previousInstructions.remove(previousInstructions.size() - 1);
        }
        return true;
    }

    static List<CodePath> breakIntoPaths(CFG cfg, MethodNode m, String name) {
        Vector<CodePath> paths = new Vector<CodePath>();
        Vector<PathInstruction> instructions = new Vector<PathInstruction>();
        if (!CodePath.breakIntoPaths(paths, instructions, 0, cfg, m)) {
            return null;
        }
        return paths;
    }

    public <T> PathReturnValueAndConditions calculateReturnValueAndConditions(ClassNode cl, MethodNode m, PathAnalysisMethodChecker methodChecker) throws AnalyzerException {
        class ConditionRecorder
        implements BasicSymbolicInterpreter.BranchHandler {
            List<TypedValue.ComparisonValue> conditions = new Vector<TypedValue.ComparisonValue>();
            boolean isBranchTaken = false;

            ConditionRecorder() {
            }

            @Override
            public void ifInstruction(AbstractInsnNode insn, TypedValue.ComparisonValue ifTrueValue) {
                if (this.isBranchTaken) {
                    this.conditions.add(ifTrueValue);
                } else {
                    this.conditions.add(ifTrueValue.inverseValue());
                }
            }
        }
        ConditionRecorder pathConditions = new ConditionRecorder();
        SymbolicInterpreterWithFieldAccess interpreter = new SymbolicInterpreterWithFieldAccess(327680);
        FrameWithHelpers frame = new FrameWithHelpers(cl, m, interpreter);
        interpreter.setFrameForAliasingFixups(frame);
        interpreter.setBranchHandler(pathConditions);
        interpreter.setMethodChecker(methodChecker);
        for (PathInstruction instruction : this.path) {
            if (instruction.node.getOpcode() < 0) continue;
            if (instruction.isBranch) {
                pathConditions.isBranchTaken = instruction.isBranchTaken;
            }
            frame.execute(instruction.node, interpreter);
        }
        TypedValue returnValue = interpreter.returnValue;
        List<TypedValue.ComparisonValue> conditions = pathConditions.conditions;
        PathReturnValueAndConditions toReturn = new PathReturnValueAndConditions();
        toReturn.returnValue = returnValue;
        toReturn.conditions = conditions;
        return toReturn;
    }

    public static class PathReturnValueAndConditions {
        TypedValue returnValue;
        List<TypedValue.ComparisonValue> conditions;
    }

    public static class PathInstruction {
        AbstractInsnNode node;
        boolean isBranchTaken = false;
        boolean isBranch = false;

        PathInstruction(AbstractInsnNode node) {
            this.node = node;
        }

        static PathInstruction branch(AbstractInsnNode node, boolean branchTaken) {
            PathInstruction pi = new PathInstruction(node);
            pi.isBranch = true;
            pi.isBranchTaken = branchTaken;
            return pi;
        }
    }
}

