/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.labos.iu.orm.queryll2.symbolic;

import ch.epfl.labos.iu.orm.queryll2.symbolic.TypedValue;
import ch.epfl.labos.iu.orm.queryll2.symbolic.TypedValueVisitor;
import org.objectweb.asm.Type;

public class ConstantValue
extends TypedValue {
    public ConstantValue(Type t) {
        super(t);
    }

    @Override
    public <I, O, E extends Exception> O visit(TypedValueVisitor<I, O, E> visitor, I input) throws E {
        return visitor.constantValue(this, input);
    }

    public Object getConstant() {
        return null;
    }

    public static class StringConstant
    extends ConstantValue {
        public String val;

        public StringConstant(String val) {
            super(Type.getObjectType((String)"java/lang/String"));
            this.val = val;
        }

        public String toString() {
            return "\"" + this.val + "\"";
        }

        @Override
        public <I, O, E extends Exception> O visit(TypedValueVisitor<I, O, E> visitor, I input) throws E {
            return visitor.stringConstantValue(this, input);
        }

        @Override
        public String getConstant() {
            return this.val;
        }
    }

    public static class NullConstant
    extends ConstantValue {
        public NullConstant() {
            super(Type.getObjectType((String)"null"));
        }

        public String toString() {
            return "null";
        }

        @Override
        public <I, O, E extends Exception> O visit(TypedValueVisitor<I, O, E> visitor, I input) throws E {
            return visitor.nullConstantValue(this, input);
        }

        @Override
        public Object getConstant() {
            return null;
        }
    }

    public static class DoubleConstant
    extends ConstantValue {
        public double val;

        public DoubleConstant(double val) {
            super(Type.DOUBLE_TYPE);
            this.val = val;
        }

        public String toString() {
            return Double.toString(this.val);
        }

        @Override
        public <I, O, E extends Exception> O visit(TypedValueVisitor<I, O, E> visitor, I input) throws E {
            return visitor.doubleConstantValue(this, input);
        }

        @Override
        public Double getConstant() {
            return this.val;
        }
    }

    public static class FloatConstant
    extends ConstantValue {
        public float val;

        public FloatConstant(float val) {
            super(Type.FLOAT_TYPE);
            this.val = val;
        }

        public String toString() {
            return Float.toString(this.val);
        }

        @Override
        public <I, O, E extends Exception> O visit(TypedValueVisitor<I, O, E> visitor, I input) throws E {
            return visitor.floatConstantValue(this, input);
        }

        @Override
        public Float getConstant() {
            return Float.valueOf(this.val);
        }
    }

    public static class LongConstant
    extends ConstantValue {
        public long val;

        public LongConstant(long val) {
            super(Type.LONG_TYPE);
            this.val = val;
        }

        public String toString() {
            return Long.toString(this.val);
        }

        @Override
        public <I, O, E extends Exception> O visit(TypedValueVisitor<I, O, E> visitor, I input) throws E {
            return visitor.longConstantValue(this, input);
        }

        @Override
        public Long getConstant() {
            return this.val;
        }
    }

    public static class IntegerConstant
    extends ConstantValue {
        public int val;

        public IntegerConstant(int val) {
            super(Type.INT_TYPE);
            this.val = val;
        }

        public String toString() {
            return Integer.toString(this.val);
        }

        @Override
        public <I, O, E extends Exception> O visit(TypedValueVisitor<I, O, E> visitor, I input) throws E {
            return visitor.integerConstantValue(this, input);
        }

        @Override
        public Integer getConstant() {
            return this.val;
        }
    }

    public static class ShortConstant
    extends ConstantValue {
        public short val;

        public ShortConstant(short val) {
            super(Type.SHORT_TYPE);
            this.val = val;
        }

        public String toString() {
            return Short.toString(this.val);
        }

        @Override
        public <I, O, E extends Exception> O visit(TypedValueVisitor<I, O, E> visitor, I input) throws E {
            return visitor.shortConstantValue(this, input);
        }

        @Override
        public Short getConstant() {
            return this.val;
        }
    }

    public static class ByteConstant
    extends ConstantValue {
        public byte val;

        public ByteConstant(byte val) {
            super(Type.BYTE_TYPE);
            this.val = val;
        }

        public String toString() {
            return Byte.toString(this.val);
        }

        @Override
        public <I, O, E extends Exception> O visit(TypedValueVisitor<I, O, E> visitor, I input) throws E {
            return visitor.byteConstantValue(this, input);
        }

        @Override
        public Byte getConstant() {
            return this.val;
        }
    }

    public static class BooleanConstant
    extends ConstantValue {
        public boolean val;

        public BooleanConstant(boolean val) {
            super(Type.BOOLEAN_TYPE);
            this.val = val;
        }

        public String toString() {
            return Boolean.toString(this.val);
        }

        @Override
        public <I, O, E extends Exception> O visit(TypedValueVisitor<I, O, E> visitor, I input) throws E {
            return visitor.booleanConstantValue(this, input);
        }

        @Override
        public Boolean getConstant() {
            return this.val;
        }
    }
}

