/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.labos.iu.orm.queryll2.symbolic;

import ch.epfl.labos.iu.orm.queryll2.symbolic.MethodSignature;
import ch.epfl.labos.iu.orm.queryll2.symbolic.TypedValue;
import ch.epfl.labos.iu.orm.queryll2.symbolic.TypedValueVisitor;
import java.util.List;
import org.objectweb.asm.Type;

public class MethodCallValue
extends TypedValue {
    public String owner;
    public String name;
    public String desc;
    public List<TypedValue> args;

    public MethodCallValue(String owner, String name, String desc, List<TypedValue> args) {
        super(Type.getReturnType((String)desc));
        this.owner = owner;
        this.name = name;
        this.desc = desc;
        this.args = args;
    }

    public String toString() {
        String str = this.name + "(";
        boolean isFirst = true;
        for (TypedValue val : this.args) {
            if (!isFirst) {
                str = str + ", ";
            }
            isFirst = false;
            str = str + val.toString();
        }
        str = str + ")";
        return str;
    }

    @Override
    public <I, O, E extends Exception> O visit(TypedValueVisitor<I, O, E> visitor, I input) throws E {
        return visitor.methodCallValue(this, input);
    }

    public MethodCallValue withNewArgs(List<TypedValue> newArgs) {
        return new MethodCallValue(this.owner, this.name, this.desc, newArgs);
    }

    public MethodSignature getSignature() {
        return new MethodSignature(this.owner, this.name, this.desc);
    }

    public static class VirtualMethodCallValue
    extends MethodCallValue {
        public TypedValue base;

        public VirtualMethodCallValue(String owner, String name, String desc, List<TypedValue> args, TypedValue base) {
            super(owner, name, desc, args);
            this.base = base;
        }

        public boolean isConstructor() {
            return this.name.equals("<init>");
        }

        @Override
        public String toString() {
            return this.base.toString() + "." + super.toString();
        }

        @Override
        public <I, O, E extends Exception> O visit(TypedValueVisitor<I, O, E> visitor, I input) throws E {
            return visitor.virtualMethodCallValue(this, input);
        }

        public VirtualMethodCallValue withNewArgs(List<TypedValue> newArgs, TypedValue newBase) {
            return new VirtualMethodCallValue(this.owner, this.name, this.desc, newArgs, newBase);
        }
    }

    public static class StaticMethodCallValue
    extends MethodCallValue {
        public StaticMethodCallValue(String owner, String name, String desc, List<TypedValue> args) {
            super(owner, name, desc, args);
        }

        @Override
        public <I, O, E extends Exception> O visit(TypedValueVisitor<I, O, E> visitor, I input) throws E {
            return visitor.staticMethodCallValue(this, input);
        }

        @Override
        public StaticMethodCallValue withNewArgs(List<TypedValue> newArgs) {
            return new StaticMethodCallValue(this.owner, this.name, this.desc, newArgs);
        }
    }
}

