/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.labos.iu.orm.queryll2.symbolic;

import ch.epfl.labos.iu.orm.queryll2.symbolic.BasicSymbolicInterpreter;
import ch.epfl.labos.iu.orm.queryll2.symbolic.TypedValue;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.analysis.AnalyzerException;
import org.objectweb.asm.tree.analysis.Value;

public class SymbolicInterpreterWithFieldAccess
extends BasicSymbolicInterpreter {
    public SymbolicInterpreterWithFieldAccess(int api) {
        super(api);
    }

    private TypedValue createGetFieldTypedValue(AbstractInsnNode insn, Value base) {
        FieldInsnNode fieldInsn = (FieldInsnNode)insn;
        return new TypedValue.GetFieldValue(fieldInsn.owner, fieldInsn.name, fieldInsn.desc, (TypedValue)base);
    }

    @Override
    public Value unaryOperation(AbstractInsnNode insn, Value value) throws AnalyzerException {
        if (insn.getOpcode() == 180) {
            if (value instanceof TypedValue.ThisValue) {
                return this.createGetFieldTypedValue(insn, value);
            }
            if (value instanceof TypedValue.GetFieldValue) {
                TypedValue baseVal = (TypedValue)value;
                while (baseVal instanceof TypedValue.GetFieldValue) {
                    baseVal = ((TypedValue.GetFieldValue)baseVal).operand;
                }
                if (baseVal instanceof TypedValue.ThisValue) {
                    return this.createGetFieldTypedValue(insn, value);
                }
            }
            throw new AnalyzerException(insn, "Unhandled field access");
        }
        return super.unaryOperation(insn, value);
    }
}

