/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.labos.iu.orm.queryll2.symbolic;

import ch.epfl.labos.iu.orm.queryll2.symbolic.MethodCallValue;
import ch.epfl.labos.iu.orm.queryll2.symbolic.TypedValue;
import ch.epfl.labos.iu.orm.queryll2.symbolic.TypedValueVisitor;
import java.util.HashMap;
import java.util.Vector;

public class TypedValueRewriterWalker<I, E extends Exception>
extends TypedValueVisitor<I, TypedValue, E> {
    HashMap<TypedValue, TypedValue> remap;
    TypedValueVisitor<I, TypedValue, E> rewriter;
    TypedValueVisitor<I, I, E> parameter;

    public TypedValueRewriterWalker(TypedValueVisitor<I, TypedValue, E> rewriter) {
        this(rewriter, new TypedValueVisitor<I, I, E>(){

            @Override
            public I defaultValue(TypedValue val, I in) throws Exception {
                return in;
            }
        });
    }

    public TypedValueRewriterWalker(TypedValueVisitor<I, TypedValue, E> rewriter, TypedValueVisitor<I, I, E> rewriterParameter) {
        this.rewriter = rewriter;
        this.parameter = rewriterParameter;
        this.remap = new HashMap();
    }

    @Override
    public TypedValue defaultValue(TypedValue val, I in) throws E {
        if (this.remap.containsKey(val)) {
            return this.remap.get(val);
        }
        I param = val.visit(this.parameter, in);
        TypedValue newVal = val.visit(this.rewriter, param);
        this.remap.put(val, newVal);
        return newVal;
    }

    @Override
    public TypedValue unaryOpValue(TypedValue.UnaryOperationValue val, I in) throws E {
        if (this.remap.containsKey(val)) {
            return this.remap.get(val);
        }
        I param = val.visit(this.parameter, in);
        TypedValue newOperand = val.operand.visit(this.rewriter, param);
        TypedValue newVal = val;
        if (newOperand != val.operand) {
            newVal = val.withNewChildren(newOperand);
        }
        newVal = ((TypedValue)newVal).visit(this.rewriter, in);
        this.remap.put(val, newVal);
        return newVal;
    }

    @Override
    public TypedValue binaryOpValue(TypedValue.BinaryOperationValue val, I in) throws E {
        if (this.remap.containsKey(val)) {
            return this.remap.get(val);
        }
        I param = val.visit(this.parameter, in);
        TypedValue newLeft = val.left.visit(this.rewriter, param);
        TypedValue newRight = val.right.visit(this.rewriter, param);
        TypedValue newVal = val;
        if (newLeft != val.left || newRight != val.right) {
            newVal = val.withNewChildren(newLeft, newRight);
        }
        newVal = ((TypedValue)newVal).visit(this.rewriter, in);
        this.remap.put(val, newVal);
        return newVal;
    }

    @Override
    public TypedValue methodCallValue(MethodCallValue val, I in) throws E {
        if (this.remap.containsKey(val)) {
            return this.remap.get(val);
        }
        I param = val.visit(this.parameter, in);
        MethodCallValue newVal = val;
        Vector<TypedValue> newArgs = new Vector<TypedValue>(val.args.size());
        boolean isChanged = false;
        for (TypedValue arg : val.args) {
            TypedValue newArg = arg.visit(this.rewriter, param);
            if (newArg != arg) {
                isChanged = true;
            }
            newArgs.add(newArg);
        }
        if (isChanged) {
            newVal = val.withNewArgs(newArgs);
        }
        TypedValue returnVal = newVal.visit(this.rewriter, in);
        this.remap.put(val, returnVal);
        return returnVal;
    }

    @Override
    public TypedValue staticMethodCallValue(MethodCallValue.StaticMethodCallValue val, I in) throws E {
        if (this.remap.containsKey(val)) {
            return this.remap.get(val);
        }
        I param = val.visit(this.parameter, in);
        MethodCallValue newVal = val;
        Vector<TypedValue> newArgs = new Vector<TypedValue>(val.args.size());
        boolean isChanged = false;
        for (TypedValue arg : val.args) {
            TypedValue newArg = arg.visit(this.rewriter, param);
            if (newArg != arg) {
                isChanged = true;
            }
            newArgs.add(newArg);
        }
        if (isChanged) {
            newVal = val.withNewArgs(newArgs);
        }
        TypedValue returnVal = ((MethodCallValue)newVal).visit(this.rewriter, in);
        this.remap.put(val, returnVal);
        return returnVal;
    }

    @Override
    public TypedValue virtualMethodCallValue(MethodCallValue.VirtualMethodCallValue val, I in) throws E {
        if (this.remap.containsKey(val)) {
            return this.remap.get(val);
        }
        I param = val.visit(this.parameter, in);
        MethodCallValue.VirtualMethodCallValue newVal = val;
        Vector<TypedValue> newArgs = new Vector<TypedValue>(val.args.size());
        boolean isChanged = false;
        for (TypedValue arg : val.args) {
            TypedValue newArg = arg.visit(this.rewriter, param);
            if (newArg != arg) {
                isChanged = true;
            }
            newArgs.add(newArg);
        }
        TypedValue newBase = val.base.visit(this.rewriter, param);
        if (isChanged || val.base != newBase) {
            newVal = val.withNewArgs(newArgs, newBase);
        }
        TypedValue returnVal = ((MethodCallValue)newVal).visit(this.rewriter, in);
        this.remap.put(val, returnVal);
        return returnVal;
    }
}

