/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.labos.iu.orm.queryll2.path;

import ch.epfl.labos.iu.orm.queryll2.path.MethodAnalysisResults;
import ch.epfl.labos.iu.orm.queryll2.path.PathAnalysis;
import ch.epfl.labos.iu.orm.queryll2.path.SymbExBooleanRewriter;
import ch.epfl.labos.iu.orm.queryll2.path.SymbExSimplifier;
import ch.epfl.labos.iu.orm.queryll2.symbolic.ConstantValue;
import ch.epfl.labos.iu.orm.queryll2.symbolic.MethodSignature;
import ch.epfl.labos.iu.orm.queryll2.symbolic.TypedValue;
import ch.epfl.labos.iu.orm.queryll2.symbolic.TypedValueRewriterWalker;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class PathAnalysisSimplifier {
    public static TypedValue simplify(TypedValue value, Map<MethodSignature, TypedValue.ComparisonValue.ComparisonOp> comparisonMethods) {
        TypedValue simplifiedBooleanReturnValue = (TypedValue)value.visit(new TypedValueRewriterWalker(new SymbExSimplifier(comparisonMethods)), null);
        simplifiedBooleanReturnValue = simplifiedBooleanReturnValue.visit(new SymbExBooleanRewriter(), false);
        return simplifiedBooleanReturnValue;
    }

    public static TypedValue simplifyBoolean(TypedValue value, Map<MethodSignature, TypedValue.ComparisonValue.ComparisonOp> comparisonMethods) {
        TypedValue simplifiedBooleanReturnValue = (TypedValue)value.visit(new TypedValueRewriterWalker(new SymbExSimplifier(comparisonMethods)), null);
        simplifiedBooleanReturnValue = simplifiedBooleanReturnValue.visit(new SymbExBooleanRewriter(), true);
        return simplifiedBooleanReturnValue;
    }

    public static List<TypedValue> simplifyBooleans(List<TypedValue> conditions, Map<MethodSignature, TypedValue.ComparisonValue.ComparisonOp> comparisonMethods) {
        ArrayList<TypedValue> newConditions = new ArrayList<TypedValue>();
        for (TypedValue cond : conditions) {
            TypedValue simpcond = (TypedValue)cond.visit(new TypedValueRewriterWalker(new SymbExSimplifier(comparisonMethods)), null);
            simpcond = simpcond.visit(new SymbExBooleanRewriter(), true);
            newConditions.add(simpcond);
        }
        return newConditions;
    }

    public static void cleanAndSimplify(MethodAnalysisResults method, Map<MethodSignature, TypedValue.ComparisonValue.ComparisonOp> comparisonMethods) {
        ArrayList<PathAnalysis> pathsToDelete = new ArrayList<PathAnalysis>();
        for (PathAnalysis path : method.paths) {
            ArrayList<TypedValue> simplifiedConditions = new ArrayList<TypedValue>();
            for (TypedValue val : PathAnalysisSimplifier.simplifyBooleans(path.getConditions(), comparisonMethods)) {
                if (val instanceof ConstantValue.BooleanConstant && !((ConstantValue.BooleanConstant)val).getConstant().booleanValue()) {
                    pathsToDelete.add(path);
                }
                simplifiedConditions.add(val);
            }
            path.conditions = simplifiedConditions;
        }
        method.paths.removeAll(pathsToDelete);
    }
}

