/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.labos.iu.orm.queryll2.path;

import ch.epfl.labos.iu.orm.queryll2.path.CFG;
import ch.epfl.labos.iu.orm.queryll2.path.CodePath;
import ch.epfl.labos.iu.orm.queryll2.path.PathAnalysis;
import ch.epfl.labos.iu.orm.queryll2.path.PathAnalysisMethodChecker;
import ch.epfl.labos.iu.orm.queryll2.path.PathAnalysisSupplementalFactory;
import ch.epfl.labos.iu.orm.queryll2.path.StaticMethodAnalysisStorage;
import ch.epfl.labos.iu.orm.queryll2.symbolic.MethodSignature;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jinq.orm.annotations.EntitySupplier;
import org.jinq.orm.annotations.NoSideEffects;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.analysis.AnalyzerException;

public class TransformationClassAnalyzer {
    public static final int MAX_PATHS = 64;
    public static Map<String, String> TransformationClassMethods = new HashMap<String, String>();
    public static Set<MethodSignature> KnownSafeMethods = new HashSet<MethodSignature>();
    public static Set<MethodSignature> KnownSafeStaticMethods = new HashSet<MethodSignature>();
    public static Set<Class<?>> SafeMethodAnnotations = new HashSet();
    public static final String WHERE_INTERFACE = "ch/epfl/labos/iu/orm/DBSet$Where";
    public static final String WHERE_METHOD = "where";
    public static final String SELECT_INTERFACE = "ch/epfl/labos/iu/orm/DBSet$Select";
    public static final String SELECT_METHOD = "select";
    public static final String AGGREGATESELECT_INTERFACE = "ch/epfl/labos/iu/orm/DBSet$AggregateSelect";
    public static final String AGGREGATESELECT_METHOD = "aggregateSelect";
    public static final String AGGREGATEINTEGER_INTERFACE = "ch/epfl/labos/iu/orm/DBSet$AggregateInteger";
    public static final String AGGREGATEINTEGER_METHOD = "aggregate";
    public static final String AGGREGATEDOUBLE_INTERFACE = "ch/epfl/labos/iu/orm/DBSet$AggregateDouble";
    public static final String AGGREGATEDOUBLE_METHOD = "aggregate";
    public static final String JOIN_INTERFACE = "ch/epfl/labos/iu/orm/DBSet$Join";
    public static final String JOIN_METHOD = "join";
    public static final String GROUP_INTERFACE = "ch/epfl/labos/iu/orm/DBSet$AggregateGroup";
    public static final String GROUP_METHOD = "aggregateSelect";
    public static final String DATESORTER_SUPERCLASS = "ch/epfl/labos/iu/orm/DateSorter";
    public static final String DATESORTER_METHOD = "value";
    public static final String INTSORTER_SUPERCLASS = "ch/epfl/labos/iu/orm/IntSorter";
    public static final String INTSORTER_METHOD = "value";
    public static final String DOUBLESORTER_SUPERCLASS = "ch/epfl/labos/iu/orm/DoubleSorter";
    public static final String DOUBLESORTER_METHOD = "value";
    public static final String STRINGSORTER_SUPERCLASS = "ch/epfl/labos/iu/orm/StringSorter";
    public static final String STRINGSORTER_METHOD = "value";
    public static final String DBSET_CLASS = "Lch/epfl/labos/iu/orm/DBSet;";
    public static final String JINQSTREAM_CLASS = "Lorg/jinq/orm/stream/JinqStream;";
    public static final MethodSignature stringEquals = new MethodSignature("java/lang/String", "equals", "(Ljava/lang/Object;)Z");
    public static final MethodSignature stringLike = new MethodSignature("ch/epfl/labos/iu/orm/Util", "SQLStringLike", "(Ljava/lang/String;Ljava/lang/String;)Z");
    public static final MethodSignature newStringBuilderString = new MethodSignature("java/lang/StringBuilder", "<init>", "(Ljava/lang/String;)V");
    public static final MethodSignature newStringBuilder = new MethodSignature("java/lang/StringBuilder", "<init>", "()V");
    public static final MethodSignature stringBuilderAppendString = new MethodSignature("java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;");
    public static final MethodSignature stringBuilderToString = new MethodSignature("java/lang/StringBuilder", "toString", "()Ljava/lang/String;");
    public static final MethodSignature dateEquals = new MethodSignature("java/util/Date", "equals", "(Ljava/lang/Object;)Z");
    public static final MethodSignature dateBefore = new MethodSignature("java/util/Date", "before", "(Ljava/util/Date;)Z");
    public static final MethodSignature dateAfter = new MethodSignature("java/util/Date", "after", "(Ljava/util/Date;)Z");
    public static final MethodSignature calendarEquals = new MethodSignature("java/util/Calendar", "equals", "(Ljava/lang/Object;)Z");
    public static final MethodSignature calendarBefore = new MethodSignature("java/util/Calendar", "before", "(Ljava/lang/Object;)Z");
    public static final MethodSignature calendarAfter = new MethodSignature("java/util/Calendar", "after", "(Ljava/lang/Object;)Z");
    public static final MethodSignature sqlDateEquals = new MethodSignature("java/sql/Date", "equals", "(Ljava/lang/Object;)Z");
    public static final MethodSignature sqlDateBefore = new MethodSignature("java/sql/Date", "before", "(Ljava/util/Date;)Z");
    public static final MethodSignature sqlDateAfter = new MethodSignature("java/sql/Date", "after", "(Ljava/util/Date;)Z");
    public static final MethodSignature sqlTimeEquals = new MethodSignature("java/sql/Time", "equals", "(Ljava/lang/Object;)Z");
    public static final MethodSignature sqlTimeBefore = new MethodSignature("java/sql/Time", "before", "(Ljava/util/Date;)Z");
    public static final MethodSignature sqlTimeAfter = new MethodSignature("java/sql/Time", "after", "(Ljava/util/Date;)Z");
    public static final MethodSignature sqlTimestampEquals = new MethodSignature("java/sql/Timestamp", "equals", "(Ljava/sql/Timestamp;)Z");
    public static final MethodSignature sqlTimestampBefore = new MethodSignature("java/sql/Timestamp", "before", "(Ljava/sql/Timestamp;)Z");
    public static final MethodSignature sqlTimestampAfter = new MethodSignature("java/sql/Timestamp", "after", "(Ljava/sql/Timestamp;)Z");
    public static final MethodSignature bigDecimalCompareTo = new MethodSignature("java/math/BigDecimal", "compareTo", "(Ljava/math/BigDecimal;)I");
    public static final MethodSignature bigDecimalEquals = new MethodSignature("java/math/BigDecimal", "equals", "(Ljava/lang/Object;)Z");
    public static final MethodSignature bigDecimalAdd = new MethodSignature("java/math/BigDecimal", "add", "(Ljava/math/BigDecimal;)Ljava/math/BigDecimal;");
    public static final MethodSignature bigDecimalDivide = new MethodSignature("java/math/BigDecimal", "divide", "(Ljava/math/BigDecimal;)Ljava/math/BigDecimal;");
    public static final MethodSignature bigDecimalMultiply = new MethodSignature("java/math/BigDecimal", "multiply", "(Ljava/math/BigDecimal;)Ljava/math/BigDecimal;");
    public static final MethodSignature bigDecimalSubtract = new MethodSignature("java/math/BigDecimal", "subtract", "(Ljava/math/BigDecimal;)Ljava/math/BigDecimal;");
    public static final MethodSignature bigIntegerCompareTo = new MethodSignature("java/math/BigInteger", "compareTo", "(Ljava/math/BigInteger;)I");
    public static final MethodSignature bigIntegerEquals = new MethodSignature("java/math/BigInteger", "equals", "(Ljava/lang/Object;)Z");
    public static final MethodSignature bigIntegerAdd = new MethodSignature("java/math/BigInteger", "add", "(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
    public static final MethodSignature bigIntegerDivide = new MethodSignature("java/math/BigInteger", "divide", "(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
    public static final MethodSignature bigIntegerMultiply = new MethodSignature("java/math/BigInteger", "multiply", "(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
    public static final MethodSignature bigIntegerSubtract = new MethodSignature("java/math/BigInteger", "subtract", "(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
    public static final MethodSignature newPair = new MethodSignature("org/jinq/tuples/Pair", "<init>", "(Ljava/lang/Object;Ljava/lang/Object;)V");
    public static final MethodSignature pairGetOne = new MethodSignature("org/jinq/tuples/Pair", "getOne", "()Ljava/lang/Object;");
    public static final MethodSignature pairGetTwo = new MethodSignature("org/jinq/tuples/Pair", "getTwo", "()Ljava/lang/Object;");
    public static final MethodSignature newTuple3 = new MethodSignature("org/jinq/tuples/Tuple3", "<init>", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)V");
    public static final MethodSignature tuple3GetOne = new MethodSignature("org/jinq/tuples/Tuple3", "getOne", "()Ljava/lang/Object;");
    public static final MethodSignature tuple3GetTwo = new MethodSignature("org/jinq/tuples/Tuple3", "getTwo", "()Ljava/lang/Object;");
    public static final MethodSignature tuple3GetThree = new MethodSignature("org/jinq/tuples/Tuple3", "getThree", "()Ljava/lang/Object;");
    public static final MethodSignature newTuple4 = new MethodSignature("org/jinq/tuples/Tuple4", "<init>", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)V");
    public static final MethodSignature tuple4GetOne = new MethodSignature("org/jinq/tuples/Tuple4", "getOne", "()Ljava/lang/Object;");
    public static final MethodSignature tuple4GetTwo = new MethodSignature("org/jinq/tuples/Tuple4", "getTwo", "()Ljava/lang/Object;");
    public static final MethodSignature tuple4GetThree = new MethodSignature("org/jinq/tuples/Tuple4", "getThree", "()Ljava/lang/Object;");
    public static final MethodSignature tuple4GetFour = new MethodSignature("org/jinq/tuples/Tuple4", "getFour", "()Ljava/lang/Object;");
    public static final MethodSignature newTuple5 = new MethodSignature("org/jinq/tuples/Tuple5", "<init>", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)V");
    public static final MethodSignature tuple5GetOne = new MethodSignature("org/jinq/tuples/Tuple5", "getOne", "()Ljava/lang/Object;");
    public static final MethodSignature tuple5GetTwo = new MethodSignature("org/jinq/tuples/Tuple5", "getTwo", "()Ljava/lang/Object;");
    public static final MethodSignature tuple5GetThree = new MethodSignature("org/jinq/tuples/Tuple5", "getThree", "()Ljava/lang/Object;");
    public static final MethodSignature tuple5GetFour = new MethodSignature("org/jinq/tuples/Tuple5", "getFour", "()Ljava/lang/Object;");
    public static final MethodSignature tuple5GetFive = new MethodSignature("org/jinq/tuples/Tuple5", "getFive", "()Ljava/lang/Object;");
    public static final MethodSignature newTuple8 = new MethodSignature("org/jinq/tuples/Tuple8", "<init>", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)V");
    public static final MethodSignature tuple8GetOne = new MethodSignature("org/jinq/tuples/Tuple8", "getOne", "()Ljava/lang/Object;");
    public static final MethodSignature tuple8GetTwo = new MethodSignature("org/jinq/tuples/Tuple8", "getTwo", "()Ljava/lang/Object;");
    public static final MethodSignature tuple8GetThree = new MethodSignature("org/jinq/tuples/Tuple8", "getThree", "()Ljava/lang/Object;");
    public static final MethodSignature tuple8GetFour = new MethodSignature("org/jinq/tuples/Tuple8", "getFour", "()Ljava/lang/Object;");
    public static final MethodSignature tuple8GetFive = new MethodSignature("org/jinq/tuples/Tuple8", "getFive", "()Ljava/lang/Object;");
    public static final MethodSignature tuple8GetSix = new MethodSignature("org/jinq/tuples/Tuple8", "getSix", "()Ljava/lang/Object;");
    public static final MethodSignature tuple8GetSeven = new MethodSignature("org/jinq/tuples/Tuple8", "getSeven", "()Ljava/lang/Object;");
    public static final MethodSignature tuple8GetEight = new MethodSignature("org/jinq/tuples/Tuple8", "getEight", "()Ljava/lang/Object;");
    public static final MethodSignature streamSumInt = new MethodSignature("org/jinq/orm/stream/JinqStream", "sumInteger", "(Lorg/jinq/orm/stream/JinqStream$CollectInteger;)Ljava/lang/Long;");
    public static final MethodSignature streamSumDouble = new MethodSignature("org/jinq/orm/stream/JinqStream", "sumDouble", "(Lorg/jinq/orm/stream/JinqStream$CollectDouble;)Ljava/lang/Double;");
    public static final MethodSignature streamMax = new MethodSignature("org/jinq/orm/stream/JinqStream", "max", "(Lorg/jinq/orm/stream/JinqStream$CollectComparable;)Ljava/lang/Comparable;");
    public static final MethodSignature streamMin = new MethodSignature("org/jinq/orm/stream/JinqStream", "min", "(Lorg/jinq/orm/stream/JinqStream$CollectComparable;)Ljava/lang/Comparable;");
    public static final MethodSignature streamFrom = new MethodSignature("org/jinq/orm/stream/JinqStream", "from", "(Ljava/util/Collection;)Lorg/jinq/orm/stream/JinqStream;");
    public static final MethodSignature streamOf = new MethodSignature("org/jinq/orm/stream/JinqStream", "of", "(Ljava/lang/Object;)Lorg/jinq/orm/stream/JinqStream;");
    public static final MethodSignature dbsetSumInt = new MethodSignature("ch/epfl/labos/iu/orm/DBSet", "sumInt", "(Lch/epfl/labos/iu/orm/DBSet$AggregateInteger;)I");
    public static final MethodSignature dbsetSumDouble = new MethodSignature("ch/epfl/labos/iu/orm/DBSet", "sumDouble", "(Lch/epfl/labos/iu/orm/DBSet$AggregateDouble;)D");
    public static final MethodSignature dbsetMaxInt = new MethodSignature("ch/epfl/labos/iu/orm/DBSet", "maxInt", "(Lch/epfl/labos/iu/orm/DBSet$AggregateInteger;)I");
    public static final MethodSignature dbsetMaxDouble = new MethodSignature("ch/epfl/labos/iu/orm/DBSet", "maxDouble", "(Lch/epfl/labos/iu/orm/DBSet$AggregateDouble;)D");
    public static final MethodSignature dbsetWhere = new MethodSignature("ch/epfl/labos/iu/orm/DBSet", "where", "(Lch/epfl/labos/iu/orm/DBSet$Where;)Lch/epfl/labos/iu/orm/DBSet;");
    public static final MethodSignature dbsetToStream = new MethodSignature("ch/epfl/labos/iu/orm/DBSet", "jinqStream", "()Lorg/jinq/orm/stream/JinqStream;");
    public static final MethodSignature integerValueOf = new MethodSignature("java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;");
    public static final MethodSignature longValueOf = new MethodSignature("java/lang/Long", "valueOf", "(J)Ljava/lang/Long;");
    public static final MethodSignature doubleValueOf = new MethodSignature("java/lang/Double", "valueOf", "(D)Ljava/lang/Double;");
    public static final MethodSignature booleanValueOf = new MethodSignature("java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;");
    public static final MethodSignature integerIntValue = new MethodSignature("java/lang/Integer", "intValue", "()I");
    public static final MethodSignature longLongValue = new MethodSignature("java/lang/Long", "longValue", "()J");
    public static final MethodSignature doubleDoubleValue = new MethodSignature("java/lang/Double", "doubleValue", "()D");
    public static final MethodSignature booleanBooleanValue = new MethodSignature("java/lang/Boolean", "booleanValue", "()Z");
    public static final MethodSignature bigIntegerValueOfLong = new MethodSignature("java/math/BigInteger", "valueOf", "(J)Ljava/math/BigInteger;");
    public static final MethodSignature newBigDecimalLong = new MethodSignature("java/math/BigDecimal", "<init>", "(J)V");
    public static final MethodSignature newBigDecimalDouble = new MethodSignature("java/math/BigDecimal", "<init>", "(D)V");
    public static final MethodSignature newBigDecimalInt = new MethodSignature("java/math/BigDecimal", "<init>", "(I)V");
    public static final MethodSignature newBigDecimalBigInteger = new MethodSignature("java/math/BigDecimal", "<init>", "(Ljava/math/BigInteger;)V");
    public static final MethodSignature bigDecimalDoubleValue = new MethodSignature("java/math/BigDecimal", "doubleValue", "()D");
    public static final MethodSignature bigIntegerDoubleValue = new MethodSignature("java/math/BigInteger", "doubleValue", "()D");
    ClassNode cl = new ClassNode();

    public TransformationClassAnalyzer(File f) throws IOException {
        FileInputStream fis = new FileInputStream(f);
        ClassReader reader = new ClassReader((InputStream)fis);
        reader.accept((ClassVisitor)this.cl, 0);
        fis.close();
    }

    public TransformationClassAnalyzer(String className) throws IOException {
        this(className, null);
    }

    public TransformationClassAnalyzer(String className, ClassLoader alternateClassLoader) throws IOException {
        ClassReader reader = null;
        try {
            reader = new ClassReader(className);
        }
        catch (IOException e) {
            String classFileName = className.replace(".", "/") + ".class";
            InputStream classStream = this.getClass().getClassLoader().getResourceAsStream(classFileName);
            if (classStream == null && alternateClassLoader != null) {
                classStream = alternateClassLoader.getResourceAsStream(classFileName);
            }
            reader = new ClassReader(classStream);
        }
        reader.accept((ClassVisitor)this.cl, 0);
    }

    public <T, U> void analyze(StaticMethodAnalysisStorage analysisResults, PathAnalysisSupplementalFactory<T, U> pathAnalysisFactory) {
        ArrayList<String> interfacesAndParent = new ArrayList<String>();
        interfacesAndParent.addAll(this.cl.interfaces);
        interfacesAndParent.add(this.cl.superName);
        for (String i : interfacesAndParent) {
            String expectedMethodName = TransformationClassMethods.get(i);
            if (expectedMethodName == null) continue;
            MethodNode nonSpecificMethod = null;
            MethodNode specificMethod = null;
            int specificity = Integer.MAX_VALUE;
            for (MethodNode m : this.cl.methods) {
                if (!m.name.equals(expectedMethodName)) continue;
                if (m.desc.split("Ljava/lang/Object").length < specificity) {
                    specificMethod = m;
                    specificity = m.desc.split("Ljava/lang/Object").length;
                    continue;
                }
                nonSpecificMethod = m;
            }
            try {
                U analysis = this.analyzeMethod(specificMethod, pathAnalysisFactory);
                if (analysis == null) continue;
                analysisResults.storeMethodAnalysis(i, this.cl.name, analysis);
            }
            catch (AnalyzerException e) {
                e.printStackTrace();
            }
        }
    }

    public <T, U> U analyzeLambdaMethod(String methodName, String methodSignature, PathAnalysisSupplementalFactory<T, U> pathAnalysisFactory) throws AnalyzerException {
        MethodNode specificMethod = null;
        for (MethodNode m : this.cl.methods) {
            if (!m.name.equals(methodName) || !m.desc.equals(methodSignature)) continue;
            specificMethod = m;
        }
        if (specificMethod != null) {
            return this.analyzeMethod(specificMethod, pathAnalysisFactory);
        }
        return null;
    }

    <T, U> U analyzeMethod(MethodNode m, PathAnalysisSupplementalFactory<T, U> pathAnalysisFactory) throws AnalyzerException {
        if (m.tryCatchBlocks.size() > 0) {
            return null;
        }
        CFG cfg = new CFG(this.cl.name, m);
        int[] visitStatus = new int[m.instructions.size()];
        if (this.hasLoops(cfg, visitStatus, 0)) {
            return null;
        }
        List<CodePath> paths = CodePath.breakIntoPaths(cfg, m, this.cl.name, 64);
        if (paths == null) {
            return null;
        }
        U analysis = pathAnalysisFactory.createMethodAnalysisResults();
        for (CodePath path : paths) {
            PathAnalysisMethodChecker methodChecker = pathAnalysisFactory.createMethodChecker();
            PathAnalysis pathResults = path.calculateReturnValueAndConditions(this.cl, m, methodChecker);
            pathAnalysisFactory.addPath(analysis, pathResults.sideEffects, pathResults.returnValue, pathResults.conditions, methodChecker);
        }
        return analysis;
    }

    boolean hasLoops(CFG cfg, int[] visitStatus, int index) {
        boolean VISITING = true;
        int VISITED = 2;
        if (cfg.succsOf(index) == null) {
            return false;
        }
        if (visitStatus[index] == 2) {
            return false;
        }
        if (visitStatus[index] == 1) {
            return true;
        }
        visitStatus[index] = 1;
        for (int succ : cfg.succsOf(index)) {
            if (!this.hasLoops(cfg, visitStatus, succ)) continue;
            return true;
        }
        visitStatus[index] = 2;
        return false;
    }

    static {
        TransformationClassMethods.put(GROUP_INTERFACE, "aggregateSelect");
        TransformationClassMethods.put(JOIN_INTERFACE, JOIN_METHOD);
        TransformationClassMethods.put(AGGREGATEDOUBLE_INTERFACE, "aggregate");
        TransformationClassMethods.put(AGGREGATEINTEGER_INTERFACE, "aggregate");
        TransformationClassMethods.put(AGGREGATESELECT_INTERFACE, "aggregateSelect");
        TransformationClassMethods.put(SELECT_INTERFACE, SELECT_METHOD);
        TransformationClassMethods.put(WHERE_INTERFACE, WHERE_METHOD);
        TransformationClassMethods.put(DATESORTER_SUPERCLASS, "value");
        TransformationClassMethods.put(INTSORTER_SUPERCLASS, "value");
        TransformationClassMethods.put(DOUBLESORTER_SUPERCLASS, "value");
        TransformationClassMethods.put(STRINGSORTER_SUPERCLASS, "value");
        KnownSafeMethods.add(stringEquals);
        KnownSafeStaticMethods.add(stringLike);
        KnownSafeMethods.add(newStringBuilderString);
        KnownSafeMethods.add(newStringBuilder);
        KnownSafeMethods.add(stringBuilderAppendString);
        KnownSafeMethods.add(stringBuilderToString);
        KnownSafeMethods.add(dateEquals);
        KnownSafeMethods.add(dateBefore);
        KnownSafeMethods.add(dateAfter);
        KnownSafeMethods.add(calendarEquals);
        KnownSafeMethods.add(calendarBefore);
        KnownSafeMethods.add(calendarAfter);
        KnownSafeMethods.add(sqlDateEquals);
        KnownSafeMethods.add(sqlDateBefore);
        KnownSafeMethods.add(sqlDateAfter);
        KnownSafeMethods.add(sqlTimeEquals);
        KnownSafeMethods.add(sqlTimeBefore);
        KnownSafeMethods.add(sqlTimeAfter);
        KnownSafeMethods.add(sqlTimestampEquals);
        KnownSafeMethods.add(sqlTimestampBefore);
        KnownSafeMethods.add(sqlTimestampAfter);
        KnownSafeMethods.add(bigDecimalCompareTo);
        KnownSafeMethods.add(bigDecimalEquals);
        KnownSafeMethods.add(bigDecimalAdd);
        KnownSafeMethods.add(bigDecimalDivide);
        KnownSafeMethods.add(bigDecimalMultiply);
        KnownSafeMethods.add(bigDecimalSubtract);
        KnownSafeMethods.add(bigIntegerCompareTo);
        KnownSafeMethods.add(bigIntegerEquals);
        KnownSafeMethods.add(bigIntegerAdd);
        KnownSafeMethods.add(bigIntegerDivide);
        KnownSafeMethods.add(bigIntegerMultiply);
        KnownSafeMethods.add(bigIntegerSubtract);
        KnownSafeMethods.add(newPair);
        KnownSafeMethods.add(pairGetOne);
        KnownSafeMethods.add(pairGetTwo);
        KnownSafeMethods.add(newTuple3);
        KnownSafeMethods.add(tuple3GetOne);
        KnownSafeMethods.add(tuple3GetTwo);
        KnownSafeMethods.add(tuple3GetThree);
        KnownSafeMethods.add(newTuple4);
        KnownSafeMethods.add(tuple4GetOne);
        KnownSafeMethods.add(tuple4GetTwo);
        KnownSafeMethods.add(tuple4GetThree);
        KnownSafeMethods.add(tuple4GetFour);
        KnownSafeMethods.add(newTuple5);
        KnownSafeMethods.add(tuple5GetOne);
        KnownSafeMethods.add(tuple5GetTwo);
        KnownSafeMethods.add(tuple5GetThree);
        KnownSafeMethods.add(tuple5GetFour);
        KnownSafeMethods.add(tuple5GetFive);
        KnownSafeMethods.add(newTuple8);
        KnownSafeMethods.add(tuple8GetOne);
        KnownSafeMethods.add(tuple8GetTwo);
        KnownSafeMethods.add(tuple8GetThree);
        KnownSafeMethods.add(tuple8GetFour);
        KnownSafeMethods.add(tuple8GetFive);
        KnownSafeMethods.add(tuple8GetSix);
        KnownSafeMethods.add(tuple8GetSeven);
        KnownSafeMethods.add(tuple8GetEight);
        KnownSafeStaticMethods.add(streamFrom);
        KnownSafeStaticMethods.add(streamOf);
        KnownSafeStaticMethods.add(bigIntegerValueOfLong);
        KnownSafeMethods.add(newBigDecimalLong);
        KnownSafeMethods.add(newBigDecimalDouble);
        KnownSafeMethods.add(newBigDecimalInt);
        KnownSafeMethods.add(newBigDecimalBigInteger);
        KnownSafeMethods.add(bigDecimalDoubleValue);
        KnownSafeMethods.add(bigIntegerDoubleValue);
        SafeMethodAnnotations.add(NoSideEffects.class);
        SafeMethodAnnotations.add(EntitySupplier.class);
    }
}

