/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.labos.iu.orm.queryll2.symbolic;

import ch.epfl.labos.iu.orm.queryll2.symbolic.TypedValueVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.analysis.Value;

public class TypedValue
implements Value {
    Type type;

    public TypedValue(Type type) {
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    public boolean isPrimitive() {
        if (this.type == null) {
            return false;
        }
        return this.type.getSort() != 10 && this.type.getSort() != 9;
    }

    public int getSize() {
        if (this.type == null) {
            return 1;
        }
        return this.type.getSize();
    }

    public <I, O, E extends Exception> O visit(TypedValueVisitor<I, O, E> visitor, I input) throws E {
        return visitor.unknownValue(this, input);
    }

    public static class ComparisonValue
    extends BinaryOperationValue {
        public ComparisonOp compOp;

        static String compToString(ComparisonOp op) {
            switch (op) {
                case eq: {
                    return "==";
                }
                case ne: {
                    return "!=";
                }
                case lt: {
                    return "<";
                }
                case gt: {
                    return ">";
                }
                case le: {
                    return "<=";
                }
            }
            return ">=";
        }

        public String sqlOpString() {
            switch (this.compOp) {
                case eq: {
                    return "=";
                }
                case ne: {
                    return "<>";
                }
                case lt: {
                    return "<";
                }
                case gt: {
                    return ">";
                }
                case le: {
                    return "<=";
                }
            }
            return ">=";
        }

        public ComparisonValue(ComparisonOp operation, TypedValue left, TypedValue right) {
            super(Type.BOOLEAN_TYPE, ComparisonValue.compToString(operation), left, right);
            this.compOp = operation;
        }

        public ComparisonValue inverseValue() {
            ComparisonOp notOp;
            switch (this.compOp) {
                case eq: {
                    notOp = ComparisonOp.ne;
                    break;
                }
                case ne: {
                    notOp = ComparisonOp.eq;
                    break;
                }
                case lt: {
                    notOp = ComparisonOp.ge;
                    break;
                }
                case gt: {
                    notOp = ComparisonOp.le;
                    break;
                }
                case le: {
                    notOp = ComparisonOp.gt;
                    break;
                }
                default: {
                    notOp = ComparisonOp.lt;
                }
            }
            return new ComparisonValue(notOp, this.left, this.right);
        }

        @Override
        public <I, O, E extends Exception> O visit(TypedValueVisitor<I, O, E> visitor, I input) throws E {
            return visitor.comparisonOpValue(this, input);
        }

        @Override
        public ComparisonValue withNewChildren(TypedValue newLeft, TypedValue newRight) {
            return new ComparisonValue(this.compOp, newLeft, newRight);
        }

        public static enum ComparisonOp {
            eq,
            ne,
            lt,
            gt,
            le,
            ge;

        }
    }

    public static class MathOpValue
    extends BinaryOperationValue {
        public Op op;

        static String opToString(Op op) {
            return op.getOpString();
        }

        public String sqlOpString() {
            return MathOpValue.opToString(this.op);
        }

        public MathOpValue(Op op, Type returnType, TypedValue left, TypedValue right) {
            super(returnType, MathOpValue.opToString(op), left, right);
            this.op = op;
        }

        public MathOpValue(Op op, TypedValue left, TypedValue right) {
            this(op, left.type, left, right);
        }

        @Override
        public <I, O, E extends Exception> O visit(TypedValueVisitor<I, O, E> visitor, I input) throws E {
            return visitor.mathOpValue(this, input);
        }

        @Override
        public MathOpValue withNewChildren(TypedValue newLeft, TypedValue newRight) {
            return new MathOpValue(this.op, newLeft, newRight);
        }

        public static enum Op {
            plus("+"),
            minus("-"),
            mul("*"),
            div("/"),
            mod("%"),
            cmp("cmp");

            String opString;

            private Op(String opString) {
                this.opString = opString;
            }

            public String getOpString() {
                return this.opString;
            }
        }
    }

    public static class BinaryOperationValue
    extends TypedValue {
        public String operation;
        public TypedValue left;
        public TypedValue right;

        public BinaryOperationValue(Type resultType, String operation, TypedValue left, TypedValue right) {
            super(resultType);
            this.operation = operation;
            this.left = left;
            this.right = right;
        }

        public String toString() {
            return "(" + this.left.toString() + " " + this.operation + " " + this.right.toString() + ")";
        }

        @Override
        public <I, O, E extends Exception> O visit(TypedValueVisitor<I, O, E> visitor, I input) throws E {
            return visitor.binaryOpValue(this, input);
        }

        public BinaryOperationValue withNewChildren(TypedValue newLeft, TypedValue newRight) {
            return new BinaryOperationValue(this.type, this.operation, newLeft, newRight);
        }
    }

    public static class CastValue
    extends UnaryOperationValue {
        public CastValue(Type castedType, TypedValue base) {
            super(castedType, base);
        }

        public String toString() {
            return "((" + this.type.getClassName() + ")" + this.operand + ")";
        }

        @Override
        public <I, O, E extends Exception> O visit(TypedValueVisitor<I, O, E> visitor, I input) throws E {
            return visitor.castValue(this, input);
        }

        @Override
        public CastValue withNewChildren(TypedValue newOperand) {
            return new CastValue(this.type, newOperand);
        }
    }

    public static class GetFieldValue
    extends UnaryOperationValue {
        public String owner;
        public String name;
        public String desc;

        public GetFieldValue(String owner, String name, String desc, TypedValue base) {
            super(Type.getType((String)desc), base);
            this.owner = owner;
            this.name = name;
            this.desc = desc;
        }

        public String toString() {
            return "(" + this.operand + "." + this.name + ")";
        }

        @Override
        public <I, O, E extends Exception> O visit(TypedValueVisitor<I, O, E> visitor, I input) throws E {
            return visitor.getFieldValue(this, input);
        }

        @Override
        public GetFieldValue withNewChildren(TypedValue newOperand) {
            return new GetFieldValue(this.owner, this.name, this.desc, newOperand);
        }
    }

    public static class NotValue
    extends UnaryOperationValue {
        public NotValue(TypedValue operand) {
            super(Type.BOOLEAN_TYPE, operand);
        }

        public String toString() {
            return "(NOT " + this.operand.toString() + ")";
        }

        @Override
        public <I, O, E extends Exception> O visit(TypedValueVisitor<I, O, E> visitor, I input) throws E {
            return visitor.notOpValue(this, input);
        }

        @Override
        public UnaryOperationValue withNewChildren(TypedValue newOperand) {
            return new NotValue(newOperand);
        }
    }

    public static class UnaryMathOpValue
    extends UnaryOperationValue {
        public UnaryOp op;

        public UnaryMathOpValue(UnaryOp op, Type resultType, TypedValue operand) {
            super(resultType, operand);
            this.op = op;
        }

        public String toString() {
            return "(" + this.op.getOpString() + " " + this.operand.toString() + ")";
        }

        @Override
        public <I, O, E extends Exception> O visit(TypedValueVisitor<I, O, E> visitor, I input) throws E {
            return visitor.unaryMathOpValue(this, input);
        }

        @Override
        public UnaryOperationValue withNewChildren(TypedValue newOperand) {
            return new UnaryMathOpValue(this.op, this.type, newOperand);
        }

        public static enum UnaryOp {
            neg("-");

            String str;

            private UnaryOp(String str) {
                this.str = str;
            }

            public String getOpString() {
                return this.str;
            }
        }
    }

    public static class UnaryOperationValue
    extends TypedValue {
        public TypedValue operand;

        public UnaryOperationValue(Type resultType, TypedValue operand) {
            super(resultType);
            this.operand = operand;
        }

        @Override
        public <I, O, E extends Exception> O visit(TypedValueVisitor<I, O, E> visitor, I input) throws E {
            return visitor.unaryOpValue(this, input);
        }

        public UnaryOperationValue withNewChildren(TypedValue newOperand) {
            return new UnaryOperationValue(this.type, newOperand);
        }
    }

    public static class GetStaticFieldValue
    extends TypedValue {
        public String owner;
        public String name;
        public String desc;

        public GetStaticFieldValue(String owner, String name, String desc) {
            super(Type.getType((String)desc));
            this.owner = owner;
            this.name = name;
            this.desc = desc;
        }

        public String toString() {
            return "(" + this.owner + "." + this.name + ")";
        }

        @Override
        public <I, O, E extends Exception> O visit(TypedValueVisitor<I, O, E> visitor, I input) throws E {
            return visitor.getStaticFieldValue(this, input);
        }
    }

    public static class NewValue
    extends TypedValue {
        public NewValue(String classInternalName) {
            super(Type.getObjectType((String)classInternalName));
        }

        public String toString() {
            return "new " + this.type.getClassName();
        }

        @Override
        public <I, O, E extends Exception> O visit(TypedValueVisitor<I, O, E> visitor, I input) throws E {
            return visitor.newValue(this, input);
        }
    }

    public static class ArgValue
    extends TypedValue {
        int index;

        public ArgValue(Type t, int index) {
            super(t);
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        public String toString() {
            return "@arg" + this.index;
        }

        @Override
        public <I, O, E extends Exception> O visit(TypedValueVisitor<I, O, E> visitor, I input) throws E {
            return visitor.argValue(this, input);
        }
    }

    public static class ThisValue
    extends TypedValue {
        public ThisValue(Type t) {
            super(t);
        }

        public String toString() {
            return "this";
        }

        @Override
        public <I, O, E extends Exception> O visit(TypedValueVisitor<I, O, E> visitor, I input) throws E {
            return visitor.thisValue(this, input);
        }
    }
}

