/*
 * Decompiled with CFR 0.152.
 */
package org.jinq.orm.stream;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Spliterators;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jinq.orm.stream.InQueryStreamSource;
import org.jinq.orm.stream.JinqStream;
import org.jinq.orm.stream.LazyWrappedStream;
import org.jinq.orm.stream.NextOnlyIterator;
import org.jinq.tuples.Pair;
import org.jinq.tuples.Tuple;
import org.jinq.tuples.Tuple3;
import org.jinq.tuples.Tuple4;
import org.jinq.tuples.Tuple5;
import org.jinq.tuples.Tuple6;
import org.jinq.tuples.Tuple7;
import org.jinq.tuples.Tuple8;

public class NonQueryJinqStream<T>
extends LazyWrappedStream<T>
implements JinqStream<T> {
    protected InQueryStreamSource inQueryStreamSource;
    protected Map<Object, Throwable> recordedExceptions = new HashMap<Object, Throwable>();

    public NonQueryJinqStream(Stream<T> wrapped) {
        this(wrapped, null);
    }

    public NonQueryJinqStream(Stream<T> wrapped, InQueryStreamSource inQueryStreamSource) {
        super(wrapped);
        this.inQueryStreamSource = inQueryStreamSource;
    }

    NonQueryJinqStream() {
        this((InQueryStreamSource)null);
    }

    NonQueryJinqStream(InQueryStreamSource inQueryStreamSource) {
        this.inQueryStreamSource = inQueryStreamSource;
    }

    @Override
    protected <U> JinqStream<U> wrap(Stream<U> toWrap) {
        return new NonQueryJinqStream<U>(toWrap, this.inQueryStreamSource);
    }

    @Override
    public <E extends Exception> JinqStream<T> where(JinqStream.Where<T, E> test) {
        return this.wrap(this.filter(val -> {
            try {
                return test.where(val);
            }
            catch (Exception e) {
                this.propagateException(test, e);
                throw new RuntimeException(e);
            }
        }));
    }

    @Override
    public <E extends Exception> JinqStream<T> where(JinqStream.WhereWithSource<T, E> test) {
        return this.wrap(this.filter(val -> {
            try {
                return test.where(val, this.inQueryStreamSource);
            }
            catch (Exception e) {
                this.propagateException(test, e);
                throw new RuntimeException(e);
            }
        }));
    }

    @Override
    public <U> JinqStream<U> select(JinqStream.Select<T, U> select) {
        return this.wrap(this.map(val -> select.select(val)));
    }

    @Override
    public <U> JinqStream<U> select(JinqStream.SelectWithSource<T, U> select) {
        return this.wrap(this.map(val -> select.select(val, this.inQueryStreamSource)));
    }

    @Override
    public <U> JinqStream<U> selectAll(JinqStream.Join<T, U> select) {
        return this.wrap(this.flatMap(val -> select.join(val)));
    }

    @Override
    public <U> JinqStream<U> selectAll(JinqStream.JoinWithSource<T, U> select) {
        return this.wrap(this.flatMap(val -> select.join(val, this.inQueryStreamSource)));
    }

    @Override
    public <U> JinqStream<U> selectAllList(JinqStream.JoinToIterable<T, U> select) {
        return this.wrap(this.flatMap(val -> StreamSupport.stream(select.join(val).spliterator(), false)));
    }

    @Override
    public <U> JinqStream<Pair<T, U>> join(JinqStream.Join<T, U> join) {
        Stream.Builder streamBuilder = Stream.builder();
        this.forEach(left -> join.join(left).forEach(right -> streamBuilder.accept(new Pair<Object, Object>(left, right))));
        return this.wrap(streamBuilder.build());
    }

    @Override
    public <U> JinqStream<Pair<T, U>> join(JinqStream.JoinWithSource<T, U> join) {
        Stream.Builder streamBuilder = Stream.builder();
        this.forEach(left -> join.join(left, this.inQueryStreamSource).forEach(right -> streamBuilder.accept(new Pair<Object, Object>(left, right))));
        return this.wrap(streamBuilder.build());
    }

    @Override
    public <U> JinqStream<Pair<T, U>> joinList(JinqStream.JoinToIterable<T, U> join) {
        Stream.Builder streamBuilder = Stream.builder();
        this.forEach(left -> {
            for (Object right : join.join(left)) {
                streamBuilder.accept(new Pair(left, right));
            }
        });
        return this.wrap(streamBuilder.build());
    }

    @Override
    public <U> JinqStream<Pair<T, U>> leftOuterJoin(JinqStream.Join<T, U> join) {
        Stream.Builder streamBuilder = Stream.builder();
        this.forEach(left -> {
            if (join.join(left).count() > 0L) {
                join.join(left).forEach(right -> streamBuilder.accept(new Pair<Object, Object>(left, right)));
            } else {
                streamBuilder.accept(new Pair<Object, Object>(left, null));
            }
        });
        return this.wrap(streamBuilder.build());
    }

    @Override
    public <U> JinqStream<Pair<T, U>> leftOuterJoinList(JinqStream.JoinToIterable<T, U> join) {
        Stream.Builder streamBuilder = Stream.builder();
        this.forEach(left -> {
            int count = 0;
            for (Object right : join.join(left)) {
                streamBuilder.accept(new Pair(left, right));
                ++count;
            }
            if (count == 0) {
                streamBuilder.accept(new Pair<Object, Object>(left, null));
            }
        });
        return this.wrap(streamBuilder.build());
    }

    @Override
    public <U> JinqStream<Pair<T, U>> leftOuterJoin(JinqStream.JoinWithSource<T, U> join, JinqStream.WhereForOn<T, U> on) {
        Stream.Builder streamBuilder = Stream.builder();
        this.forEach(left -> {
            AtomicBoolean wasMatched = new AtomicBoolean();
            join.join(left, this.inQueryStreamSource).forEach(right -> {
                if (on.where(left, right)) {
                    wasMatched.set(true);
                    streamBuilder.accept(new Pair<Object, Object>(left, right));
                }
            });
            if (!wasMatched.get()) {
                streamBuilder.accept(new Pair<Object, Object>(left, null));
            }
        });
        return this.wrap(streamBuilder.build());
    }

    @Override
    public <U> JinqStream<Pair<T, U>> crossJoin(JinqStream<U> join) {
        List saved = join.toList();
        Stream.Builder streamBuilder = Stream.builder();
        this.forEach(left -> saved.stream().forEach(right -> streamBuilder.accept(new Pair<Object, Object>(left, right))));
        return this.wrap(streamBuilder.build());
    }

    protected <U, W extends Tuple> JinqStream<W> groupToTuple(JinqStream.Select<T, U> select, JinqStream.AggregateGroup<U, T, ?>[] aggregates) {
        Map<Object, List<Object>> groups = this.collect(Collectors.groupingBy(in -> select.select(in)));
        Stream.Builder streamBuilder = Stream.builder();
        for (Map.Entry<Object, List<Object>> entry : groups.entrySet()) {
            Object[] groupAggregates = new Object[aggregates.length + 1];
            for (int n = 0; n < aggregates.length; ++n) {
                groupAggregates[n + 1] = aggregates[n].aggregateSelect((U)entry.getKey(), (JinqStream<T>)this.wrap(entry.getValue().stream()));
            }
            groupAggregates[0] = entry.getKey();
            streamBuilder.accept(Tuple.createTuple(groupAggregates));
        }
        return this.wrap(streamBuilder.build());
    }

    @Override
    public <U, V> JinqStream<Pair<U, V>> group(JinqStream.Select<T, U> select, JinqStream.AggregateGroup<U, T, V> aggregate) {
        JinqStream.AggregateGroup[] aggregates = new JinqStream.AggregateGroup[]{aggregate};
        return this.groupToTuple(select, aggregates);
    }

    @Override
    public <U, V, W> JinqStream<Tuple3<U, V, W>> group(JinqStream.Select<T, U> select, JinqStream.AggregateGroup<U, T, V> aggregate1, JinqStream.AggregateGroup<U, T, W> aggregate2) {
        JinqStream.AggregateGroup[] aggregates = new JinqStream.AggregateGroup[]{aggregate1, aggregate2};
        return this.groupToTuple(select, aggregates);
    }

    @Override
    public <U, V, W, X> JinqStream<Tuple4<U, V, W, X>> group(JinqStream.Select<T, U> select, JinqStream.AggregateGroup<U, T, V> aggregate1, JinqStream.AggregateGroup<U, T, W> aggregate2, JinqStream.AggregateGroup<U, T, X> aggregate3) {
        JinqStream.AggregateGroup[] aggregates = new JinqStream.AggregateGroup[]{aggregate1, aggregate2, aggregate3};
        return this.groupToTuple(select, aggregates);
    }

    @Override
    public <U, V, W, X, Y> JinqStream<Tuple5<U, V, W, X, Y>> group(JinqStream.Select<T, U> select, JinqStream.AggregateGroup<U, T, V> aggregate1, JinqStream.AggregateGroup<U, T, W> aggregate2, JinqStream.AggregateGroup<U, T, X> aggregate3, JinqStream.AggregateGroup<U, T, Y> aggregate4) {
        JinqStream.AggregateGroup[] aggregates = new JinqStream.AggregateGroup[]{aggregate1, aggregate2, aggregate3, aggregate4};
        return this.groupToTuple(select, aggregates);
    }

    @Override
    public <U, V, W, X, Y, Z> JinqStream<Tuple6<U, V, W, X, Y, Z>> group(JinqStream.Select<T, U> select, JinqStream.AggregateGroup<U, T, V> aggregate1, JinqStream.AggregateGroup<U, T, W> aggregate2, JinqStream.AggregateGroup<U, T, X> aggregate3, JinqStream.AggregateGroup<U, T, Y> aggregate4, JinqStream.AggregateGroup<U, T, Z> aggregate5) {
        JinqStream.AggregateGroup[] aggregates = new JinqStream.AggregateGroup[]{aggregate1, aggregate2, aggregate3, aggregate4, aggregate5};
        return this.groupToTuple(select, aggregates);
    }

    @Override
    public <U, V, W, X, Y, Z, A> JinqStream<Tuple7<U, V, W, X, Y, Z, A>> group(JinqStream.Select<T, U> select, JinqStream.AggregateGroup<U, T, V> aggregate1, JinqStream.AggregateGroup<U, T, W> aggregate2, JinqStream.AggregateGroup<U, T, X> aggregate3, JinqStream.AggregateGroup<U, T, Y> aggregate4, JinqStream.AggregateGroup<U, T, Z> aggregate5, JinqStream.AggregateGroup<U, T, A> aggregate6) {
        JinqStream.AggregateGroup[] aggregates = new JinqStream.AggregateGroup[]{aggregate1, aggregate2, aggregate3, aggregate4, aggregate5, aggregate6};
        return this.groupToTuple(select, aggregates);
    }

    @Override
    public <U, V, W, X, Y, Z, A, B> JinqStream<Tuple8<U, V, W, X, Y, Z, A, B>> group(JinqStream.Select<T, U> select, JinqStream.AggregateGroup<U, T, V> aggregate1, JinqStream.AggregateGroup<U, T, W> aggregate2, JinqStream.AggregateGroup<U, T, X> aggregate3, JinqStream.AggregateGroup<U, T, Y> aggregate4, JinqStream.AggregateGroup<U, T, Z> aggregate5, JinqStream.AggregateGroup<U, T, A> aggregate6, JinqStream.AggregateGroup<U, T, B> aggregate7) {
        JinqStream.AggregateGroup[] aggregates = new JinqStream.AggregateGroup[]{aggregate1, aggregate2, aggregate3, aggregate4, aggregate5, aggregate6, aggregate7};
        return this.groupToTuple(select, aggregates);
    }

    private static <V extends Number> V genericSum(V a, V b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        if (!a.getClass().equals(b.getClass())) {
            throw new IllegalArgumentException("Mismatched number types");
        }
        if (a instanceof Long) {
            return (V)Long.valueOf(a.longValue() + b.longValue());
        }
        if (a instanceof Integer) {
            return (V)Integer.valueOf(a.intValue() + b.intValue());
        }
        if (a instanceof Double) {
            return (V)Double.valueOf(a.doubleValue() + b.doubleValue());
        }
        if (a instanceof BigDecimal) {
            return (V)((BigDecimal)a).add((BigDecimal)b);
        }
        if (a instanceof BigInteger) {
            return (V)((BigInteger)a).add((BigInteger)b);
        }
        throw new IllegalArgumentException("Summing unknown number types");
    }

    @Override
    public Long sumInteger(JinqStream.CollectInteger<T> aggregate) {
        return this.reduce(null, (accum, val) -> NonQueryJinqStream.genericSum(accum, Long.valueOf(((Integer)aggregate.aggregate(val)).intValue())), (accum1, accum2) -> NonQueryJinqStream.genericSum(accum1, accum2));
    }

    @Override
    public Long sumLong(JinqStream.CollectLong<T> aggregate) {
        return this.reduce(null, (accum, val) -> NonQueryJinqStream.genericSum(accum, aggregate.aggregate(val)), (accum1, accum2) -> NonQueryJinqStream.genericSum(accum1, accum2));
    }

    @Override
    public Double sumDouble(JinqStream.CollectDouble<T> aggregate) {
        return this.reduce(null, (accum, val) -> NonQueryJinqStream.genericSum(accum, aggregate.aggregate(val)), (accum1, accum2) -> NonQueryJinqStream.genericSum(accum1, accum2));
    }

    @Override
    public BigDecimal sumBigDecimal(JinqStream.CollectBigDecimal<T> aggregate) {
        return this.reduce(null, (accum, val) -> NonQueryJinqStream.genericSum(accum, aggregate.aggregate(val)), (accum1, accum2) -> NonQueryJinqStream.genericSum(accum1, accum2));
    }

    @Override
    public BigInteger sumBigInteger(JinqStream.CollectBigInteger<T> aggregate) {
        return this.reduce(null, (accum, val) -> NonQueryJinqStream.genericSum(accum, aggregate.aggregate(val)), (accum1, accum2) -> NonQueryJinqStream.genericSum(accum1, accum2));
    }

    private static <V extends Comparable<V>> V genericCompare(boolean isMax, V a, V b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        if (isMax) {
            return a.compareTo(b) <= 0 ? b : a;
        }
        return a.compareTo(b) >= 0 ? b : a;
    }

    @Override
    public <V extends Comparable<V>> V max(JinqStream.CollectComparable<T, V> aggregate) {
        return (V)this.reduce(null, (accum, val) -> NonQueryJinqStream.genericCompare(true, accum, aggregate.aggregate(val)), (accum1, accum2) -> NonQueryJinqStream.genericCompare(true, accum1, accum2));
    }

    @Override
    public <V extends Comparable<V>> V min(JinqStream.CollectComparable<T, V> aggregate) {
        return (V)this.reduce(null, (accum, val) -> NonQueryJinqStream.genericCompare(false, accum, aggregate.aggregate(val)), (accum1, accum2) -> NonQueryJinqStream.genericCompare(false, accum1, accum2));
    }

    @Override
    public <V extends Number> Double avg(JinqStream.CollectNumber<T, V> aggregate) {
        GenericAverage avg = new GenericAverage();
        this.forEach(val -> avg.accumulate(aggregate.aggregate(val)));
        if (avg.count == 0) {
            return null;
        }
        return avg.sum / (double)avg.count;
    }

    @Override
    public <V extends Comparable<V>> JinqStream<T> sortedBy(JinqStream.CollectComparable<T, V> sortField) {
        return this.wrap(this.sorted((o1, o2) -> sortField.aggregate(o1).compareTo(sortField.aggregate(o2))));
    }

    @Override
    public <V extends Comparable<V>> JinqStream<T> sortedDescendingBy(JinqStream.CollectComparable<T, V> sortField) {
        return this.wrap(this.sorted((o1, o2) -> -sortField.aggregate(o1).compareTo(sortField.aggregate(o2))));
    }

    @Override
    public JinqStream<T> skip(long n) {
        return this.wrap(super.skip(n));
    }

    @Override
    public JinqStream<T> limit(long n) {
        return this.wrap(super.limit(n));
    }

    @Override
    public JinqStream<T> distinct() {
        return this.wrap(this.distinct());
    }

    @Override
    public Optional<T> findOne() {
        List vals = this.collect(Collectors.toList());
        if (vals.isEmpty()) {
            return Optional.empty();
        }
        if (vals.size() == 1) {
            return Optional.of(vals.get(0));
        }
        throw new NoSuchElementException();
    }

    @Override
    public T getOnlyValue() {
        List vals = this.collect(Collectors.toList());
        if (vals.size() == 1) {
            return vals.get(0);
        }
        throw new NoSuchElementException();
    }

    @Override
    public List<T> toList() {
        return this.collect(Collectors.toList());
    }

    @Override
    public String getDebugQueryString() {
        return null;
    }

    @Override
    public void propagateException(Object source, Throwable exception) {
        if (!this.recordedExceptions.containsKey(source)) {
            this.recordedExceptions.put(source, exception);
        }
    }

    @Override
    public Collection<Throwable> getExceptions() {
        return this.recordedExceptions.values();
    }

    @Override
    public <U, V> Pair<U, V> aggregate(JinqStream.AggregateSelect<T, U> aggregate1, JinqStream.AggregateSelect<T, V> aggregate2) {
        JinqStream.AggregateSelect[] aggregates = new JinqStream.AggregateSelect[]{aggregate1, aggregate2};
        return (Pair)this.multiaggregate(aggregates);
    }

    @Override
    public <U, V, W> Tuple3<U, V, W> aggregate(JinqStream.AggregateSelect<T, U> aggregate1, JinqStream.AggregateSelect<T, V> aggregate2, JinqStream.AggregateSelect<T, W> aggregate3) {
        JinqStream.AggregateSelect[] aggregates = new JinqStream.AggregateSelect[]{aggregate1, aggregate2, aggregate3};
        return (Tuple3)this.multiaggregate(aggregates);
    }

    @Override
    public <U, V, W, X> Tuple4<U, V, W, X> aggregate(JinqStream.AggregateSelect<T, U> aggregate1, JinqStream.AggregateSelect<T, V> aggregate2, JinqStream.AggregateSelect<T, W> aggregate3, JinqStream.AggregateSelect<T, X> aggregate4) {
        JinqStream.AggregateSelect[] aggregates = new JinqStream.AggregateSelect[]{aggregate1, aggregate2, aggregate3, aggregate4};
        return (Tuple4)this.multiaggregate(aggregates);
    }

    @Override
    public <U, V, W, X, Y> Tuple5<U, V, W, X, Y> aggregate(JinqStream.AggregateSelect<T, U> aggregate1, JinqStream.AggregateSelect<T, V> aggregate2, JinqStream.AggregateSelect<T, W> aggregate3, JinqStream.AggregateSelect<T, X> aggregate4, JinqStream.AggregateSelect<T, Y> aggregate5) {
        JinqStream.AggregateSelect[] aggregates = new JinqStream.AggregateSelect[]{aggregate1, aggregate2, aggregate3, aggregate4, aggregate5};
        return (Tuple5)this.multiaggregate(aggregates);
    }

    <U extends Tuple> U multiaggregate(JinqStream.AggregateSelect<T, ?>[] aggregates) {
        int n;
        final IteratorTee tee = new IteratorTee(this, aggregates.length);
        Thread[] aggregateThreads = new Thread[aggregates.length];
        final Object[] results = new Object[aggregates.length];
        for (n = 0; n < aggregates.length; ++n) {
            final int idx = n;
            final JinqStream.AggregateSelect<T, ?> fn = aggregates[idx];
            aggregateThreads[n] = new Thread(){

                @Override
                public void run() {
                    Stream stream = NonQueryJinqStream.this.wrap(StreamSupport.stream(Spliterators.spliteratorUnknownSize(tee.createIterator(idx), 4096), false));
                    results[idx] = fn.aggregateSelect(stream);
                }
            };
            aggregateThreads[n].start();
        }
        for (n = 0; n < aggregateThreads.length; ++n) {
            try {
                aggregateThreads[n].join();
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        return (U)Tuple.createTuple(results);
    }

    @Override
    public JinqStream<T> setHint(String name, Object value) {
        return this;
    }

    public static class IteratorTee<T> {
        static final int MAX_QUEUE_SIZE = 100;
        final Object DONE = new Object();
        ArrayBlockingQueue<Object>[] outputQueues;
        Stream<T> inputStream;
        boolean isStarted = false;

        public IteratorTee(Stream<T> inputStream, int size) {
            this.inputStream = inputStream;
            this.outputQueues = new ArrayBlockingQueue[size];
            for (int n = 0; n < size; ++n) {
                this.outputQueues[n] = new ArrayBlockingQueue(100);
            }
        }

        synchronized void startInputStreamPump() {
            if (this.isStarted) {
                return;
            }
            this.isStarted = true;
            new Thread(){

                @Override
                public void run() {
                    inputStream.forEach(val -> {
                        for (int n = 0; n < outputQueues.length; ++n) {
                            try {
                                outputQueues[n].put(val);
                                continue;
                            }
                            catch (InterruptedException e) {
                                Thread.currentThread().interrupt();
                            }
                        }
                    });
                    try {
                        for (int n = 0; n < outputQueues.length; ++n) {
                            outputQueues[n].put(DONE);
                        }
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
            }.start();
        }

        public Iterator<T> createIterator(final int idx) {
            return new NextOnlyIterator<T>(){

                @Override
                protected void generateNext() {
                    this.startInputStreamPump();
                    Object taken = DONE;
                    try {
                        taken = outputQueues[idx].take();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    if (taken == DONE) {
                        this.noMoreElements();
                    } else {
                        this.nextElement(taken);
                    }
                }
            };
        }
    }

    private static class GenericAverage {
        double sum = 0.0;
        int count = 0;

        private GenericAverage() {
        }

        synchronized <V extends Number> void accumulate(V a) {
            if (a == null) {
                return;
            }
            this.sum += a.doubleValue();
            ++this.count;
        }
    }
}

