/*
 * Decompiled with CFR 0.152.
 */
package org.jinq.orm.stream;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jinq.orm.internal.QueryComposer;
import org.jinq.orm.stream.InQueryStreamSource;
import org.jinq.orm.stream.JinqStream;
import org.jinq.orm.stream.NonQueryJinqStream;
import org.jinq.tuples.Pair;
import org.jinq.tuples.Tuple;

public class QueryJinqStream<T>
extends NonQueryJinqStream<T>
implements JinqStream<T> {
    QueryComposer<T> queryComposer;

    public QueryJinqStream(QueryComposer<T> query) {
        this(query, null);
    }

    public QueryJinqStream(QueryComposer<T> query, InQueryStreamSource inQueryStreamSource) {
        super(inQueryStreamSource);
        this.queryComposer = query;
    }

    protected <U> JinqStream<U> makeQueryStream(QueryComposer<U> query, InQueryStreamSource inQueryStreamSource) {
        return new QueryJinqStream<U>(query, inQueryStreamSource);
    }

    @Override
    protected Stream<T> createWrappedStream() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.queryComposer.executeAndReturnResultIterator(err -> this.propagateException(this, (Throwable)err)), 4096), false);
    }

    @Override
    public <E extends Exception> JinqStream<T> where(JinqStream.Where<T, E> test) {
        QueryComposer<T> newComposer = this.queryComposer.where(test);
        if (newComposer != null) {
            return this.makeQueryStream(newComposer, this.inQueryStreamSource);
        }
        return super.where(test);
    }

    @Override
    public <E extends Exception> JinqStream<T> where(JinqStream.WhereWithSource<T, E> test) {
        QueryComposer<T> newComposer = this.queryComposer.whereWithSource(test);
        if (newComposer != null) {
            return this.makeQueryStream(newComposer, this.inQueryStreamSource);
        }
        return super.where(test);
    }

    @Override
    public <U> JinqStream<U> select(JinqStream.Select<T, U> select) {
        QueryComposer newComposer = this.queryComposer.select(select);
        if (newComposer != null) {
            return this.makeQueryStream(newComposer, this.inQueryStreamSource);
        }
        return super.select(select);
    }

    @Override
    public <U> JinqStream<U> select(JinqStream.SelectWithSource<T, U> select) {
        QueryComposer newComposer = this.queryComposer.selectWithSource(select);
        if (newComposer != null) {
            return this.makeQueryStream(newComposer, this.inQueryStreamSource);
        }
        return super.select(select);
    }

    @Override
    public <U> JinqStream<U> selectAll(JinqStream.Join<T, U> select) {
        QueryComposer newComposer = this.queryComposer.selectAll(select);
        if (newComposer != null) {
            return this.makeQueryStream(newComposer, this.inQueryStreamSource);
        }
        return super.selectAll(select);
    }

    @Override
    public <U> JinqStream<U> selectAll(JinqStream.JoinWithSource<T, U> select) {
        QueryComposer newComposer = this.queryComposer.selectAllWithSource(select);
        if (newComposer != null) {
            return this.makeQueryStream(newComposer, this.inQueryStreamSource);
        }
        return super.selectAll(select);
    }

    @Override
    public <U> JinqStream<U> selectAllList(JinqStream.JoinToIterable<T, U> select) {
        QueryComposer newComposer = this.queryComposer.selectAllIterable(select);
        if (newComposer != null) {
            return this.makeQueryStream(newComposer, this.inQueryStreamSource);
        }
        return super.selectAllList(select);
    }

    @Override
    public <U> JinqStream<Pair<T, U>> join(JinqStream.Join<T, U> join) {
        QueryComposer<Pair<T, U>> newComposer = this.queryComposer.join(join);
        if (newComposer != null) {
            return this.makeQueryStream(newComposer, this.inQueryStreamSource);
        }
        return super.join(join);
    }

    @Override
    public <U> JinqStream<Pair<T, U>> join(JinqStream.JoinWithSource<T, U> join) {
        QueryComposer<Pair<T, U>> newComposer = this.queryComposer.joinWithSource(join);
        if (newComposer != null) {
            return this.makeQueryStream(newComposer, this.inQueryStreamSource);
        }
        return super.join(join);
    }

    @Override
    public <U> JinqStream<Pair<T, U>> joinList(JinqStream.JoinToIterable<T, U> join) {
        QueryComposer<Pair<T, U>> newComposer = this.queryComposer.joinIterable(join);
        if (newComposer != null) {
            return this.makeQueryStream(newComposer, this.inQueryStreamSource);
        }
        return super.joinList(join);
    }

    @Override
    public <U> JinqStream<Pair<T, U>> leftOuterJoin(JinqStream.Join<T, U> join) {
        QueryComposer<Pair<T, U>> newComposer = this.queryComposer.leftOuterJoin(join);
        if (newComposer != null) {
            return this.makeQueryStream(newComposer, this.inQueryStreamSource);
        }
        return super.leftOuterJoin(join);
    }

    @Override
    public <U> JinqStream<Pair<T, U>> leftOuterJoinList(JinqStream.JoinToIterable<T, U> join) {
        QueryComposer<Pair<T, U>> newComposer = this.queryComposer.leftOuterJoinIterable(join);
        if (newComposer != null) {
            return this.makeQueryStream(newComposer, this.inQueryStreamSource);
        }
        return super.leftOuterJoinList(join);
    }

    @Override
    public <U> JinqStream<Pair<T, U>> leftOuterJoin(JinqStream.JoinWithSource<T, U> join, JinqStream.WhereForOn<T, U> on) {
        QueryComposer<Pair<T, U>> newComposer = this.queryComposer.leftOuterJoinWithSource(join, on);
        if (newComposer != null) {
            return this.makeQueryStream(newComposer, this.inQueryStreamSource);
        }
        return super.leftOuterJoin(join, on);
    }

    @Override
    public <U> JinqStream<Pair<T, U>> crossJoin(JinqStream<U> join) {
        QueryComposer<Pair<T, U>> newComposer = this.queryComposer.crossJoin(join);
        if (newComposer != null) {
            return this.makeQueryStream(newComposer, this.inQueryStreamSource);
        }
        return super.crossJoin(join);
    }

    @Override
    protected <U, W extends Tuple> JinqStream<W> groupToTuple(JinqStream.Select<T, U> select, JinqStream.AggregateGroup<U, T, ?>[] aggregates) {
        QueryComposer newComposer = this.queryComposer.groupToTuple(select, aggregates);
        if (newComposer != null) {
            return this.makeQueryStream(newComposer, this.inQueryStreamSource);
        }
        return super.groupToTuple(select, aggregates);
    }

    @Override
    public long count() {
        Long count = this.queryComposer.count();
        if (count != null) {
            return count;
        }
        return super.count();
    }

    @Override
    public Long sumInteger(JinqStream.CollectInteger<T> aggregate) {
        Long val = (Long)this.queryComposer.sum(aggregate, Integer.class);
        if (val != null) {
            return val;
        }
        return super.sumInteger(aggregate);
    }

    @Override
    public Long sumLong(JinqStream.CollectLong<T> aggregate) {
        Long val = (Long)this.queryComposer.sum(aggregate, Long.class);
        if (val != null) {
            return val;
        }
        return super.sumLong(aggregate);
    }

    @Override
    public Double sumDouble(JinqStream.CollectDouble<T> aggregate) {
        Double val = (Double)this.queryComposer.sum(aggregate, Double.class);
        if (val != null) {
            return val;
        }
        return super.sumDouble(aggregate);
    }

    @Override
    public BigDecimal sumBigDecimal(JinqStream.CollectBigDecimal<T> aggregate) {
        BigDecimal val = (BigDecimal)this.queryComposer.sum(aggregate, BigDecimal.class);
        if (val != null) {
            return val;
        }
        return super.sumBigDecimal(aggregate);
    }

    @Override
    public BigInteger sumBigInteger(JinqStream.CollectBigInteger<T> aggregate) {
        BigInteger val = (BigInteger)this.queryComposer.sum(aggregate, BigInteger.class);
        if (val != null) {
            return val;
        }
        return super.sumBigInteger(aggregate);
    }

    @Override
    public <V extends Comparable<V>> V max(JinqStream.CollectComparable<T, V> aggregate) {
        Object val = this.queryComposer.max(aggregate);
        if (val != null) {
            return val;
        }
        return super.max(aggregate);
    }

    @Override
    public <V extends Comparable<V>> V min(JinqStream.CollectComparable<T, V> aggregate) {
        Object val = this.queryComposer.min(aggregate);
        if (val != null) {
            return val;
        }
        return super.min(aggregate);
    }

    @Override
    public <V extends Number> Double avg(JinqStream.CollectNumber<T, V> aggregate) {
        Double val = this.queryComposer.avg(aggregate);
        if (val != null) {
            return val;
        }
        return super.avg(aggregate);
    }

    @Override
    public <V extends Comparable<V>> JinqStream<T> sortedBy(JinqStream.CollectComparable<T, V> sorter) {
        QueryComposer<T> newComposer = this.queryComposer.sortedBy(sorter, true);
        if (newComposer != null) {
            return this.makeQueryStream(newComposer, this.inQueryStreamSource);
        }
        return super.sortedBy(sorter);
    }

    @Override
    public <V extends Comparable<V>> JinqStream<T> sortedDescendingBy(JinqStream.CollectComparable<T, V> sorter) {
        QueryComposer<T> newComposer = this.queryComposer.sortedBy(sorter, false);
        if (newComposer != null) {
            return this.makeQueryStream(newComposer, this.inQueryStreamSource);
        }
        return super.sortedDescendingBy(sorter);
    }

    @Override
    public JinqStream<T> limit(long n) {
        QueryComposer<T> newComposer = this.queryComposer.limit(n);
        if (newComposer != null) {
            return this.makeQueryStream(newComposer, this.inQueryStreamSource);
        }
        return super.limit(n);
    }

    @Override
    public JinqStream<T> skip(long n) {
        QueryComposer<T> newComposer = this.queryComposer.skip(n);
        if (newComposer != null) {
            return this.makeQueryStream(newComposer, this.inQueryStreamSource);
        }
        return super.skip(n);
    }

    @Override
    public JinqStream<T> distinct() {
        QueryComposer<T> newComposer = this.queryComposer.distinct();
        if (newComposer != null) {
            return this.makeQueryStream(newComposer, this.inQueryStreamSource);
        }
        return super.distinct();
    }

    @Override
    public String getDebugQueryString() {
        return this.queryComposer.getDebugQueryString();
    }

    @Override
    <U extends Tuple> U multiaggregate(JinqStream.AggregateSelect<T, ?>[] aggregates) {
        Object vals = this.queryComposer.multiaggregate(aggregates);
        if (vals != null) {
            return vals;
        }
        return super.multiaggregate(aggregates);
    }

    @Override
    public JinqStream<T> setHint(String name, Object value) {
        this.queryComposer.setHint(name, value);
        return this;
    }
}

