/*
 * Decompiled with CFR 0.152.
 */
package org.xmpp.jnodes.smack;

import java.io.IOException;
import java.util.IllegalFormatException;
import org.jivesoftware.smack.packet.IqData;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.provider.IqProvider;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.xmpp.jnodes.smack.JingleChannelIQ;

public class JingleNodesProvider
extends IqProvider<JingleChannelIQ> {
    public JingleChannelIQ parse(XmlPullParser parser, int initialDepth, IqData iqData, XmlEnvironment xmlEnvironment) throws XmlPullParserException, IOException {
        JingleChannelIQ iq = null;
        boolean done = false;
        while (!done) {
            XmlPullParser.Event eventType = parser.getEventType();
            String elementName = parser.getName();
            String namespace = parser.getNamespace();
            if (eventType == XmlPullParser.Event.START_ELEMENT) {
                if (elementName.equals("channel") && namespace.equals("http://jabber.org/protocol/jinglenodes#channel")) {
                    String protocol = parser.getAttributeValue(null, "protocol");
                    String porta = parser.getAttributeValue(null, "localport");
                    String portb = parser.getAttributeValue(null, "remoteport");
                    String host = parser.getAttributeValue(null, "host");
                    try {
                        iq = new JingleChannelIQ();
                        iq.setProtocol(protocol == null ? "udp" : protocol);
                        if (host != null) {
                            iq.setHost(host);
                        }
                        if (porta != null) {
                            iq.setLocalport(Integer.parseInt(porta));
                        }
                        if (portb != null) {
                            iq.setRemoteport(Integer.parseInt(portb));
                        }
                    }
                    catch (NumberFormatException | IllegalFormatException e) {
                        e.printStackTrace();
                    }
                }
            } else if (eventType == XmlPullParser.Event.END_ELEMENT) {
                done = true;
            }
            if (done) continue;
            parser.next();
        }
        return iq;
    }
}

