/*
 * Decompiled with CFR 0.152.
 */
package org.xmpp.jnodes.smack;

import java.io.IOException;
import org.jivesoftware.smack.packet.IqData;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.provider.IqProvider;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.impl.JidCreate;
import org.xmpp.jnodes.smack.JingleTrackerIQ;
import org.xmpp.jnodes.smack.TrackerEntry;

public class JingleTrackerProvider
extends IqProvider<JingleTrackerIQ> {
    public JingleTrackerIQ parse(XmlPullParser parser, int initialDepth, IqData iqData, XmlEnvironment xmlEnvironment) throws XmlPullParserException, IOException {
        JingleTrackerIQ iq = new JingleTrackerIQ();
        boolean done = false;
        while (!done) {
            XmlPullParser.Event eventType = parser.getEventType();
            String elementName = parser.getName();
            if (eventType == XmlPullParser.Event.START_ELEMENT) {
                TrackerEntry.Type type;
                if (elementName.equals(TrackerEntry.Type.relay.toString())) {
                    type = TrackerEntry.Type.relay;
                } else if (elementName.equals(TrackerEntry.Type.tracker.toString())) {
                    type = TrackerEntry.Type.tracker;
                } else {
                    parser.next();
                    continue;
                }
                String protocol = parser.getAttributeValue(null, "protocol");
                TrackerEntry.Policy policy = TrackerEntry.Policy.valueOf("_" + parser.getAttributeValue(null, "policy"));
                Jid address = JidCreate.from((String)parser.getAttributeValue(null, "address"));
                String verified = parser.getAttributeValue(null, "verified");
                if (address != null && address.length() > 0) {
                    TrackerEntry entry = new TrackerEntry(type, policy, address, protocol);
                    if (verified != null && verified.equals("true")) {
                        entry.setVerified(true);
                    }
                    iq.addEntry(entry);
                }
            } else if (eventType == XmlPullParser.Event.END_ELEMENT && elementName.equals("services")) {
                done = true;
            }
            if (done) continue;
            parser.next();
        }
        return iq;
    }
}

