/*
 * Decompiled with CFR 0.152.
 */
package org.xmpp.jnodes.smack;

import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.jivesoftware.smack.AbstractXMPPConnection;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.StanzaCollector;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.filter.StanzaIdFilter;
import org.jivesoftware.smack.iqrequest.AbstractIqRequestHandler;
import org.jivesoftware.smack.iqrequest.IQRequestHandler;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.provider.ProviderManager;
import org.jivesoftware.smack.roster.Roster;
import org.jivesoftware.smack.roster.RosterEntry;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.disco.packet.DiscoverItems;
import org.jivesoftware.smackx.iqregister.AccountManager;
import org.jxmpp.jid.DomainBareJid;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.parts.Localpart;
import org.xmpp.jnodes.RelayChannel;
import org.xmpp.jnodes.smack.JingleChannelIQ;
import org.xmpp.jnodes.smack.JingleNodesProvider;
import org.xmpp.jnodes.smack.JingleTrackerIQ;
import org.xmpp.jnodes.smack.JingleTrackerProvider;
import org.xmpp.jnodes.smack.TrackerEntry;

public class SmackServiceNode
implements ConnectionListener {
    private final AbstractXMPPConnection connection;
    private final ConcurrentHashMap<String, RelayChannel> channels = new ConcurrentHashMap();
    private final Map<Jid, TrackerEntry> trackerEntries = Collections.synchronizedMap(new LinkedHashMap());
    private final long timeout;
    private static final ExecutorService executorService = Executors.newCachedThreadPool();
    private final ScheduledThreadPoolExecutor scheduledExecutor = new ScheduledThreadPoolExecutor(1);
    private final AtomicInteger ids = new AtomicInteger(0);

    public SmackServiceNode(AbstractXMPPConnection connection, long timeout) {
        this.connection = connection;
        this.timeout = timeout;
        this.setup();
    }

    public void connect(Localpart user, String password) throws XMPPException, SmackException, IOException, InterruptedException {
        this.connect(user, password, false, Roster.SubscriptionMode.accept_all);
    }

    public void connect(Localpart user, String password, boolean tryCreateAccount, Roster.SubscriptionMode mode) throws XMPPException, SmackException, IOException, InterruptedException {
        this.connection.addConnectionListener((ConnectionListener)this);
        this.connection.connect();
        if (tryCreateAccount) {
            try {
                try {
                    AccountManager.getInstance((XMPPConnection)this.connection).createAccount(user, password);
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {}
            }
            catch (SmackException.NoResponseException | SmackException.NotConnectedException | XMPPException throwable) {
                // empty catch block
            }
        }
        this.connection.login((CharSequence)user, password);
        Roster.getInstanceFor((XMPPConnection)this.connection).setSubscriptionMode(mode);
        this.setup();
    }

    private void setup() {
        this.scheduledExecutor.scheduleWithFixedDelay(() -> {
            for (RelayChannel c : this.channels.values()) {
                long current = System.currentTimeMillis();
                long da = current - c.getLastReceivedTimeA();
                long db = current - c.getLastReceivedTimeB();
                if (da <= this.timeout && db <= this.timeout) continue;
                this.removeChannel(c);
            }
        }, this.timeout, this.timeout, TimeUnit.MILLISECONDS);
        ServiceDiscoveryManager.getInstanceFor((XMPPConnection)this.connection).addFeature("http://jabber.org/protocol/jinglenodes#channel");
        this.connection.registerIQRequestHandler((IQRequestHandler)new JingleChannelIqRequestHandler());
        this.connection.registerIQRequestHandler((IQRequestHandler)new JingleTrackerIqRequestHandler());
    }

    public void connectionClosed() {
        this.closeAllChannels();
        this.scheduledExecutor.shutdownNow();
    }

    private void closeAllChannels() {
        for (RelayChannel c : this.channels.values()) {
            this.removeChannel(c);
        }
    }

    private void removeChannel(RelayChannel c) {
        this.channels.remove(c.getAttachment());
        c.close();
    }

    public void connectionClosedOnError(Exception e) {
        this.closeAllChannels();
    }

    protected IQ createUdpChannel(JingleChannelIQ iq) {
        try {
            RelayChannel rc = RelayChannel.createLocalRelayChannel("0.0.0.0", 10000, 40000);
            int id = this.ids.incrementAndGet();
            String sId = String.valueOf(id);
            rc.setAttachment(sId);
            this.channels.put(sId, rc);
            JingleChannelIQ result = new JingleChannelIQ();
            result.setType(IQ.Type.result);
            result.setTo(iq.getFrom());
            result.setFrom(iq.getTo());
            result.setStanzaId(iq.getStanzaId());
            result.setHost(rc.getIp());
            result.setLocalport(rc.getPortA());
            result.setRemoteport(rc.getPortB());
            result.setId(sId);
            return result;
        }
        catch (IOException e) {
            e.printStackTrace();
            return JingleChannelIQ.createEmptyError();
        }
    }

    public AbstractXMPPConnection getConnection() {
        return this.connection;
    }

    public static JingleChannelIQ getChannel(XMPPConnection xmppConnection, Jid serviceNode) throws SmackException.NotConnectedException, InterruptedException {
        if (xmppConnection == null || !xmppConnection.isConnected()) {
            return null;
        }
        JingleChannelIQ iq = new JingleChannelIQ();
        iq.setFrom((Jid)xmppConnection.getUser());
        iq.setTo(serviceNode);
        StanzaCollector collector = xmppConnection.createStanzaCollectorAndSend((IQ)iq);
        JingleChannelIQ result = (JingleChannelIQ)collector.nextResult(Math.round((double)SmackConfiguration.getDefaultReplyTimeout() * 10.5));
        collector.cancel();
        return result;
    }

    public static JingleTrackerIQ getServices(XMPPConnection xmppConnection, Jid serviceNode) throws SmackException.NotConnectedException, InterruptedException {
        if (xmppConnection == null || !xmppConnection.isConnected()) {
            return null;
        }
        JingleTrackerIQ iq = new JingleTrackerIQ();
        iq.setFrom((Jid)xmppConnection.getUser());
        iq.setTo(serviceNode);
        StanzaCollector collector = xmppConnection.createStanzaCollectorAndSend((IQ)iq);
        Stanza result = collector.nextResult(Math.round((double)SmackConfiguration.getDefaultReplyTimeout() * 1.5));
        collector.cancel();
        return result instanceof JingleTrackerIQ ? (JingleTrackerIQ)result : null;
    }

    public static void deepSearch(XMPPConnection xmppConnection, int maxEntries, Jid startPoint, MappedNodes mappedNodes, int maxDepth, int maxSearchNodes, String protocol, ConcurrentHashMap<Jid, Jid> visited) throws SmackException.NotConnectedException, InterruptedException {
        if (xmppConnection == null || !xmppConnection.isConnected()) {
            return;
        }
        if (mappedNodes.getRelayEntries().size() > maxEntries || maxDepth <= 0) {
            return;
        }
        if (startPoint.equals((CharSequence)xmppConnection.getUser())) {
            return;
        }
        if (visited.size() > maxSearchNodes) {
            return;
        }
        JingleTrackerIQ result = SmackServiceNode.getServices(xmppConnection, startPoint);
        visited.put(startPoint, startPoint);
        if (result != null && result.getType().equals((Object)IQ.Type.result)) {
            for (TrackerEntry entry : result.getEntries()) {
                if (entry.getType().equals((Object)TrackerEntry.Type.tracker)) {
                    mappedNodes.getTrackerEntries().put(entry.getJid(), entry);
                    SmackServiceNode.deepSearch(xmppConnection, maxEntries, entry.getJid(), mappedNodes, maxDepth - 1, maxSearchNodes, protocol, visited);
                    continue;
                }
                if (!entry.getType().equals((Object)TrackerEntry.Type.relay) || protocol != null && !protocol.equals(entry.getProtocol())) continue;
                mappedNodes.getRelayEntries().put(entry.getJid(), entry);
            }
        }
    }

    public static Future<MappedNodes> aSyncSearchServices(XMPPConnection xmppConnection, int maxEntries, int maxDepth, int maxSearchNodes, String protocol, boolean searchBuddies) {
        MappedNodes mappedNodes = new MappedNodes();
        Runnable bgTask = () -> {
            try {
                SmackServiceNode.searchServices(new ConcurrentHashMap<Jid, Jid>(), xmppConnection, maxEntries, maxDepth, maxSearchNodes, protocol, searchBuddies, mappedNodes);
            }
            catch (InterruptedException | SmackException.NotConnectedException e) {
                throw new RuntimeException(e);
            }
        };
        return executorService.submit(bgTask, mappedNodes);
    }

    public static MappedNodes searchServices(XMPPConnection xmppConnection, int maxEntries, int maxDepth, int maxSearchNodes, String protocol, boolean searchBuddies) throws SmackException.NotConnectedException, InterruptedException {
        return SmackServiceNode.searchServices(new ConcurrentHashMap<Jid, Jid>(), xmppConnection, maxEntries, maxDepth, maxSearchNodes, protocol, searchBuddies, new MappedNodes());
    }

    private static MappedNodes searchServices(ConcurrentHashMap<Jid, Jid> visited, XMPPConnection xmppConnection, int maxEntries, int maxDepth, int maxSearchNodes, String protocol, boolean searchBuddies, MappedNodes mappedNodes) throws SmackException.NotConnectedException, InterruptedException {
        if (xmppConnection == null || !xmppConnection.isConnected()) {
            return null;
        }
        SmackServiceNode.searchDiscoItems(xmppConnection, maxEntries, xmppConnection.getXMPPServiceDomain(), mappedNodes, maxDepth - 1, maxSearchNodes, protocol, visited);
        SmackServiceNode.deepSearch(xmppConnection, maxEntries, (Jid)xmppConnection.getXMPPServiceDomain(), mappedNodes, maxDepth - 1, maxSearchNodes, protocol, visited);
        Roster roster = Roster.getInstanceFor((XMPPConnection)xmppConnection);
        if (roster != null && searchBuddies) {
            for (RosterEntry re : roster.getEntries()) {
                for (Presence presence : roster.getPresences(re.getJid())) {
                    if (!presence.isAvailable()) continue;
                    SmackServiceNode.deepSearch(xmppConnection, maxEntries, presence.getFrom(), mappedNodes, maxDepth - 1, maxSearchNodes, protocol, visited);
                }
            }
        }
        return mappedNodes;
    }

    private static void searchDiscoItems(XMPPConnection xmppConnection, int maxEntries, DomainBareJid startPoint, MappedNodes mappedNodes, int maxDepth, int maxSearchNodes, String protocol, ConcurrentHashMap<Jid, Jid> visited) throws SmackException.NotConnectedException, InterruptedException {
        DiscoverItems items = new DiscoverItems();
        items.setTo((Jid)startPoint);
        StanzaCollector collector = xmppConnection.createStanzaCollector((StanzaFilter)new StanzaIdFilter(items.getStanzaId()));
        xmppConnection.sendStanza((Stanza)items);
        DiscoverItems result = (DiscoverItems)collector.nextResult(Math.round((double)SmackConfiguration.getDefaultReplyTimeout() * 1.5));
        if (result != null) {
            for (DiscoverItems.Item item : result.getItems()) {
                SmackServiceNode.deepSearch(xmppConnection, maxEntries, item.getEntityID(), mappedNodes, maxDepth, maxSearchNodes, protocol, visited);
            }
        }
        collector.cancel();
    }

    ConcurrentHashMap<String, RelayChannel> getChannels() {
        return this.channels;
    }

    public JingleTrackerIQ createKnownNodes() {
        JingleTrackerIQ iq = new JingleTrackerIQ();
        iq.setType(IQ.Type.result);
        for (TrackerEntry entry : this.trackerEntries.values()) {
            if (entry.getPolicy().equals((Object)TrackerEntry.Policy._roster)) continue;
            iq.addEntry(entry);
        }
        return iq;
    }

    public void addTrackerEntry(TrackerEntry entry) {
        this.trackerEntries.put(entry.getJid(), entry);
    }

    public void addEntries(MappedNodes entries) {
        for (TrackerEntry t : entries.getRelayEntries().values()) {
            this.addTrackerEntry(t);
        }
        for (TrackerEntry t : entries.getTrackerEntries().values()) {
            this.addTrackerEntry(t);
        }
    }

    public Map<Jid, TrackerEntry> getTrackerEntries() {
        return this.trackerEntries;
    }

    public TrackerEntry getPreferedRelay() {
        for (TrackerEntry trackerEntry : this.trackerEntries.values()) {
            if (!TrackerEntry.Type.relay.equals((Object)trackerEntry.getType())) continue;
            return trackerEntry;
        }
        return null;
    }

    public void connected(XMPPConnection connection) {
    }

    public void authenticated(XMPPConnection connection, boolean resumed) {
    }

    static {
        ProviderManager.addIQProvider((String)"channel", (String)"http://jabber.org/protocol/jinglenodes#channel", (Object)((Object)new JingleNodesProvider()));
        ProviderManager.addIQProvider((String)"services", (String)"http://jabber.org/protocol/jinglenodes", (Object)((Object)new JingleTrackerProvider()));
    }

    public static class MappedNodes {
        final Map<Jid, TrackerEntry> relayEntries = Collections.synchronizedMap(new LinkedHashMap());
        final Map<Jid, TrackerEntry> trackerEntries = Collections.synchronizedMap(new LinkedHashMap());

        public Map<Jid, TrackerEntry> getRelayEntries() {
            return this.relayEntries;
        }

        public Map<Jid, TrackerEntry> getTrackerEntries() {
            return this.trackerEntries;
        }
    }

    private class JingleTrackerIqRequestHandler
    extends AbstractIqRequestHandler {
        protected JingleTrackerIqRequestHandler() {
            super("services", "http://jabber.org/protocol/jinglenodes", IQ.Type.get, IQRequestHandler.Mode.sync);
        }

        public IQ handleIQRequest(IQ iqRequest) {
            JingleTrackerIQ result = SmackServiceNode.this.createKnownNodes();
            result.setStanzaId(iqRequest.getStanzaId());
            result.setFrom(iqRequest.getTo());
            result.setTo(iqRequest.getFrom());
            return result;
        }
    }

    private class JingleChannelIqRequestHandler
    extends AbstractIqRequestHandler {
        protected JingleChannelIqRequestHandler() {
            super("channel", "http://jabber.org/protocol/jinglenodes#channel", IQ.Type.get, IQRequestHandler.Mode.sync);
        }

        public IQ handleIQRequest(IQ iqRequest) {
            return SmackServiceNode.this.createUdpChannel((JingleChannelIQ)iqRequest);
        }
    }
}

