/*
 * Decompiled with CFR 0.152.
 */
package org.jiucai.appframework.base.executor;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.jiucai.appframework.base.executor.AppExecutorService;
import org.jiucai.appframework.common.util.LogUtil;
import org.jiucai.appframework.common.util.Logs;

public class AppExecutorServiceFactory {
    protected static Logs logger = LogUtil.getLog(AppExecutorServiceFactory.class);
    private static volatile AppExecutorServiceFactory uniqueInstance;
    private static volatile List<ExecutorService> threadPoolList;
    private static volatile List<AppExecutorService> commandList;

    private AppExecutorServiceFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AppExecutorServiceFactory getInstance() {
        if (null != uniqueInstance) return uniqueInstance;
        Class<AppExecutorServiceFactory> clazz = AppExecutorServiceFactory.class;
        synchronized (AppExecutorServiceFactory.class) {
            if (null != uniqueInstance) return uniqueInstance;
            uniqueInstance = new AppExecutorServiceFactory();
            threadPoolList = new ArrayList<ExecutorService>();
            commandList = new ArrayList<AppExecutorService>();
            // ** MonitorExit[var0] (shouldn't be in output)
            return uniqueInstance;
        }
    }

    public static Boolean addExecutorCommand(AppExecutorService cmd) {
        return AppExecutorServiceFactory.getInstance().getCommandList().add(cmd);
    }

    public static Boolean removeExecutorCommand(AppExecutorService cmd) {
        return AppExecutorServiceFactory.getInstance().getCommandList().remove(cmd);
    }

    public static void shutdown() {
        for (AppExecutorService appExecutorService : AppExecutorServiceFactory.getInstance().getCommandList()) {
            if (null == appExecutorService) continue;
            logger.info("try to shutdown ExecutorService from command: " + appExecutorService.getClass().getName());
            appExecutorService.shutdown();
            logger.info("shutdown ExecutorService: " + appExecutorService.getName());
        }
        for (ExecutorService executorService : AppExecutorServiceFactory.getInstance().getThreadPoolList()) {
            if (null == executorService) continue;
            logger.info("try to shutdown ExecutorService " + executorService);
            executorService.shutdown();
            logger.info("shutdown ExecutorService: " + executorService);
        }
    }

    public static Boolean add(ExecutorService service) {
        return AppExecutorServiceFactory.getInstance().getThreadPoolList().add(service);
    }

    public static Boolean remove(ExecutorService service) {
        return AppExecutorServiceFactory.getInstance().getThreadPoolList().remove(service);
    }

    public List<ExecutorService> getThreadPoolList() {
        return threadPoolList;
    }

    public List<AppExecutorService> getCommandList() {
        return commandList;
    }
}

