/*
 * Decompiled with CFR 0.152.
 */
package org.jiucai.appframework.base.listener;

import java.util.Enumeration;
import javax.servlet.ServletRequestEvent;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.jiucai.appframework.base.listener.AbstractRequestListener;

public abstract class AbstractSecureRequestListener
extends AbstractRequestListener {
    public AbstractSecureRequestListener() {
        this.log.info("AbstractSecureRequestListener inited.");
    }

    @Override
    public void requestInitialized(ServletRequestEvent event) {
        super.requestInitialized(event);
        HttpServletRequest request = (HttpServletRequest)event.getServletRequest();
        this.trimRequestParam(request);
        this.doSecureRequest(request);
    }

    @Override
    public void requestDestroyed(ServletRequestEvent event) {
        super.requestDestroyed(event);
    }

    protected synchronized void trimRequestParam(HttpServletRequest request) {
        Enumeration paramNames = request.getParameterNames();
        if (null != paramNames) {
            while (paramNames.hasMoreElements()) {
                String paramName = (String)paramNames.nextElement();
                String[] paramValues = request.getParameterValues(paramName);
                if (null == paramValues || paramValues.length <= 0) continue;
                if (paramValues.length > 1) {
                    StringBuffer b = new StringBuffer();
                    for (int i = 0; i < paramValues.length; ++i) {
                        String tempVal = StringUtils.isBlank((String)paramValues[i]) ? "" : paramValues[i].trim();
                        b.append(tempVal);
                        if (i == paramValues.length - 1) continue;
                        b.append(",");
                    }
                    request.setAttribute(this.getReqPrefix() + paramName, (Object)b.toString());
                    continue;
                }
                if (StringUtils.isNotBlank((String)paramValues[0])) {
                    request.setAttribute(this.getReqPrefix() + paramName, (Object)paramValues[0].trim());
                    continue;
                }
                request.setAttribute(this.getReqPrefix() + paramName, (Object)"");
            }
        }
    }

    public abstract void doSecureRequest(HttpServletRequest var1);

    public abstract String getReqPrefix();
}

