/*
 * Decompiled with CFR 0.152.
 */
package org.jiucai.appframework.base.mail;

import java.util.List;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.mail.EmailAttachment;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.HtmlEmail;
import org.jiucai.appframework.base.mail.ICallBack;
import org.jiucai.appframework.base.util.ConfigUtil;

public class MailSender {
    protected Log log = LogFactory.getLog(this.getClass());
    private ICallBack callBack;
    private String charset = "UTF-8";
    private List<EmailAttachment> attachList;
    private HtmlEmail mail = new HtmlEmail();
    private String subject;
    private String msg;
    private String toMail;
    private String toUserName;
    private String fromMail;
    private String fromUserName;
    private String smtpHost;
    private int smtpPort;
    private String authUserName;
    private String authPassword;
    private static Configuration cfg = ConfigUtil.addConfig("mail");

    public MailSender() {
        this.mail.setDebug(false);
    }

    public String getConfigString(String key) {
        return cfg.getString(key);
    }

    public int getConfigInteger(String key) {
        return cfg.getInt(key);
    }

    public String send() throws EmailException {
        String result2;
        try {
            if (null == this.getToMail()) {
                throw new EmailException("Receiver mail address required.");
            }
            if (null == this.getFromMail()) {
                throw new EmailException("Sender mail address required.");
            }
            this.mail.setHostName(this.getSmtpHost());
            if (this.getSmtpPort() > 0) {
                this.mail.setSmtpPort(this.getSmtpPort());
            }
            this.mail.setAuthentication(this.getAuthUserName(), this.getAuthPassword());
            this.mail.setSubject(this.getSubject());
            this.mail.setHtmlMsg(this.getMsg());
            this.mail.setTextMsg("Your mail client does not support HTML format mail. Try Microsoft Outlook or other mail client. ");
            this.mail.setFrom(this.getFromMail(), this.getFromUserName(), this.getCharset());
            this.mail.addTo(this.getToMail(), this.getToUserName(), this.getCharset());
            this.mail.setCharset(this.getCharset());
            if (null != this.getAttachList() && this.getAttachList().size() > 0) {
                for (int i = 0; i < this.getAttachList().size(); ++i) {
                    EmailAttachment attachment = this.getAttachList().get(i);
                    if (null == attachment.getPath() && null == attachment.getURL()) continue;
                    this.mail.attach(attachment);
                }
            }
            result2 = this.mail.send();
        }
        catch (EmailException e) {
            String result2 = ExceptionUtils.getRootCauseMessage((Throwable)e);
            System.err.println(result2);
            throw e;
        }
        if (null != this.callBack) {
            this.callBack.execute(result2);
        }
        return result2;
    }

    public void setCallBack(ICallBack callBack) {
        this.callBack = callBack;
    }

    public List<EmailAttachment> getAttachList() {
        return this.attachList;
    }

    public void setAttachList(List<EmailAttachment> attachList) {
        this.attachList = attachList;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public HtmlEmail getmail() {
        return this.mail;
    }

    public void setMail(HtmlEmail mail) {
        this.mail = mail;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getToMail() {
        return this.toMail;
    }

    public void setToMail(String toMail) {
        this.toMail = toMail;
    }

    public String getToUserName() {
        return this.toUserName;
    }

    public void setToUserName(String toUserName) {
        this.toUserName = toUserName;
    }

    public String getFromMail() {
        if (null == this.fromMail) {
            this.fromMail = this.getConfigString("mail.from_mail");
        }
        return this.fromMail;
    }

    public void setFromMail(String fromMail) {
        this.fromMail = fromMail;
    }

    public String getFromUserName() {
        if (null == this.fromUserName) {
            this.fromUserName = this.getConfigString("mail.from_name");
        }
        return this.fromUserName;
    }

    public void setFromUserName(String fromUserName) {
        this.fromUserName = fromUserName;
    }

    public ICallBack getCallBack() {
        return this.callBack;
    }

    public HtmlEmail getMail() {
        return this.mail;
    }

    public String getAuthPassword() {
        if (null == this.authPassword) {
            this.authPassword = this.getConfigString("mail.password");
        }
        return this.authPassword;
    }

    public void setAuthPassword(String authPassword) {
        this.authPassword = authPassword;
    }

    public String getAuthUserName() {
        if (null == this.authUserName) {
            this.authUserName = this.getConfigString("mail.user_name");
        }
        return this.authUserName;
    }

    public void setAuthUserName(String authUserName) {
        this.authUserName = authUserName;
    }

    public String getSmtpHost() {
        if (null == this.smtpHost) {
            this.smtpHost = this.getConfigString("mail.smtp.host");
        }
        return this.smtpHost;
    }

    public void setSmtpHost(String smtpHost) {
        this.smtpHost = smtpHost;
    }

    public int getSmtpPort() {
        if (this.smtpPort < 1) {
            this.smtpPort = this.getConfigInteger("mail.smtp.port");
        }
        return this.smtpPort;
    }

    public void setSmtpPort(int smtpPort) {
        this.smtpPort = smtpPort;
    }
}

