/*
 * Decompiled with CFR 0.152.
 */
package org.jiucai.appframework.base.util;

import java.util.Enumeration;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.jiucai.appframework.common.util.AliasUtil;
import org.jiucai.appframework.common.util.LogUtil;
import org.jiucai.appframework.common.util.Logs;

public class IpUtil {
    private static Logs log = LogUtil.getLog(AliasUtil.class);
    private static Pattern pattern = Pattern.compile("([1-9]|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])(\\.(\\d|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])){3}");

    private static String isDottedIp(String ipString) {
        Matcher matcher;
        if (ipString != null && (matcher = pattern.matcher(ipString)).matches()) {
            return matcher.group();
        }
        return null;
    }

    public static String getIp(HttpServletRequest request) {
        int i;
        String[] s;
        String ip = request.getHeader("X-Forwarded-For");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = IpUtil.isDottedIp(request.getHeader("Proxy-Client-IP"));
            if (ip != null) {
                return ip;
            }
        } else if (ip.indexOf(",") != -1) {
            s = ip.split(",");
            for (i = 0; i < s.length; ++i) {
                if (s[i] == null || "".equals(s[i]) || "unknown".equals(s[i]) || (ip = IpUtil.isDottedIp(s[i].trim())) == null) continue;
                return ip;
            }
        } else if (ip.indexOf(";") != -1) {
            s = ip.split(";");
            for (i = 0; i < s.length; ++i) {
                if (s[i] == null || "".equals(s[i]) || "unknown".equals(s[i]) || (ip = IpUtil.isDottedIp(s[i].trim())) == null) continue;
                return ip;
            }
        } else if ("unknown".equals(ip) && (ip = IpUtil.isDottedIp(ip.trim())) != null) {
            return ip;
        }
        if ((ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) && (ip = IpUtil.isDottedIp(request.getHeader("WL-Proxy-Client-IP"))) != null) {
            return ip;
        }
        if (ip != null && ip.indexOf(32) != -1 && (ip = IpUtil.isDottedIp(ip.substring(0, ip.indexOf(32)))) != null) {
            return ip;
        }
        if (ip == null) {
            if (request.getHeader("x-forwarded-for") != null || request.getHeader("Proxy-Client-IP") != null || request.getHeader("WL-Proxy-Client-IP") != null) {
                Enumeration headers = request.getHeaderNames();
                while (headers.hasMoreElements()) {
                    String headerName = headers.nextElement().toString();
                    log.debug(headerName + " --> " + request.getHeader(headerName));
                }
                log.debug("--------request.getRemoteAddr:" + request.getRemoteAddr() + "--------");
            }
            ip = request.getRemoteAddr();
        }
        return ip;
    }
}

