/*
 * Decompiled with CFR 0.152.
 */
package org.jiucai.appframework.base.util;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.jiucai.appframework.common.util.BaseUtil;

public class LocalIPUtil
extends BaseUtil {
    public static void main(String[] args) {
        String serverIP = LocalIPUtil.getLocalIP();
        System.out.println("LocalIP : " + serverIP);
    }

    protected static boolean isWindowsOS() {
        boolean isWindowsOS = false;
        String osName = System.getProperty("os.name");
        if (osName.toLowerCase().indexOf("windows") > -1) {
            isWindowsOS = true;
        }
        return isWindowsOS;
    }

    protected static InetAddress[] getAllInetAddress() {
        InetAddress[] addrArr = null;
        if (addrArr == null) {
            try {
                InetAddress address = InetAddress.getLocalHost();
                String hostName = null;
                if (null != address) {
                    hostName = address.getHostName();
                }
                addrArr = InetAddress.getAllByName(hostName);
            }
            catch (Exception e) {
                log.error("getHostIP   error", e);
            }
        }
        return addrArr;
    }

    protected static List<String> getIPList(boolean isIpV4) {
        ArrayList<String> ipList = new ArrayList<String>();
        InetAddress[] adds = LocalIPUtil.getAllInetAddress();
        if (null != adds) {
            for (int i = 0; i < adds.length; ++i) {
                boolean ipTypeWanted;
                String ip = adds[i].getHostAddress();
                boolean bl = isIpV4 ? ip.indexOf(":") == -1 : (ipTypeWanted = ip.indexOf(":") > -1);
                if (null == ip || !ipTypeWanted) continue;
                ipList.add(ip);
            }
        }
        return ipList;
    }

    public static List<String> getIPv4() {
        if (LocalIPUtil.isWindowsOS()) {
            return LocalIPUtil.getIPList(true);
        }
        log.error("only supported by Windows OS");
        return null;
    }

    public static List<String> getIPv6() {
        if (LocalIPUtil.isWindowsOS()) {
            return LocalIPUtil.getIPList(false);
        }
        log.error("only supported by Windows OS");
        return null;
    }

    private static String getNetworkInterface(NetworkInterface ni) {
        String ipValue = null;
        InetAddress ip = null;
        if (null == ni) {
            return ipValue;
        }
        try {
            if (ni.isLoopback() || ni.isVirtual() || !ni.isUp()) {
                return ipValue;
            }
            Enumeration<InetAddress> addrEnum = ni.getInetAddresses();
            while (addrEnum.hasMoreElements()) {
                ip = addrEnum.nextElement();
                log.debug("HostName: " + ip.getHostName() + " HostAddress: " + ip.getHostAddress());
                if (!ip.isSiteLocalAddress() || ip.isLoopbackAddress() || ip.getHostAddress().indexOf(":") != -1) continue;
                break;
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6 HostName[" + ip.getHostName() + "] IP\u5931\u8d25: ", e);
        }
        if (null != ip) {
            ipValue = ip.getHostAddress();
        }
        return ipValue;
    }

    public static String getIpByNetworkInterfaceName(String networkInterfaceName) {
        String ipValue = null;
        try {
            NetworkInterface ni = NetworkInterface.getByName(networkInterfaceName);
            ipValue = LocalIPUtil.getNetworkInterface(ni);
        }
        catch (SocketException e) {
            log.error("\u83b7\u53d6 NetworkInterface[" + networkInterfaceName + "] IP\u5931\u8d25: ", e);
        }
        return ipValue;
    }

    protected static String getWindowsIp() {
        String ipValue = "";
        try {
            InetAddress addr = InetAddress.getLocalHost();
            if (null != addr) {
                ipValue = addr.getHostAddress();
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6Windows\u672c\u673aIP\u5931\u8d25: ", e);
        }
        return ipValue;
    }

    protected static String getLinuxIp() {
        String ipValue = "";
        try {
            boolean bFindIP = false;
            Enumeration<NetworkInterface> netInterfaces = NetworkInterface.getNetworkInterfaces();
            while (netInterfaces.hasMoreElements() && !bFindIP) {
                NetworkInterface ni = netInterfaces.nextElement();
                log.debug("NetworkInterface Name: " + ni.getName());
                if (null == ni || null == (ipValue = LocalIPUtil.getNetworkInterface(ni))) continue;
                bFindIP = true;
                log.debug(ni.getName() + ": " + ipValue);
                break;
            }
            if (null == ipValue) {
                ipValue = LocalIPUtil.getIpByNetworkInterfaceName("eth0");
                log.debug("eth0: " + ipValue);
            }
            if (null == ipValue) {
                ipValue = LocalIPUtil.getIpByNetworkInterfaceName("eth1");
                log.debug("eth1: " + ipValue);
            }
            if (null == ipValue) {
                ipValue = LocalIPUtil.getIpByNetworkInterfaceName("em1");
                log.debug("eth1: " + ipValue);
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6Linux\u672c\u673aIP\u5931\u8d25: ", e);
        }
        return ipValue;
    }

    public static String getLocalIP() {
        return LocalIPUtil.isWindowsOS() ? LocalIPUtil.getWindowsIp() : LocalIPUtil.getLinuxIp();
    }
}

