/*
 * Decompiled with CFR 0.152.
 */
package org.jiucai.appframework.base.web;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.jiucai.appframework.base.helper.AppRequestHelper;
import org.jiucai.appframework.base.helper.SpringHelper;
import org.jiucai.appframework.base.mapper.ParameterMapper;
import org.jiucai.appframework.base.service.BinaryService;
import org.jiucai.appframework.base.service.DataService;
import org.jiucai.appframework.base.service.DownloadService;
import org.jiucai.appframework.base.service.PageService;
import org.jiucai.appframework.base.service.UploadService;
import org.jiucai.appframework.base.web.BaseController;
import org.jiucai.appframework.common.util.EscapeUtil;
import org.springframework.web.multipart.MultipartHttpServletRequest;

public abstract class AbstractBaseController
extends BaseController {
    protected static String IMG_404 = "static/404";
    protected static String REQ_SID = "sid";
    protected static String REQ_MID = "mid";

    public abstract String getReqPrefix();

    public String get404ImageClasspath() {
        return IMG_404;
    }

    public String getRequestServiceId() {
        return REQ_SID;
    }

    public String getMapperId() {
        return REQ_MID;
    }

    public String getDefaultMapperId() {
        return "default";
    }

    public Map<String, String> parseRequest(HttpServletRequest request) {
        return AppRequestHelper.parseRequest(request, this.getReqPrefix());
    }

    public void upload(MultipartHttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String resultData = null;
        String contentType = "application/json; charset=UTF-8";
        String dataType = "json";
        Map<String, String> reqParam = this.parseRequest((HttpServletRequest)request);
        String serviceId = reqParam.get(this.getRequestServiceId());
        String mapperId = reqParam.get(this.getMapperId());
        Boolean errFlag = false;
        if (StringUtils.isBlank((String)mapperId)) {
            mapperId = this.getDefaultMapperId();
            this.log.debug("param mapperId not found, use default mapperId: " + mapperId);
        }
        if (StringUtils.isBlank((String)serviceId)) {
            errFlag = true;
            resultData = this.formatMsg(dataType, "service id is required.");
        }
        if (!errFlag.booleanValue()) {
            UploadService service = null;
            ParameterMapper mapper = null;
            try {
                service = SpringHelper.getBean(serviceId + "UploadService", UploadService.class);
                if (null != service) {
                    mapper = SpringHelper.getBean(mapperId + "ParameterMapper", ParameterMapper.class);
                    if (null != mapper) {
                        resultData = service.handleRequest(mapper, request);
                        contentType = service.getContentType();
                    } else {
                        errFlag = true;
                        resultData = this.formatMsg(dataType, "mapper " + mapperId + " not exists.");
                    }
                } else {
                    errFlag = true;
                    resultData = this.formatMsg(dataType, "service " + serviceId + " not exists.");
                }
            }
            catch (Exception e) {
                this.log.error("upload service failed: " + ExceptionUtils.getFullStackTrace((Throwable)e));
                String errMsg = ExceptionUtils.getRootCauseMessage((Throwable)e);
                errFlag = true;
                resultData = this.formatMsg(dataType, "service " + serviceId + " failed: " + errMsg);
            }
        }
        if (errFlag.booleanValue()) {
            this.log.error("upload service failed: " + resultData);
        }
        this.output(response, resultData, contentType);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void download(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Boolean errFlag;
        String errorMsg;
        block10: {
            errorMsg = "";
            Map<String, String> reqParam = this.parseRequest(request);
            String serviceId = reqParam.get(this.getRequestServiceId());
            String mapperId = reqParam.get(this.getMapperId());
            errFlag = false;
            String fileName = null;
            Boolean isFileExists = false;
            if (StringUtils.isBlank((String)mapperId)) {
                mapperId = this.getDefaultMapperId();
                this.log.debug("param mapperId not found, use default mapperId: " + mapperId);
            }
            if (StringUtils.isBlank((String)serviceId)) {
                errFlag = true;
                errorMsg = "service id is required.";
            }
            if (!errFlag.booleanValue()) {
                DownloadService service = null;
                ParameterMapper mapper = null;
                try {
                    service = SpringHelper.getBean(serviceId + "DownloadService", DownloadService.class);
                    if (null != service) {
                        mapper = SpringHelper.getBean(mapperId + "ParameterMapper", ParameterMapper.class);
                        if (null != mapper) {
                            fileName = service.getFileName(mapper);
                            isFileExists = service.fileExists(mapper);
                            this.log.info("download file name:" + fileName);
                            if (isFileExists.booleanValue() && StringUtils.isNotBlank((String)fileName)) {
                                fileName = fileName.trim().replace(" ", "");
                                fileName = request.getHeader("User-Agent").toUpperCase().indexOf("MSIE") > 0 ? URLEncoder.encode(fileName, "UTF-8") : new String(fileName.getBytes("UTF-8"), "ISO8859-1");
                                response.setContentType(service.getContentType());
                                response.addHeader("Cache-Control", "must-revalidate");
                                response.addHeader("Cache-Control", "no-cache");
                                response.addHeader("Cache-Control", "no-store");
                                response.setDateHeader("Expires", 0L);
                                response.setHeader("Pragma", "no-cache");
                                response.setHeader("Connection", "close");
                                response.setHeader("Content-Disposition", "attachment;filename=" + fileName);
                                service.handleRequest(mapper, (OutputStream)response.getOutputStream());
                                break block10;
                            } else {
                                errFlag = true;
                                errorMsg = "file not exists or download file name is null.";
                                response.sendError(404, errorMsg);
                                return;
                            }
                        }
                        errFlag = true;
                        errorMsg = "mapper " + mapperId + " not exists.";
                        break block10;
                    }
                    errFlag = true;
                    errorMsg = "service " + serviceId + " not exists.";
                }
                catch (Exception e) {
                    this.log.error("download service failed: " + ExceptionUtils.getFullStackTrace((Throwable)e));
                    String errMsg = ExceptionUtils.getRootCauseMessage((Throwable)e);
                    errFlag = true;
                    errorMsg = "service " + serviceId + " failed: " + errMsg;
                }
            }
        }
        if (errFlag.booleanValue()) {
            this.log.error("download service failed: " + errorMsg);
            request.setAttribute("failed_msg", (Object)"\u8bf7\u6c42\u7684\u6587\u4ef6\u4e0d\u5b58\u5728\u6216\u5df2\u7ecf\u88ab\u5220\u9664\u3002");
            String path = request.getContextPath();
            String basePath = new StringBuffer(request.getScheme()).append("://").append(request.getServerName()).append(":").append(request.getServerPort()).append(path).toString();
            response.sendRedirect(basePath + "/common/error/session_failed.jsp");
            return;
        }
    }

    public void binary(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String errorMsg = "";
        Map<String, String> reqParam = this.parseRequest(request);
        String serviceId = reqParam.get(this.getRequestServiceId());
        String mapperId = reqParam.get(this.getMapperId());
        Boolean errFlag = false;
        Boolean isFileExists = false;
        if (StringUtils.isBlank((String)mapperId)) {
            mapperId = this.getDefaultMapperId();
            this.log.debug("param mapperId not found, use default mapperId: " + mapperId);
        }
        if (StringUtils.isBlank((String)serviceId)) {
            errFlag = true;
            errorMsg = "service id is required.";
        }
        if (!errFlag.booleanValue()) {
            BinaryService service = null;
            ParameterMapper mapper = null;
            try {
                service = SpringHelper.getBean(serviceId + "BinaryService", BinaryService.class);
                if (null != service) {
                    mapper = SpringHelper.getBean(mapperId + "ParameterMapper", ParameterMapper.class);
                    if (null != mapper) {
                        isFileExists = service.fileExists(mapper);
                        if (isFileExists.booleanValue()) {
                            response.addHeader("Cache-Control", "must-revalidate");
                            response.addHeader("Cache-Control", "no-cache");
                            response.addHeader("Cache-Control", "no-store");
                            response.setDateHeader("Expires", 0L);
                            response.setHeader("Pragma", "no-cache");
                            response.setHeader("Connection", "close");
                            service.handleRequest(mapper, (OutputStream)response.getOutputStream());
                        } else {
                            errFlag = true;
                            errorMsg = "file not exists.";
                            response.addHeader("Cache-Control", "must-revalidate");
                            response.addHeader("Cache-Control", "no-cache");
                            response.addHeader("Cache-Control", "no-store");
                            response.setDateHeader("Expires", 0L);
                            response.setHeader("Pragma", "no-cache");
                            response.setHeader("Connection", "close");
                            this.output404File((OutputStream)response.getOutputStream());
                        }
                    } else {
                        errFlag = true;
                        errorMsg = "mapper " + mapperId + " not exists.";
                    }
                } else {
                    errFlag = true;
                    errorMsg = "service " + serviceId + " not exists.";
                }
            }
            catch (Exception e) {
                this.log.error("binary service failed: " + ExceptionUtils.getFullStackTrace((Throwable)e));
                String errMsg = ExceptionUtils.getRootCauseMessage((Throwable)e);
                errFlag = true;
                errorMsg = "service " + serviceId + " failed: " + errMsg;
            }
        }
        if (errFlag.booleanValue()) {
            this.log.error("binary service failed: " + errorMsg);
            request.setAttribute("failed_msg", (Object)"\u8bf7\u6c42\u7684\u6587\u4ef6\u4e0d\u5b58\u5728\u6216\u5df2\u7ecf\u88ab\u5220\u9664\u3002");
            return;
        }
    }

    public String page(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String errorMsg = "";
        String templatePage = "error/404";
        Boolean errFlag = false;
        Map<String, String> reqParam = this.parseRequest(request);
        String serviceId = reqParam.get(this.getRequestServiceId());
        String mapperId = reqParam.get(this.getMapperId());
        if (StringUtils.isBlank((String)mapperId)) {
            mapperId = this.getDefaultMapperId();
            this.log.debug("param mapperId not found, use default mapperId: " + mapperId);
        }
        if (StringUtils.isBlank((String)serviceId)) {
            errFlag = true;
            errorMsg = "service id is required.";
        }
        if (!errFlag.booleanValue()) {
            PageService service = null;
            ParameterMapper mapper = null;
            try {
                service = SpringHelper.getBean(serviceId + "PageService", PageService.class);
                if (null != service) {
                    mapper = SpringHelper.getBean(mapperId + "ParameterMapper", ParameterMapper.class);
                    if (null != mapper) {
                        templatePage = service.handleRequest(mapper, model);
                    } else {
                        errFlag = true;
                        errorMsg = "mapper " + mapperId + " not exists.";
                    }
                } else {
                    errFlag = true;
                    errorMsg = "service " + serviceId + " not exists.";
                }
            }
            catch (Exception e) {
                this.log.error("page service failed: " + ExceptionUtils.getFullStackTrace((Throwable)e));
                String errMsg = ExceptionUtils.getRootCauseMessage((Throwable)e);
                errFlag = true;
                errorMsg = "service " + serviceId + " failed: " + errMsg;
            }
        }
        if (errFlag.booleanValue()) {
            this.log.error("page service failed: " + errorMsg);
            model.put("errorMsg", "\u7cfb\u7edf\u5fd9\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002");
        }
        return templatePage;
    }

    public void data(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String resultData = null;
        String contentType = "application/json; charset=UTF-8";
        String dataType = "json";
        Map<String, String> reqParam = this.parseRequest(request);
        String serviceId = reqParam.get(this.getRequestServiceId());
        String mapperId = reqParam.get(this.getMapperId());
        Boolean errFlag = false;
        if (StringUtils.isBlank((String)mapperId)) {
            mapperId = this.getDefaultMapperId();
            this.log.debug("param mapperId not found, use default mapperId: " + mapperId);
        }
        if (StringUtils.isBlank((String)serviceId)) {
            errFlag = true;
            resultData = this.formatMsg(dataType, "service id is required.");
        }
        if (!errFlag.booleanValue()) {
            DataService service = null;
            ParameterMapper mapper = null;
            try {
                service = SpringHelper.getBean(serviceId + "DataService", DataService.class);
                if (null != service) {
                    mapper = SpringHelper.getBean(mapperId + "ParameterMapper", ParameterMapper.class);
                    if (null != mapper) {
                        resultData = service.handleRequest(mapper);
                        contentType = service.getContentType();
                    } else {
                        errFlag = true;
                        resultData = this.formatMsg(dataType, "mapper " + mapperId + " not exists.");
                    }
                } else {
                    errFlag = true;
                    resultData = this.formatMsg(dataType, "service " + serviceId + " not exists.");
                }
            }
            catch (Exception e) {
                this.log.error("data service failed: " + ExceptionUtils.getFullStackTrace((Throwable)e));
                String errMsg = ExceptionUtils.getRootCauseMessage((Throwable)e);
                errFlag = true;
                resultData = this.formatMsg(dataType, "service " + serviceId + " failed: " + errMsg);
            }
        }
        if (errFlag.booleanValue()) {
            this.log.error("data service failed: " + resultData);
        }
        this.output(response, resultData, contentType);
    }

    protected String formatMsg(String fmt, String data) {
        String result = data;
        if ("json".equalsIgnoreCase(fmt)) {
            result = result.replaceAll("\\\n", "<br/>");
            result = result.replaceAll("\\\r", "");
            result = result.replaceAll("\\\t", "&nbsp;&nbsp;&nbsp;&nbsp;");
            result = new StringBuffer("{\"error\": \"").append(EscapeUtil.escape(data)).append("\"}").toString();
        } else if ("xml".equalsIgnoreCase(fmt)) {
            result = new StringBuffer("<error>").append(EscapeUtil.escape(data)).append("<error>").toString();
        }
        return result;
    }

    protected void output404File(OutputStream out) {
        try {
            File file = AbstractBaseController.getFileFromClasspath(this.get404ImageClasspath());
            FileInputStream in = new FileInputStream(file);
            IOUtils.copy((InputStream)in, (OutputStream)out);
            out.close();
            in.close();
        }
        catch (Throwable e) {
            this.log.error("output404File failed:", e);
        }
    }
}

