/*
 * Decompiled with CFR 0.152.
 */
package org.jiucai.appframework.common.deflater.zip;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import java.util.zip.CheckedOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;
import org.apache.tools.zip.ZipOutputStream;
import org.jiucai.appframework.common.util.LogUtil;
import org.jiucai.appframework.common.util.Logs;

public class Zip {
    private static boolean isCreateSrcDir = true;
    private static String encoding = "UTF-8";
    protected static Logs log = LogUtil.getLog(Zip.class);

    public static void setEncoding(String charset) {
        encoding = charset;
    }

    public static synchronized void zip(String src, String archive) throws FileNotFoundException, IOException {
        Zip.zip(src, archive, "");
    }

    public static void zip(String src, String archive, String comment) throws FileNotFoundException, IOException {
        FileOutputStream f = new FileOutputStream(archive);
        CheckedOutputStream csum = new CheckedOutputStream(f, new CRC32());
        ZipOutputStream zos = new ZipOutputStream((OutputStream)csum);
        zos.setEncoding(encoding);
        BufferedOutputStream out = new BufferedOutputStream((OutputStream)zos);
        zos.setComment(comment);
        zos.setMethod(8);
        zos.setLevel(9);
        File srcFile = new File(src);
        if (!srcFile.exists() || srcFile.isDirectory() && srcFile.list().length == 0) {
            out.close();
            throw new FileNotFoundException("File must exist and  ZIP file must have at least one entry.");
        }
        src = src.replaceAll("\\\\", "/");
        String prefixDir = null;
        prefixDir = srcFile.isFile() ? src.substring(0, src.lastIndexOf("/") + 1) : src.replaceAll("/$", "") + "/";
        if (prefixDir.indexOf("/") != prefixDir.length() - 1 && isCreateSrcDir) {
            prefixDir = prefixDir.replaceAll("[^/]+/$", "");
        }
        Zip.saveZipFile(zos, out, srcFile, prefixDir);
        out.close();
        log.debug("Checksum: " + csum.getChecksum().getValue());
    }

    public static synchronized InputStream readFile(String archive, String filePath) throws IOException {
        InputStream in = null;
        ZipFile zf = new ZipFile(archive, encoding);
        Enumeration e = zf.getEntries();
        while (e.hasMoreElements()) {
            ZipEntry ze = (ZipEntry)e.nextElement();
            String entryName = ze.getName();
            if (!entryName.equals(filePath)) continue;
            in = zf.getInputStream(ze);
            break;
        }
        return in;
    }

    public static synchronized void unzip(String archive, String decompressDir) throws IOException, FileNotFoundException, ZipException {
        ZipFile zf = new ZipFile(archive, encoding);
        Enumeration e = zf.getEntries();
        while (e.hasMoreElements()) {
            ZipEntry ze = (ZipEntry)e.nextElement();
            String entryName = ze.getName();
            String path = decompressDir + "/" + entryName;
            if (ze.isDirectory()) {
                log.debug("\u6b63\u5728\u521b\u5efa\u89e3\u538b\u76ee\u5f55 - " + entryName);
                File decompressDirFile = new File(path);
                if (decompressDirFile.exists()) continue;
                decompressDirFile.mkdirs();
                continue;
            }
            log.debug("\u6b63\u5728\u521b\u5efa\u89e3\u538b\u6587\u4ef6 - " + entryName);
            String fileDir = path.substring(0, path.lastIndexOf("/"));
            File fileDirFile = new File(fileDir);
            if (!fileDirFile.exists()) {
                fileDirFile.mkdirs();
            }
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(decompressDir + "/" + entryName));
            BufferedInputStream bi = new BufferedInputStream(zf.getInputStream(ze));
            byte[] readContent = new byte[1024];
            int readCount = bi.read(readContent);
            while (readCount != -1) {
                bos.write(readContent, 0, readCount);
                readCount = bi.read(readContent);
            }
            bos.close();
            bi.close();
        }
        zf.close();
    }

    public static void doUncompressFile(String inFileName) {
        try {
            int len;
            GZIPInputStream in = null;
            try {
                in = new GZIPInputStream(new FileInputStream(inFileName));
            }
            catch (FileNotFoundException e) {
                System.err.println("File not found. " + inFileName);
                System.exit(1);
            }
            System.out.println("Open the output file.");
            String outFileName = Zip.getFileName(inFileName);
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(outFileName);
            }
            catch (FileNotFoundException e) {
                System.err.println("Could not write to file. " + outFileName);
                System.exit(1);
            }
            System.out.println("Transfering bytes from compressed file to the output file.");
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
            System.out.println("Closing the file and stream");
            in.close();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public static String getFileName(String f) {
        String fname = "";
        int i = f.lastIndexOf(46);
        if (i > 0 && i < f.length() - 1) {
            fname = f.substring(0, i);
        }
        return fname;
    }

    public static synchronized void unzip2(String archive, String decompressDir) throws FileNotFoundException, IOException {
        java.util.zip.ZipEntry ze;
        log.debug("\u5f00\u59cb\u8bfb\u538b\u7f29\u6587\u4ef6");
        FileInputStream fi = new FileInputStream(archive);
        CheckedInputStream csumi = new CheckedInputStream(fi, new CRC32());
        ZipInputStream in2 = new ZipInputStream(csumi);
        BufferedInputStream bi = new BufferedInputStream(in2);
        while ((ze = in2.getNextEntry()) != null) {
            String entryName = ze.getName();
            if (ze.isDirectory()) {
                log.debug("\u6b63\u5728\u521b\u5efa\u89e3\u538b\u76ee\u5f55 - " + entryName);
                File decompressDirFile = new File(decompressDir + "/" + entryName);
                if (decompressDirFile.exists()) continue;
                decompressDirFile.mkdirs();
                continue;
            }
            log.debug("\u6b63\u5728\u521b\u5efa\u89e3\u538b\u6587\u4ef6 - " + entryName);
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(decompressDir + "/" + entryName));
            byte[] buffer = new byte[1024];
            int readCount = bi.read(buffer);
            while (readCount != -1) {
                bos.write(buffer, 0, readCount);
                readCount = bi.read(buffer);
            }
            bos.close();
        }
        bi.close();
        log.debug("Checksum: " + csumi.getChecksum().getValue());
    }

    private static synchronized void saveZipFile(ZipOutputStream zos, BufferedOutputStream bo, File srcFile, String prefixDir) throws IOException, FileNotFoundException {
        String filePath = srcFile.getAbsolutePath().replaceAll("\\\\", "/").replaceAll("//", "/");
        if (srcFile.isDirectory()) {
            filePath = filePath.replaceAll("/$", "") + "/";
        }
        String entryName = filePath.replace(prefixDir, "").replaceAll("/$", "");
        if (srcFile.isDirectory()) {
            if (!"".equals(entryName)) {
                log.debug("\u6b63\u5728\u521b\u5efa\u76ee\u5f55 - " + srcFile.getAbsolutePath() + "  entryName=" + entryName);
                ZipEntry zipEntry = new ZipEntry(entryName + "/");
                zos.putNextEntry(zipEntry);
            }
            File[] srcFiles = srcFile.listFiles();
            for (int i = 0; i < srcFiles.length; ++i) {
                Zip.saveZipFile(zos, bo, srcFiles[i], prefixDir);
            }
        } else {
            log.debug("\u6b63\u5728\u5199\u6587\u4ef6 - " + srcFile.getAbsolutePath() + "  entryName=" + entryName);
            BufferedInputStream bi = new BufferedInputStream(new FileInputStream(srcFile));
            ZipEntry zipEntry = new ZipEntry(entryName);
            zos.putNextEntry(zipEntry);
            byte[] buffer = new byte[1024];
            int readCount = bi.read(buffer);
            while (readCount != -1) {
                bo.write(buffer, 0, readCount);
                readCount = bi.read(buffer);
            }
            bo.flush();
            bi.close();
        }
    }

    public static void main(String[] args) throws Exception {
        String src = "d:/Enter_Page_ID.log";
        String archive = "d:/log3.zip";
        String decompressDir = "d:/log4";
        long start = System.currentTimeMillis();
        System.out.println("start zip file ...");
        Zip.zip(src, archive);
        long end = System.currentTimeMillis();
        System.out.println("zip time:" + (end - start) + " ms");
        start = System.currentTimeMillis();
        System.out.println("start unzip file ...");
        Zip.unzip(archive, decompressDir);
        end = System.currentTimeMillis();
        System.out.println("unzip time:" + (end - start) + " ms");
    }
}

