/*
 * Decompiled with CFR 0.152.
 */
package org.jiucai.appframework.common.mail;

import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.commons.configuration.Configuration;
import org.jiucai.appframework.base.util.ConfigUtil;
import org.jiucai.appframework.common.util.LogUtil;
import org.jiucai.appframework.common.util.Logs;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.mail.javamail.MimeMessageHelper;

public class MailSender {
    protected static Logs log = LogUtil.getLog(MailSender.class);
    private final JavaMailSenderImpl javaMailSender = new JavaMailSenderImpl();
    private final MimeMessageHelper mimeMessageHelper;
    private static String host;
    private static String protocol;
    private static Integer port;
    private static String userName;
    private static String password;
    private static Boolean isNeedAuth;

    public MailSender() throws Exception {
        this(true);
    }

    private MailSender(boolean isMultipart) throws Exception {
        this.javaMailSender.setHost(host);
        this.javaMailSender.setProtocol(protocol);
        this.javaMailSender.setPort(port.intValue());
        if (isNeedAuth.booleanValue()) {
            this.javaMailSender.setUsername(userName);
            this.javaMailSender.setPassword(password);
            Properties p = new Properties();
            p.put("mail.smtp.auth", "true");
            this.javaMailSender.setJavaMailProperties(p);
        }
        this.mimeMessageHelper = new MimeMessageHelper(this.javaMailSender.createMimeMessage(), isMultipart, "GBK");
    }

    public void sendMailAsText(String fromTitle, String mailFrom, String[] toTitles, String[] mailTos, String[] mailCCs, String subject, String strText) throws Exception {
        this.sendMail(fromTitle, mailFrom, toTitles, mailTos, mailCCs, subject, strText, false, null, true);
    }

    public void sendMailAsHtml(String fromTitle, String mailFrom, String[] toTitles, String[] mailTos, String[] mailCCs, String subject, String strText) throws Exception {
        this.sendMail(fromTitle, mailFrom, toTitles, mailTos, mailCCs, subject, strText, true, null, true);
    }

    public void sendMailAsHtml(String fromTitle, String mailFrom, String[] toTitles, String[] mailTos, String[] mailCCs, String subject, String strText, boolean isCC) throws Exception {
        this.sendMail(fromTitle, mailFrom, toTitles, mailTos, mailCCs, subject, strText, true, null, isCC);
    }

    public void sendMailAsTextHasAtts(String fromTitle, String mailFrom, String[] toTitles, String[] mailTos, String[] mailCCs, String subject, String strText, Hashtable<String, File> fileTable) throws Exception {
        this.sendMail(fromTitle, mailFrom, toTitles, mailTos, mailCCs, subject, strText, false, fileTable, true);
    }

    public void sendMailAsHtmlHasAtts(String fromTitle, String mailFrom, String[] toTitles, String[] mailTos, String[] mailCCs, String subject, String strText, Hashtable<String, File> fileTable) throws Exception {
        this.sendMail(fromTitle, mailFrom, toTitles, mailTos, mailCCs, subject, strText, true, fileTable, true);
    }

    private void sendMail(String fromTitle, String mailFrom, String[] toTitles, String[] mailTos, String[] mails, String subject, String strText, boolean html, Hashtable<String, File> fileTable, boolean isCC) throws Exception {
        if (null != mailTos) {
            if (null == toTitles) {
                this.mimeMessageHelper.setTo(mailTos);
            } else {
                for (int i = 0; i < mailTos.length; ++i) {
                    if (i > toTitles.length || toTitles.length == 0) {
                        this.mimeMessageHelper.addTo(mailTos[i]);
                        continue;
                    }
                    this.mimeMessageHelper.addTo(mailTos[i], toTitles[i]);
                }
            }
        }
        if (null != mailFrom) {
            if (null != fromTitle) {
                this.mimeMessageHelper.setFrom(mailFrom, fromTitle);
            } else {
                this.mimeMessageHelper.setFrom(mailFrom);
            }
        }
        if (null != mails) {
            if (isCC) {
                this.mimeMessageHelper.setCc(mails);
            } else {
                this.mimeMessageHelper.setBcc(mails);
            }
        }
        if (null != subject) {
            this.mimeMessageHelper.setSubject(subject);
        }
        if (null != strText) {
            if (html) {
                this.mimeMessageHelper.setText(strText, true);
            } else {
                this.mimeMessageHelper.setText(strText, false);
            }
        }
        if (null != fileTable) {
            Enumeration<String> e = fileTable.keys();
            while (e.hasMoreElements()) {
                String key = e.nextElement();
                File value = fileTable.get(key);
                this.mimeMessageHelper.addAttachment(key, value);
            }
        }
        int retryTime = 3000;
        for (int i = 0; i < 3; ++i) {
            try {
                log.info("\u8fdb\u884c\u7b2c " + (i + 1) + " \u6b21\u90ae\u4ef6\u53d1\u9001\u5c1d\u8bd5...");
                this.javaMailSender.send(this.mimeMessageHelper.getMimeMessage());
                log.info("\u90ae\u4ef6\u53d1\u9001\u6210\u529f");
                break;
            }
            catch (Throwable e) {
                log.error("\u90ae\u4ef6\u53d1\u9001\u5931\u8d25 " + retryTime + " \u79d2\u540e\u91cd\u8bd5...", e);
                Thread.sleep(retryTime);
                continue;
            }
        }
    }

    static {
        Configuration config = ConfigUtil.addConfig("mail");
        host = config.getString("mail.smtp.host");
        protocol = config.getString("mail.smtp.protocol");
        port = config.getInt("mail.smtp.port", 25);
        userName = config.getString("mail.user_name");
        password = config.getString("mail.password");
        isNeedAuth = config.getBoolean("mail.smtp.is_need_auth", true);
    }
}

