package org.jmockring.provider;/*
 * Copyright (c) 2013, Pavel Lechev
 *    All rights reserved.
 *
 *    Redistribution and use in source and binary forms, with or without modification,
 *    are permitted provided that the following conditions are met:
 *
 *     1) Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
 *     2) Redistributions in binary form must reproduce the above copyright notice,
 *        this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.
 *     3) Neither the name of the Pavel Lechev nor the names of its contributors may be used to endorse or promote
 *        products derived from this software without specific prior written permission.
 *
 *    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 *    INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *    IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 *    (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 *    HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *    ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

import static org.hamcrest.core.IsNull.notNullValue;

import org.hamcrest.MatcherAssert;
import org.jmockring.annotation.PartOfSuite;
import org.jmockring.annotation.RemoteRequestListener;
import org.jmockring.annotation.RequestClient;
import org.jmockring.junit.ExternalServerJUnitRunner;
import org.jmockring.spi.client.RestAssuredClient;
import org.jmockring.webserver.callback.CallbackRequestEventListener;
import org.junit.Test;
import org.junit.runner.RunWith;

import com.jayway.restassured.specification.RequestSpecification;

/**
 * This demonstrates the usage of multiple external services running
 * and accessing their dynamically allocated ports from inside the configuration....
 *
 * @author Pavel Lechev
 * @date 19/07/12
 */
@RunWith(ExternalServerJUnitRunner.class)
@PartOfSuite(SuiteIT.class)
public class CheckServiceProviders {


    @RequestClient(contextPath = "/context1")
    private RestAssuredClient restAssuredClient;

    @RemoteRequestListener(contextPath = "/context1")
    CallbackRequestEventListener listener;

    @Test
    public void shouldTestRequestClientInjection() throws Exception {

        MatcherAssert.assertThat(restAssuredClient, notNullValue());
        RequestSpecification requestSpec = restAssuredClient.newRequest();
        MatcherAssert.assertThat(requestSpec, notNullValue());

        requestSpec
                .param("test", "test1")
                .expect()
                .statusCode(404)
                .when()
                .get("/blaha");


    }

    @Test
    public void shouldTestRequestOK() throws Exception {
        RequestSpecification requestSpec1 = restAssuredClient.newRequest();
        requestSpec1
                .param("test", "test2.1")
                .expect()
                .statusCode(404)
                .when()
                .get("/mocked-repos/1");

        RequestSpecification requestSpec2 = restAssuredClient.newRequest();
        requestSpec2
                .param("test", "test2.2")
                .expect()
                .statusCode(404)
                .when()
                .get("/mocked-repos/2");

    }

}
