/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.network.service;

import com.jme3.network.HostedConnection;
import com.jme3.network.Server;
import com.jme3.network.service.AbstractHostedService;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractHostedConnectionService
extends AbstractHostedService {
    static final Logger log = Logger.getLogger(AbstractHostedConnectionService.class.getName());
    private boolean autoHost;

    protected AbstractHostedConnectionService() {
        this(true);
    }

    protected AbstractHostedConnectionService(boolean autoHost) {
        this.autoHost = autoHost;
    }

    public void setAutoHost(boolean b) {
        this.autoHost = b;
    }

    public boolean getAutoHost() {
        return this.autoHost;
    }

    public abstract void startHostingOnConnection(HostedConnection var1);

    public abstract void stopHostingOnConnection(HostedConnection var1);

    @Override
    public void connectionAdded(Server server, HostedConnection hc) {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "connectionAdded({0}, {1})", new Object[]{server, hc});
        }
        if (this.autoHost) {
            this.startHostingOnConnection(hc);
        }
    }

    @Override
    public void connectionRemoved(Server server, HostedConnection hc) {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "connectionRemoved({0}, {1})", new Object[]{server, hc});
        }
        this.stopHostingOnConnection(hc);
    }
}

