/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.network.service.rmi;

import com.jme3.network.service.rmi.ClassInfo;
import com.jme3.network.service.rmi.MethodInfo;
import com.jme3.network.service.rmi.RmiRegistry;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class RemoteObjectHandler
implements InvocationHandler {
    private final RmiRegistry rmi;
    private final byte channel;
    private final short objectId;
    private final ClassInfo typeInfo;
    private final Map<Method, MethodInfo> methodIndex = new ConcurrentHashMap<Method, MethodInfo>();

    public RemoteObjectHandler(RmiRegistry rmi, byte channel, short objectId, ClassInfo typeInfo) {
        this.rmi = rmi;
        this.channel = channel;
        this.objectId = objectId;
        this.typeInfo = typeInfo;
    }

    protected MethodInfo getMethodInfo(Method method) {
        MethodInfo mi = this.methodIndex.get(method);
        if (mi == null) {
            mi = this.typeInfo.getMethod(method);
            if (mi == null) {
                mi = MethodInfo.NULL_INFO;
            }
            this.methodIndex.put(method, mi);
        }
        return mi == MethodInfo.NULL_INFO ? null : mi;
    }

    @Override
    public Object invoke(Object o, Method method, Object[] os) throws Throwable {
        MethodInfo mi = this.getMethodInfo(method);
        if (mi == null) {
            return method.invoke((Object)this, os);
        }
        return this.rmi.invokeRemote(this.channel, this.objectId, mi.getId(), mi.getCallType(), os);
    }

    public String toString() {
        return "RemoteObject[#" + this.objectId + ", " + this.typeInfo.getName() + "]";
    }
}

