/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.network.service.rmi;

import com.jme3.network.HostedConnection;
import com.jme3.network.Server;
import com.jme3.network.serializing.Serializer;
import com.jme3.network.service.AbstractHostedService;
import com.jme3.network.service.HostedServiceManager;
import com.jme3.network.service.rmi.ClassInfo;
import com.jme3.network.service.rmi.MethodInfo;
import com.jme3.network.service.rmi.RmiRegistry;
import com.jme3.network.service.rpc.RpcHostedService;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RmiHostedService
extends AbstractHostedService {
    static final Logger log = Logger.getLogger(RpcHostedService.class.getName());
    public static final String ATTRIBUTE_NAME = "rmi";
    private RpcHostedService rpcService;
    private short rmiId;
    private byte defaultChannel;
    private boolean autoHost;
    private final Map<String, GlobalShare> globalShares = new ConcurrentHashMap<String, GlobalShare>();

    public RmiHostedService() {
        this(-1, -2, true);
    }

    public RmiHostedService(byte defaultChannel) {
        this(-1, defaultChannel, true);
    }

    public RmiHostedService(short rmiId, byte defaultChannel, boolean autoHost) {
        this.rmiId = rmiId;
        this.defaultChannel = defaultChannel;
        this.autoHost = autoHost;
        Serializer.registerClasses(ClassInfo.class, MethodInfo.class);
    }

    public <T> void shareGlobal(T object, Class<? super T> type) {
        this.shareGlobal(this.defaultChannel, type.getName(), object, type);
    }

    public <T> void shareGlobal(String name, T object, Class<? super T> type) {
        this.shareGlobal(this.defaultChannel, name, object, type);
    }

    public <T> void shareGlobal(byte channel, String name, T object, Class<? super T> type) {
        GlobalShare share = new GlobalShare(channel, object, type);
        GlobalShare existing = this.globalShares.put(name, share);
        if (existing != null) {
            // empty if block
        }
        for (HostedConnection conn : this.getServer().getConnections()) {
            RmiRegistry child = this.getRmiRegistry(conn);
            if (child == null) continue;
            child.share(channel, name, object, type);
        }
    }

    public void setAutoHost(boolean b) {
        this.autoHost = b;
    }

    public boolean getAutoHost() {
        return this.autoHost;
    }

    public RmiRegistry getRmiRegistry(HostedConnection hc) {
        return (RmiRegistry)hc.getAttribute(ATTRIBUTE_NAME);
    }

    public void startHostingOnConnection(HostedConnection hc) {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "startHostingOnConnection:{0}", hc);
        }
        RmiRegistry rmi = new RmiRegistry(hc, this.rpcService.getRpcConnection(hc), this.rmiId, this.defaultChannel);
        hc.setAttribute(ATTRIBUTE_NAME, rmi);
        for (Map.Entry<String, GlobalShare> e : this.globalShares.entrySet()) {
            GlobalShare share = e.getValue();
            rmi.share(share.channel, e.getKey(), share.object, share.type);
        }
    }

    public void stopHostingOnConnection(HostedConnection hc) {
        RmiRegistry rmi = (RmiRegistry)hc.getAttribute(ATTRIBUTE_NAME);
        if (rmi == null) {
            return;
        }
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "stopHostingOnConnection:{0}", hc);
        }
        hc.setAttribute(ATTRIBUTE_NAME, null);
    }

    @Override
    protected void onInitialize(HostedServiceManager s) {
        this.rpcService = this.getService(RpcHostedService.class);
        if (this.rpcService == null) {
            throw new RuntimeException("RmiHostedService requires RpcHostedService");
        }
    }

    @Override
    public void connectionAdded(Server server, HostedConnection hc) {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "connectionAdded({0}, {1})", new Object[]{server, hc});
        }
        if (this.autoHost) {
            this.startHostingOnConnection(hc);
        }
    }

    @Override
    public void connectionRemoved(Server server, HostedConnection hc) {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "connectionRemoved({0}, {1})", new Object[]{server, hc});
        }
        if (this.autoHost) {
            this.stopHostingOnConnection(hc);
        }
    }

    private class GlobalShare {
        byte channel;
        Object object;
        Class type;

        public GlobalShare(byte channel, Object object, Class type) {
            this.channel = channel;
            this.object = object;
            this.type = type;
        }
    }
}

