/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.diana.couchdb.document;

import java.util.Objects;
import org.jnosql.diana.api.document.DocumentCollectionManagerAsyncFactory;
import org.jnosql.diana.api.document.DocumentCollectionManagerFactory;
import org.jnosql.diana.couchdb.document.CouchDBDocumentCollectionManager;
import org.jnosql.diana.couchdb.document.CouchDBDocumentCollectionManagerAsync;
import org.jnosql.diana.couchdb.document.CouchDBHttpClient;
import org.jnosql.diana.couchdb.document.CouchDBHttpConfiguration;
import org.jnosql.diana.couchdb.document.DefaultCouchDBDocumentCollectionManager;
import org.jnosql.diana.couchdb.document.DefaultCouchDBDocumentCollectionManagerAsync;

public class CouchDBDocumentCollectionManagerFactory
implements DocumentCollectionManagerFactory<CouchDBDocumentCollectionManager>,
DocumentCollectionManagerAsyncFactory<CouchDBDocumentCollectionManagerAsync> {
    private final CouchDBHttpConfiguration configuration;

    CouchDBDocumentCollectionManagerFactory(CouchDBHttpConfiguration configuration) {
        this.configuration = configuration;
    }

    public CouchDBDocumentCollectionManager get(String database) {
        Objects.requireNonNull(database, "database is required");
        CouchDBHttpClient client = this.configuration.getClient(database);
        client.createDatabase();
        return new DefaultCouchDBDocumentCollectionManager(client);
    }

    public CouchDBDocumentCollectionManagerAsync getAsync(String database) {
        Objects.requireNonNull(database, "database is required");
        CouchDBDocumentCollectionManager manager = this.get(database);
        return new DefaultCouchDBDocumentCollectionManagerAsync(manager);
    }

    public void close() {
    }
}

