/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.diana.couchdb.document;

import java.util.Map;
import java.util.Objects;
import org.jnosql.diana.api.Settings;
import org.jnosql.diana.api.SettingsBuilder;
import org.jnosql.diana.api.document.UnaryDocumentConfiguration;
import org.jnosql.diana.couchdb.document.CouchDBDocumentCollectionManagerFactory;
import org.jnosql.diana.couchdb.document.CouchDBHttpConfigurationBuilder;
import org.jnosql.diana.driver.ConfigurationReader;

public class CouchDBDocumentConfiguration
implements UnaryDocumentConfiguration<CouchDBDocumentCollectionManagerFactory> {
    public static final String PORT = "couchdb.port";
    public static final String MAX_CONNECTIONS = "couchdb.max.connections";
    public static final String CONNECTION_TIMEOUT = "couchdb.connection.timeout";
    public static final String SOCKET_TIMEOUT = "couchdb.socket.timeout";
    public static final String MAX_OBJECT_SIZE_BYTES = "couchdb.max.object.size.bytes";
    public static final String MAX_CACHE_ENTRIES = "couchdb.max.cache.entries";
    public static final String HOST = "couchdb.host";
    public static final String USERNAME = "couchdb.username";
    public static final String PASSWORD = "couchdb.password";
    public static final String ENABLE_SSL = "couchdb.enable.ssl";
    public static final String COMPRESSION = "couchdb.compression";
    private static final String FILE_CONFIGURATION = "diana-couchdb.properties";

    public CouchDBDocumentCollectionManagerFactory get() {
        Map configuration = ConfigurationReader.from((String)FILE_CONFIGURATION);
        SettingsBuilder builder = Settings.builder();
        configuration.entrySet().forEach(e -> builder.put((String)e.getKey(), e.getValue()));
        return this.get(builder.build());
    }

    public CouchDBDocumentCollectionManagerFactory get(Settings settings) {
        Objects.requireNonNull(settings, "settings is required");
        CouchDBHttpConfigurationBuilder configuration = new CouchDBHttpConfigurationBuilder();
        settings.computeIfPresent((Object)PORT, (k, v) -> configuration.withPort(Integer.valueOf(v.toString())));
        settings.computeIfPresent((Object)MAX_CONNECTIONS, (k, v) -> configuration.withMaxConnections(Integer.valueOf(v.toString())));
        settings.computeIfPresent((Object)CONNECTION_TIMEOUT, (k, v) -> configuration.withConnectionTimeout(Integer.valueOf(v.toString())));
        settings.computeIfPresent((Object)SOCKET_TIMEOUT, (k, v) -> configuration.withSocketTimeout(Integer.valueOf(v.toString())));
        settings.computeIfPresent((Object)MAX_OBJECT_SIZE_BYTES, (k, v) -> configuration.withMaxObjectSizeBytes(Integer.valueOf(v.toString())));
        settings.computeIfPresent((Object)MAX_CACHE_ENTRIES, (k, v) -> configuration.withMaxCacheEntries(Integer.valueOf(v.toString())));
        settings.computeIfPresent((Object)HOST, (k, v) -> configuration.withHost(v.toString()));
        settings.computeIfPresent((Object)USERNAME, (k, v) -> configuration.withUsername(v.toString()));
        settings.computeIfPresent((Object)PASSWORD, (k, v) -> configuration.withPassword(v.toString()));
        settings.computeIfPresent((Object)ENABLE_SSL, (k, v) -> configuration.withEnableSSL(Boolean.valueOf(v.toString())));
        settings.computeIfPresent((Object)COMPRESSION, (k, v) -> configuration.withCompression(Boolean.valueOf(v.toString())));
        return new CouchDBDocumentCollectionManagerFactory(configuration.build());
    }

    public CouchDBDocumentCollectionManagerFactory getAsync() {
        return this.get();
    }

    public CouchDBDocumentCollectionManagerFactory getAsync(Settings settings) {
        return this.get(settings);
    }
}

