/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.diana.couchdb.document;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jnosql.diana.api.Sort;
import org.jnosql.diana.api.document.DocumentCondition;
import org.jnosql.diana.api.document.DocumentQuery;

public final class CouchDBDocumentQuery
implements DocumentQuery {
    private final DocumentQuery query;
    private String bookmark;

    private CouchDBDocumentQuery(DocumentQuery query) {
        this.query = query;
    }

    public Optional<String> getBookmark() {
        return Optional.ofNullable(this.bookmark);
    }

    void setBookmark(Map<String, Object> json) {
        json.computeIfPresent("bookmark", (k, v) -> {
            this.bookmark = v.toString();
            return this.bookmark;
        });
    }

    public long getLimit() {
        return this.query.getLimit();
    }

    public long getSkip() {
        return this.query.getSkip();
    }

    public String getDocumentCollection() {
        return this.query.getDocumentCollection();
    }

    public Optional<DocumentCondition> getCondition() {
        return this.query.getCondition();
    }

    public List<Sort> getSorts() {
        return this.query.getSorts();
    }

    public List<String> getDocuments() {
        return this.query.getDocuments();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CouchDBDocumentQuery that = (CouchDBDocumentQuery)o;
        return Objects.equals(this.query, that.query) && Objects.equals(this.bookmark, that.bookmark);
    }

    public int hashCode() {
        return Objects.hash(this.query, this.bookmark);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CouchDBDocumentQuery{");
        sb.append("query=").append(this.query);
        sb.append(", bookmark='").append(this.bookmark).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public static CouchDBDocumentQuery of(DocumentQuery query) {
        Objects.requireNonNull(query, "query is required ");
        return new CouchDBDocumentQuery(query);
    }

    public static CouchDBDocumentQuery of(DocumentQuery query, String bookmark) {
        Objects.requireNonNull(query, "query is required ");
        Objects.requireNonNull(bookmark, "bookmark is required ");
        CouchDBDocumentQuery couchDBDocumentQuery = new CouchDBDocumentQuery(query);
        couchDBDocumentQuery.bookmark = bookmark;
        return couchDBDocumentQuery;
    }
}

