/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.diana.couchdb.document;

import java.io.IOException;
import java.util.List;
import org.apache.http.impl.client.CloseableHttpClient;
import org.jnosql.diana.api.JNoSQLException;
import org.jnosql.diana.api.document.DocumentDeleteQuery;
import org.jnosql.diana.api.document.DocumentEntity;
import org.jnosql.diana.api.document.DocumentQuery;
import org.jnosql.diana.couchdb.document.CouchDBHttpConfiguration;
import org.jnosql.diana.couchdb.document.HttpExecute;

final class CouchDBHttpClient {
    private final CloseableHttpClient client;
    private final String database;
    private final HttpExecute httpExecute;

    CouchDBHttpClient(CouchDBHttpConfiguration configuration, CloseableHttpClient client, String database) {
        this.client = client;
        this.database = database;
        this.httpExecute = new HttpExecute(configuration, client);
    }

    void createDatabase() {
        List<String> databases = this.httpExecute.getDatabases();
        if (!databases.contains(this.database)) {
            this.httpExecute.createDatabase(this.database);
        }
    }

    public DocumentEntity insert(DocumentEntity entity) {
        return this.httpExecute.insert(this.database, entity);
    }

    public DocumentEntity update(DocumentEntity entity) {
        return this.httpExecute.update(this.database, entity);
    }

    public List<DocumentEntity> select(DocumentQuery query) {
        return this.httpExecute.select(this.database, query);
    }

    public void delete(DocumentDeleteQuery query) {
        this.httpExecute.delete(this.database, query);
    }

    public long count() {
        return this.httpExecute.count(this.database);
    }

    public void close() {
        try {
            this.client.close();
        }
        catch (IOException e) {
            throw new JNoSQLException("An error when try to close the http client", (Throwable)e);
        }
    }
}

