/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.diana.couchdb.document;

import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.cache.CacheConfig;
import org.apache.http.impl.client.cache.CachingHttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.jnosql.diana.couchdb.document.CouchDBHttpClient;

class CouchDBHttpConfiguration {
    private final String host;
    private final int port;
    private final int maxConnections;
    private final int connectionTimeout;
    private final int socketTimeout;
    private final boolean enableSSL;
    private final String username;
    private final String password;
    private final boolean compression;
    private final int maxObjectSizeBytes;
    private final int maxCacheEntries;
    private final String url;

    CouchDBHttpConfiguration(String host, int port, int maxConnections, int connectionTimeout, int socketTimeout, boolean enableSSL, String username, String password, boolean compression, int maxObjectSizeBytes, int maxCacheEntries) {
        this.host = host;
        this.port = port;
        this.maxConnections = maxConnections;
        this.connectionTimeout = connectionTimeout;
        this.socketTimeout = socketTimeout;
        this.enableSSL = enableSSL;
        this.username = username;
        this.password = password;
        this.compression = compression;
        this.maxObjectSizeBytes = maxObjectSizeBytes;
        this.maxCacheEntries = maxCacheEntries;
        this.url = this.createUrl();
    }

    private String createUrl() {
        StringBuilder url = new StringBuilder();
        if (this.enableSSL) {
            url.append("https://");
        } else {
            url.append("http://");
        }
        url.append(this.host).append(':').append(this.port).append('/');
        return url.toString();
    }

    public CouchDBHttpClient getClient(String database) {
        return new CouchDBHttpClient(this, this.getHttpClient(), database);
    }

    public String getUrl() {
        return this.url;
    }

    private CloseableHttpClient getHttpClient() {
        CacheConfig cacheConfig = CacheConfig.custom().setMaxCacheEntries(this.maxCacheEntries).setMaxObjectSize((long)this.maxObjectSizeBytes).build();
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(this.connectionTimeout).setSocketTimeout(this.socketTimeout).setContentCompressionEnabled(this.compression).build();
        PoolingHttpClientConnectionManager pool = new PoolingHttpClientConnectionManager();
        pool.setMaxTotal(this.maxConnections);
        HttpClientBuilder builder = CachingHttpClients.custom().setCacheConfig(cacheConfig).setConnectionManager((HttpClientConnectionManager)pool).setDefaultRequestConfig(requestConfig);
        if (this.username != null) {
            BasicCredentialsProvider provider = new BasicCredentialsProvider();
            UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(this.username, this.password);
            provider.setCredentials(AuthScope.ANY, (Credentials)credentials);
            builder.setDefaultCredentialsProvider((CredentialsProvider)provider);
        }
        return builder.build();
    }
}

