/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.diana.couchdb.document;

import org.jnosql.diana.couchdb.document.CouchDBHttpConfiguration;

class CouchDBHttpConfigurationBuilder {
    private String host = "localhost";
    private int port = 5984;
    private int maxConnections = 20;
    private int connectionTimeout = 1000;
    private int socketTimeout = 10000;
    private boolean enableSSL = false;
    private String username;
    private String password;
    private boolean compression = false;
    private int maxObjectSizeBytes = 8192;
    private int maxCacheEntries = 1000;

    CouchDBHttpConfigurationBuilder() {
    }

    public CouchDBHttpConfigurationBuilder withPort(int port) {
        this.port = port;
        return this;
    }

    public CouchDBHttpConfigurationBuilder withMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
        return this;
    }

    public CouchDBHttpConfigurationBuilder withConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        return this;
    }

    public CouchDBHttpConfigurationBuilder withSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
        return this;
    }

    public CouchDBHttpConfigurationBuilder withMaxObjectSizeBytes(int maxObjectSizeBytes) {
        this.maxObjectSizeBytes = maxObjectSizeBytes;
        return this;
    }

    public CouchDBHttpConfigurationBuilder withMaxCacheEntries(int maxCacheEntries) {
        this.maxCacheEntries = maxCacheEntries;
        return this;
    }

    public CouchDBHttpConfigurationBuilder withCompression(boolean compression) {
        this.compression = compression;
        return this;
    }

    public CouchDBHttpConfigurationBuilder withHost(String host) {
        this.host = host;
        return this;
    }

    public CouchDBHttpConfigurationBuilder withUsername(String username) {
        this.username = username;
        return this;
    }

    public CouchDBHttpConfigurationBuilder withPassword(String password) {
        this.password = password;
        return this;
    }

    public CouchDBHttpConfigurationBuilder withEnableSSL(boolean enableSSL) {
        this.enableSSL = enableSSL;
        return this;
    }

    public CouchDBHttpConfiguration build() {
        return new CouchDBHttpConfiguration(this.host, this.port, this.maxConnections, this.connectionTimeout, this.socketTimeout, this.enableSSL, this.username, this.password, this.compression, this.maxObjectSizeBytes, this.maxCacheEntries);
    }
}

