/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.diana.couchdb.document;

import java.time.Duration;
import java.util.List;
import java.util.Objects;
import org.jnosql.diana.api.document.DocumentDeleteQuery;
import org.jnosql.diana.api.document.DocumentEntity;
import org.jnosql.diana.api.document.DocumentQuery;
import org.jnosql.diana.couchdb.document.CouchDBDocumentCollectionManager;
import org.jnosql.diana.couchdb.document.CouchDBHttpClient;

class DefaultCouchDBDocumentCollectionManager
implements CouchDBDocumentCollectionManager {
    private final CouchDBHttpClient connector;

    DefaultCouchDBDocumentCollectionManager(CouchDBHttpClient connector) {
        this.connector = connector;
    }

    public DocumentEntity insert(DocumentEntity entity) {
        Objects.requireNonNull(entity, "entity is required");
        return this.connector.insert(entity);
    }

    public DocumentEntity insert(DocumentEntity entity, Duration ttl) {
        throw new UnsupportedOperationException("CouchDB does not support TTL operation");
    }

    public DocumentEntity update(DocumentEntity entity) {
        Objects.requireNonNull(entity, "entity is required");
        return this.connector.update(entity);
    }

    public void delete(DocumentDeleteQuery query) {
        Objects.requireNonNull(query, "query is required");
        this.connector.delete(query);
    }

    public List<DocumentEntity> select(DocumentQuery query) {
        Objects.requireNonNull(query, "query is required");
        return this.connector.select(query);
    }

    @Override
    public long count() {
        return this.connector.count();
    }

    public long count(String documentCollection) {
        throw new UnsupportedOperationException("CouchDB does not have support to count by document Collection, to total of elments at database use CouchDBDocumentCollectionManager#count");
    }

    public void close() {
        this.connector.close();
    }
}

