/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.diana.couchdb.document;

import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.jnosql.diana.api.document.DocumentDeleteQuery;
import org.jnosql.diana.api.document.DocumentEntity;
import org.jnosql.diana.api.document.DocumentQuery;
import org.jnosql.diana.couchdb.document.CouchDBDocumentCollectionManager;
import org.jnosql.diana.couchdb.document.CouchDBDocumentCollectionManagerAsync;

final class DefaultCouchDBDocumentCollectionManagerAsync
implements CouchDBDocumentCollectionManagerAsync {
    private final CouchDBDocumentCollectionManager manager;

    DefaultCouchDBDocumentCollectionManagerAsync(CouchDBDocumentCollectionManager manager) {
        this.manager = manager;
    }

    public void insert(DocumentEntity entity) {
        Objects.requireNonNull(entity, "entity is required");
        CompletableFuture.supplyAsync(() -> this.manager.insert(entity));
    }

    public void insert(DocumentEntity entity, Duration ttl) {
        throw new UnsupportedOperationException("CouchDB does not support TTL operation");
    }

    public void insert(DocumentEntity entity, Consumer<DocumentEntity> callBack) {
        Objects.requireNonNull(entity, "entity is required");
        Objects.requireNonNull(callBack, "callBack is required");
        CompletableFuture<DocumentEntity> async = CompletableFuture.supplyAsync(() -> this.manager.insert(entity));
        async.thenAccept(callBack::accept);
    }

    public void insert(DocumentEntity entity, Duration ttl, Consumer<DocumentEntity> callBack) {
        throw new UnsupportedOperationException("CouchDB does not support TTL operation");
    }

    public void update(DocumentEntity entity) {
        Objects.requireNonNull(entity, "entity is required");
        CompletableFuture<DocumentEntity> async = CompletableFuture.supplyAsync(() -> this.manager.update(entity));
    }

    public void update(DocumentEntity entity, Consumer<DocumentEntity> callBack) {
        Objects.requireNonNull(entity, "entity is required");
        Objects.requireNonNull(callBack, "callBack is required");
        CompletableFuture<DocumentEntity> async = CompletableFuture.supplyAsync(() -> this.manager.update(entity));
        async.thenAccept(callBack::accept);
    }

    public void delete(DocumentDeleteQuery query) {
        Objects.requireNonNull(query, "query is required");
        CompletableFuture.runAsync(() -> this.manager.delete(query));
    }

    public void delete(DocumentDeleteQuery query, Consumer<Void> callBack) {
        Objects.requireNonNull(query, "query is required");
        Objects.requireNonNull(callBack, "callBack is required");
        CompletableFuture<Void> async = CompletableFuture.runAsync(() -> this.manager.delete(query));
        async.thenAccept(callBack::accept);
    }

    public void select(DocumentQuery query, Consumer<List<DocumentEntity>> callBack) {
        Objects.requireNonNull(query, "query is required");
        Objects.requireNonNull(callBack, "callBack is required");
        CompletableFuture<List> async = CompletableFuture.supplyAsync(() -> this.manager.select(query));
        async.thenAccept(callBack::accept);
    }

    public void count(String documentCollection, Consumer<Long> callback) {
        throw new UnsupportedOperationException("CouchDB does not support TTL operation");
    }

    public void close() {
        this.manager.close();
    }

    @Override
    public void count(Consumer<Long> callback) {
        Objects.requireNonNull(callback, "callback is required");
        CompletableFuture<Long> async = CompletableFuture.supplyAsync(() -> this.manager.count());
        async.thenAccept(callback::accept);
    }
}

