/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.diana.couchdb.document;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.json.JsonObject;
import javax.json.bind.Jsonb;
import org.apache.commons.codec.net.URLCodec;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.jnosql.diana.api.document.Document;
import org.jnosql.diana.api.document.DocumentDeleteQuery;
import org.jnosql.diana.api.document.DocumentEntity;
import org.jnosql.diana.api.document.DocumentQuery;
import org.jnosql.diana.api.document.Documents;
import org.jnosql.diana.couchdb.document.CouchDBDocumentQuery;
import org.jnosql.diana.couchdb.document.CouchDBHttpClientException;
import org.jnosql.diana.couchdb.document.CouchDBHttpConfiguration;
import org.jnosql.diana.couchdb.document.DeleteElement;
import org.jnosql.diana.couchdb.document.DeleteQuery;
import org.jnosql.diana.couchdb.document.MangoQueryConverter;
import org.jnosql.diana.driver.JsonbSupplier;

class HttpExecute {
    private static final Jsonb JSONB = (Jsonb)JsonbSupplier.getInstance().get();
    private static final URLCodec CODEC = new URLCodec();
    private static final Type LIST_STRING = new ArrayList<String>(){}.getClass().getGenericSuperclass();
    private static final Type JSON = new HashMap<String, Object>(){}.getClass().getGenericSuperclass();
    private final CouchDBHttpConfiguration configuration;
    private final CloseableHttpClient client;
    private final MangoQueryConverter converter;

    HttpExecute(CouchDBHttpConfiguration configuration, CloseableHttpClient client) {
        this.configuration = configuration;
        this.client = client;
        this.converter = new MangoQueryConverter();
    }

    public List<String> getDatabases() {
        HttpGet httpget = new HttpGet(this.configuration.getUrl().concat("_all_dbs"));
        return (List)this.execute((HttpUriRequest)httpget, LIST_STRING, 200);
    }

    public void createDatabase(String database) {
        HttpPut httpPut = new HttpPut(this.configuration.getUrl().concat(database));
        Map json = (Map)this.execute((HttpUriRequest)httpPut, JSON, 201);
        if (!json.getOrDefault("ok", "false").toString().equals("true")) {
            throw new CouchDBHttpClientException("There is an error to create database: " + database);
        }
    }

    public DocumentEntity insert(String database, DocumentEntity entity) {
        HashMap<String, String> map = new HashMap<String, String>(entity.toMap());
        String id = map.getOrDefault("_id", "").toString();
        map.put("@entity", entity.getName());
        try {
            HttpPost request;
            if (id.isEmpty()) {
                request = new HttpPost(this.configuration.getUrl().concat(database).concat("/"));
            } else {
                id = CODEC.encode(id);
                request = new HttpPut(this.configuration.getUrl().concat(database).concat("/").concat(id));
            }
            this.setHeader((HttpEntityEnclosingRequestBase)request);
            StringEntity jsonEntity = new StringEntity(JSONB.toJson(map), ContentType.APPLICATION_JSON);
            request.setEntity((HttpEntity)jsonEntity);
            Map json = (Map)this.execute((HttpUriRequest)request, JSON, 201);
            entity.add("_id", json.get("id"));
            entity.add("_rev", json.get("rev"));
            return entity;
        }
        catch (CouchDBHttpClientException ex) {
            throw ex;
        }
        catch (Exception exp) {
            throw new CouchDBHttpClientException("There is an error when try to insert an entity at database", exp);
        }
    }

    public DocumentEntity update(String database, DocumentEntity entity) {
        String id = this.getId(entity);
        Map<String, Object> json = this.findById(database, id);
        entity.add("_rev", json.get("_rev"));
        return this.insert(database, entity);
    }

    public List<DocumentEntity> select(String database, DocumentQuery query) {
        List<Map<String, Object>> entities = this.executeQuery(database, query);
        return entities.stream().map(this::toEntity).collect(Collectors.toList());
    }

    public void delete(String database, DocumentDeleteQuery query) {
        CouchDBDocumentQuery documentQuery = CouchDBDocumentQuery.of(new DeleteQuery(query));
        List<Map<String, Object>> entities = this.executeQuery(database, documentQuery);
        while (!entities.isEmpty()) {
            entities.stream().map(DeleteElement::new).forEach(id -> this.delete(database, (DeleteElement)id));
            entities = this.executeQuery(database, documentQuery);
        }
    }

    public long count(String database) {
        HttpGet request = new HttpGet(this.configuration.getUrl().concat(database).concat("/_all_docs?limit=0"));
        Map json = (Map)this.execute((HttpUriRequest)request, JSON, 200);
        String total = json.get("total_rows").toString();
        return Long.valueOf(total);
    }

    private void delete(String database, DeleteElement id) {
        HttpDelete request = new HttpDelete(this.configuration.getUrl().concat(database).concat("/").concat(id.getId()));
        request.addHeader("If-Match", id.getRev());
        this.execute((HttpUriRequest)request, null, 200, true);
    }

    private List<Map<String, Object>> executeQuery(String database, DocumentQuery query) {
        HttpPost request = new HttpPost(this.configuration.getUrl().concat(database).concat("/_find"));
        this.setHeader((HttpEntityEnclosingRequestBase)request);
        JsonObject mangoQuery = this.converter.apply(query);
        request.setEntity((HttpEntity)new StringEntity(mangoQuery.toString(), ContentType.APPLICATION_JSON));
        Map json = (Map)this.execute((HttpUriRequest)request, JSON, 200);
        if (query instanceof CouchDBDocumentQuery) {
            ((CouchDBDocumentQuery)CouchDBDocumentQuery.class.cast(query)).setBookmark(json);
        }
        return json.getOrDefault("docs", Collections.emptyList());
    }

    private DocumentEntity toEntity(Map<String, Object> jsonEntity) {
        DocumentEntity entity = DocumentEntity.of((String)jsonEntity.get("@entity").toString());
        entity.addAll((Iterable)Documents.of(jsonEntity));
        entity.remove("@entity");
        return entity;
    }

    private Map<String, Object> findById(String database, String id) {
        HttpGet request = new HttpGet(this.configuration.getUrl().concat(database).concat("/").concat(id));
        return (Map)this.execute((HttpUriRequest)request, JSON, 200);
    }

    private String getId(DocumentEntity entity) {
        return (String)((Document)entity.find("_id").orElseThrow(() -> new CouchDBHttpClientException(String.format("To update the entity %s the id field is required", entity.toString())))).get(String.class);
    }

    private <T> T execute(HttpUriRequest request, Type type, int expectedStatus) {
        return this.execute(request, type, expectedStatus, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T execute(HttpUriRequest request, Type type, int expectedStatus, boolean ignoreStatus) {
        try (CloseableHttpResponse result = this.client.execute(request);){
            if (!ignoreStatus && result.getStatusLine().getStatusCode() != expectedStatus) {
                ByteArrayOutputStream stream = new ByteArrayOutputStream();
                result.getEntity().writeTo((OutputStream)stream);
                String response = new String(stream.toByteArray(), StandardCharsets.UTF_8);
                throw new CouchDBHttpClientException("There is an error when load the database status: " + result.getStatusLine().getStatusCode() + " error: " + response);
            }
            if (Objects.isNull(type)) {
                T stream = null;
                return stream;
            }
            HttpEntity entity = result.getEntity();
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            entity.writeTo((OutputStream)stream);
            Object object = JSONB.fromJson(new String(stream.toByteArray(), StandardCharsets.UTF_8), type);
            return (T)object;
        }
        catch (CouchDBHttpClientException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new CouchDBHttpClientException("An error to access the database", ex);
        }
    }

    private void setHeader(HttpEntityEnclosingRequestBase request) {
        request.setHeader("Accept", ContentType.APPLICATION_JSON.getMimeType());
        request.setHeader("Content-type", ContentType.APPLICATION_JSON.getMimeType());
    }
}

