/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.diana.couchdb.document;

import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Function;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import org.jnosql.diana.api.Sort;
import org.jnosql.diana.api.Value;
import org.jnosql.diana.api.document.Document;
import org.jnosql.diana.api.document.DocumentCondition;
import org.jnosql.diana.api.document.DocumentQuery;
import org.jnosql.diana.couchdb.document.CouchDBDocumentQuery;
import org.jnosql.diana.driver.ValueUtil;

final class MangoQueryConverter
implements Function<DocumentQuery, JsonObject> {
    MangoQueryConverter() {
    }

    @Override
    public JsonObject apply(DocumentQuery documentQuery) {
        JsonObjectBuilder select = Json.createObjectBuilder();
        if (!documentQuery.getDocuments().isEmpty()) {
            select.add("fields", (JsonValue)Json.createArrayBuilder((Collection)documentQuery.getDocuments()).build());
        }
        if (documentQuery.getLimit() > 0L) {
            select.add("limit", documentQuery.getLimit());
        }
        if (documentQuery.getSkip() > 0L) {
            select.add("skip", documentQuery.getSkip());
        }
        if (!documentQuery.getSorts().isEmpty()) {
            JsonArrayBuilder sorts = Json.createArrayBuilder();
            documentQuery.getSorts().stream().map(this::createSortObject).forEach(arg_0 -> ((JsonArrayBuilder)sorts).add(arg_0));
            select.add("sort", (JsonValue)sorts.build());
        }
        if (documentQuery instanceof CouchDBDocumentQuery) {
            Optional<String> bookmark = ((CouchDBDocumentQuery)CouchDBDocumentQuery.class.cast(documentQuery)).getBookmark();
            bookmark.ifPresent(b -> this.bookmark((String)b, select));
        }
        JsonObject selector = this.getSelector(documentQuery);
        return select.add("selector", (JsonValue)selector).build();
    }

    private void bookmark(String bookmark, JsonObjectBuilder select) {
        select.add("bookmark", bookmark);
    }

    private JsonObject createSortObject(Sort sort) {
        return Json.createObjectBuilder().add(sort.getName(), sort.getType().name().toLowerCase(Locale.US)).build();
    }

    private JsonObject getSelector(DocumentQuery documentQuery) {
        JsonObjectBuilder selector = Json.createObjectBuilder();
        selector.add("@entity", documentQuery.getDocumentCollection());
        documentQuery.getCondition().ifPresent(d -> this.appendCondition((DocumentCondition)d, selector));
        return selector.build();
    }

    private void appendCondition(DocumentCondition condition, JsonObjectBuilder selector) {
        Document document = condition.getDocument();
        String name = document.getName();
        Object value = ValueUtil.convert((Value)document.getValue());
        switch (condition.getCondition()) {
            case EQUALS: {
                this.appendCondition(selector, name, value);
                return;
            }
            case GREATER_THAN: {
                this.appendCondition("$gt", name, value, selector);
                return;
            }
            case GREATER_EQUALS_THAN: {
                this.appendCondition("$gte", name, value, selector);
                return;
            }
            case LESSER_THAN: {
                this.appendCondition("$lt", name, value, selector);
                return;
            }
            case LESSER_EQUALS_THAN: {
                this.appendCondition("$lte", name, value, selector);
                return;
            }
            case IN: {
                this.appendCondition("$in", name, this.getArray(document.getValue()), selector);
                return;
            }
            case NOT: {
                this.appendNot(selector, value);
                return;
            }
            case AND: {
                this.appendCombination(selector, value, "$and");
                return;
            }
            case OR: {
                this.appendCombination(selector, value, "$or");
                return;
            }
        }
        throw new UnsupportedOperationException("This operation is not supported at couchdb: " + condition.getCondition());
    }

    private void appendCombination(JsonObjectBuilder selector, Object value, String combination) {
        List conditions = (List)List.class.cast(value);
        JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
        for (DocumentCondition documentCondition : conditions) {
            JsonObjectBuilder builder = Json.createObjectBuilder();
            this.appendCondition(documentCondition, builder);
            arrayBuilder.add((JsonValue)builder.build());
        }
        selector.add(combination, (JsonValue)arrayBuilder.build());
    }

    private void appendNot(JsonObjectBuilder selector, Object value) {
        JsonObjectBuilder not = Json.createObjectBuilder();
        this.appendCondition((DocumentCondition)DocumentCondition.class.cast(value), not);
        selector.add("$not", (JsonValue)not.build());
    }

    private void appendCondition(String operator, String name, Object value, JsonObjectBuilder selector) {
        JsonObjectBuilder condition = Json.createObjectBuilder();
        this.appendCondition(condition, operator, value);
        selector.add(name, (JsonValue)condition.build());
    }

    private void appendCondition(JsonObjectBuilder condition, String name, Object value) {
        if (value instanceof String) {
            condition.add(name, value.toString());
            return;
        }
        if (value instanceof Boolean) {
            condition.add(name, ((Boolean)Boolean.class.cast(value)).booleanValue());
            return;
        }
        if (value instanceof Number) {
            condition.add(name, ((Number)Number.class.cast(value)).doubleValue());
            return;
        }
        if (value instanceof JsonArray) {
            condition.add(name, (JsonValue)JsonArray.class.cast(value));
            return;
        }
        condition.add(name, (String)Value.of((Object)value).get(String.class));
    }

    private JsonArray getArray(Value value) {
        List items = ValueUtil.convertToList((Value)value);
        return Json.createArrayBuilder((Collection)items).build();
    }
}

