/*
 * Decompiled with CFR 0.152.
 */
package jodd.http.net;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.InetAddress;
import java.net.Socket;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.SocketFactory;
import jodd.http.HttpException;
import jodd.http.ProxyInfo;
import jodd.util.Base64;

public class HTTPProxySocketFactory
extends SocketFactory {
    private final ProxyInfo proxy;
    private static final Pattern RESPONSE_PATTERN = Pattern.compile("HTTP/\\S+\\s(\\d+)\\s(.*)\\s*");

    public HTTPProxySocketFactory(ProxyInfo proxy) {
        this.proxy = proxy;
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        return this.createHttpProxySocket(host, port);
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException {
        return this.createHttpProxySocket(host, port);
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        return this.createHttpProxySocket(host.getHostAddress(), port);
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        return this.createHttpProxySocket(address.getHostAddress(), port);
    }

    private Socket createHttpProxySocket(String host, int port) {
        Socket socket = null;
        String proxyAddress = this.proxy.getProxyAddress();
        int proxyPort = this.proxy.getProxyPort();
        try {
            String proxyLine;
            socket = new Socket(proxyAddress, proxyPort);
            String hostport = "CONNECT " + host + ":" + port;
            String username = this.proxy.getProxyUsername();
            if (username == null) {
                proxyLine = "";
            } else {
                String password = this.proxy.getProxyPassword();
                proxyLine = "\r\nProxy-Authorization: Basic " + Base64.encodeToString(username + ":" + password);
            }
            socket.getOutputStream().write((hostport + " HTTP/1.1\r\nHost: " + hostport + proxyLine + "\r\n\r\n").getBytes("UTF-8"));
            InputStream in = socket.getInputStream();
            StringBuilder recv = new StringBuilder(100);
            int nlchars = 0;
            do {
                int i;
                if ((i = in.read()) == -1) {
                    throw new HttpException((Object)ProxyInfo.ProxyType.HTTP, "Invalid response");
                }
                char c = (char)i;
                recv.append(c);
                if (recv.length() > 1024) {
                    throw new HttpException((Object)ProxyInfo.ProxyType.HTTP, "Received header longer then 1024 chars");
                }
                if ((nlchars == 0 || nlchars == 2) && c == '\r') {
                    ++nlchars;
                    continue;
                }
                if ((nlchars == 1 || nlchars == 3) && c == '\n') {
                    ++nlchars;
                    continue;
                }
                nlchars = 0;
            } while (nlchars != 4);
            String recvStr = recv.toString();
            BufferedReader br = new BufferedReader(new StringReader(recvStr));
            String response = br.readLine();
            if (response == null) {
                throw new HttpException((Object)ProxyInfo.ProxyType.HTTP, "Empty proxy response");
            }
            Matcher m = RESPONSE_PATTERN.matcher(response);
            if (!m.matches()) {
                throw new HttpException((Object)ProxyInfo.ProxyType.HTTP, "Unexpected proxy response");
            }
            int code = Integer.parseInt(m.group(1));
            if (code != 200) {
                throw new HttpException((Object)ProxyInfo.ProxyType.HTTP, "Invalid return status code: " + code);
            }
            return socket;
        }
        catch (RuntimeException rtex) {
            this.closeSocket(socket);
            throw rtex;
        }
        catch (Exception ex) {
            this.closeSocket(socket);
            throw new HttpException((Object)ProxyInfo.ProxyType.HTTP, ex.toString(), ex);
        }
    }

    private void closeSocket(Socket socket) {
        try {
            if (socket != null) {
                socket.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

