/*
 * Decompiled with CFR 0.152.
 */
package jodd.lagarto;

import java.nio.CharBuffer;
import jodd.util.CharUtil;

class Scanner {
    protected final boolean emitStrings;
    protected char[] input;
    protected int ndx = 0;
    protected int total;
    protected static CharBuffer EMPTY_CHAR_BUFFER = CharBuffer.wrap(new char[0]);
    private int lastOffset = -1;
    private int lastLine;
    private int lastLastNewLineOffset;

    Scanner(boolean emitStrings) {
        this.emitStrings = emitStrings;
    }

    protected void initialize(char[] input) {
        this.input = input;
        this.ndx = -1;
        this.total = input.length;
    }

    protected final int find(char target, int from, int end) {
        while (from < end && this.input[from] != target) {
            ++from;
        }
        return from == end ? -1 : from;
    }

    protected final int find(char[] target, int from, int end) {
        while (from < end && !this.match(target, from)) {
            ++from;
        }
        return from == end ? -1 : from;
    }

    protected final boolean match(char[] target, int ndx) {
        if (ndx + target.length >= this.total) {
            return false;
        }
        int j = ndx;
        int i = 0;
        while (i < target.length) {
            if (this.input[j] != target[i]) {
                return false;
            }
            ++i;
            ++j;
        }
        return true;
    }

    public final boolean match(char[] target) {
        return this.match(target, this.ndx);
    }

    public final boolean matchUpperCase(char[] uppercaseTarget) {
        if (this.ndx + uppercaseTarget.length > this.total) {
            return false;
        }
        int j = this.ndx;
        int i = 0;
        while (i < uppercaseTarget.length) {
            char c = CharUtil.toUpperAscii(this.input[j]);
            if (c != uppercaseTarget[i]) {
                return false;
            }
            ++i;
            ++j;
        }
        return true;
    }

    protected final CharSequence charSequence(int from, int to) {
        int len = to - from;
        if (len == 0) {
            return this.emitStrings ? "" : EMPTY_CHAR_BUFFER;
        }
        return this.emitStrings ? new String(this.input, from, len) : CharBuffer.wrap(this.input, from, len);
    }

    protected final boolean isEOF() {
        return this.ndx >= this.total;
    }

    protected Position position(int position) {
        int lastNewLineOffset;
        int offset;
        int line;
        if (position > this.lastOffset) {
            line = 1;
            offset = 0;
            lastNewLineOffset = 0;
        } else {
            line = this.lastLine;
            offset = this.lastOffset;
            lastNewLineOffset = this.lastLastNewLineOffset;
        }
        while (offset < position) {
            char c = this.input[offset];
            if (c == '\n') {
                ++line;
                lastNewLineOffset = offset + 1;
            }
            ++offset;
        }
        this.lastOffset = offset;
        this.lastLine = line;
        this.lastLastNewLineOffset = lastNewLineOffset;
        return new Position(position, line, position - lastNewLineOffset + 1);
    }

    public static class Position {
        private final int offset;
        private final int line;
        private final int column;

        public Position(int offset, int line, int column) {
            this.offset = offset;
            this.line = line;
            this.column = column;
        }

        public Position(int offset) {
            this.offset = offset;
            this.line = -1;
            this.column = -1;
        }

        public String toString() {
            if (this.offset == -1) {
                return "[" + this.line + ':' + this.column + ']';
            }
            if (this.line == -1) {
                return "[@" + this.offset + ']';
            }
            return "[" + this.line + ':' + this.column + " @" + this.offset + ']';
        }
    }
}

