/*
 * Decompiled with CFR 0.152.
 */
package jodd.lagarto.dom;

import jodd.lagarto.Tag;
import jodd.lagarto.dom.Document;
import jodd.lagarto.dom.Node;
import jodd.lagarto.dom.NodeVisitor;
import jodd.util.Util;

public class Element
extends Node {
    protected final boolean voidElement;
    protected final boolean selfClosed;
    protected final boolean rawTag;

    public Element(Document ownerNode, Tag tag, boolean voidElement, boolean selfClosed) {
        super(ownerNode, Node.NodeType.ELEMENT, Util.toString(tag.getName()));
        this.voidElement = voidElement;
        this.selfClosed = selfClosed;
        this.rawTag = tag.isRawTag();
        int attrCount = tag.getAttributeCount();
        for (int i = 0; i < attrCount; ++i) {
            String key = Util.toString(tag.getAttributeName(i));
            String value = Util.toString(tag.getAttributeValue(i));
            this.setAttribute(key, value);
        }
    }

    public Element(Document ownerDocument, String name) {
        this(ownerDocument, name, false, false, false);
    }

    public Element(Document ownerDocument, String name, boolean voidElement, boolean selfClosed, boolean rawTag) {
        super(ownerDocument, Node.NodeType.ELEMENT, name);
        this.voidElement = voidElement;
        this.selfClosed = selfClosed;
        this.rawTag = rawTag;
    }

    @Override
    public Element clone() {
        return this.cloneTo(new Element(this.ownerDocument, this.nodeName, this.voidElement, this.selfClosed, this.rawTag));
    }

    public boolean isVoidElement() {
        return this.voidElement;
    }

    public boolean isSelfClosed() {
        return this.selfClosed;
    }

    public boolean isRawTag() {
        return this.rawTag;
    }

    @Override
    protected void visitNode(NodeVisitor nodeVisitor) {
        nodeVisitor.element(this);
    }

    public String toString() {
        return '<' + this.nodeName + '>';
    }
}

