/*
 * Decompiled with CFR 0.152.
 */
package jodd.lagarto.dom;

import java.io.IOException;
import jodd.lagarto.TagWriterUtil;
import jodd.lagarto.dom.Attribute;
import jodd.lagarto.dom.CData;
import jodd.lagarto.dom.Comment;
import jodd.lagarto.dom.Document;
import jodd.lagarto.dom.DocumentType;
import jodd.lagarto.dom.Element;
import jodd.lagarto.dom.LagartoDOMException;
import jodd.lagarto.dom.Node;
import jodd.lagarto.dom.NodeVisitor;
import jodd.lagarto.dom.Text;
import jodd.lagarto.dom.XmlDeclaration;
import jodd.util.HtmlEncoder;

public class LagartoHtmlRendererNodeVisitor
implements NodeVisitor {
    protected final Appendable appendable;
    protected Case tagCase = Case.DEFAULT;
    protected Case attributeCase = Case.DEFAULT;

    public LagartoHtmlRendererNodeVisitor(Appendable appendable) {
        this.appendable = appendable;
    }

    @Override
    public void cdata(CData cdata) {
        String nodeValue = cdata.getNodeValue();
        try {
            TagWriterUtil.writeCData(this.appendable, nodeValue);
        }
        catch (IOException ioex) {
            throw new LagartoDOMException(ioex);
        }
    }

    @Override
    public void comment(Comment comment) {
        String nodeValue = comment.getNodeValue();
        try {
            TagWriterUtil.writeComment(this.appendable, nodeValue);
        }
        catch (IOException ioex) {
            throw new LagartoDOMException(ioex);
        }
    }

    @Override
    public void document(Document document) {
        document.visitChildren(this);
    }

    @Override
    public void documentType(DocumentType documentType) {
        try {
            TagWriterUtil.writeDoctype(this.appendable, documentType.nodeValue, documentType.publicId, documentType.systemId);
        }
        catch (IOException ioex) {
            throw new LagartoDOMException(ioex);
        }
    }

    @Override
    public void text(Text text) {
        String nodeValue = text.getTextValue();
        try {
            this.appendable.append(nodeValue);
        }
        catch (IOException ioex) {
            throw new LagartoDOMException(ioex);
        }
    }

    @Override
    public void xmlDeclaration(XmlDeclaration xmlDeclaration) {
        try {
            TagWriterUtil.writeXml(this.appendable, xmlDeclaration.getVersion(), xmlDeclaration.getEncoding(), xmlDeclaration.getStandalone());
        }
        catch (IOException ioex) {
            throw new LagartoDOMException(ioex);
        }
    }

    public void setTagCase(Case tagCase) {
        this.tagCase = tagCase;
    }

    public Case getTagCase() {
        return this.tagCase;
    }

    public void setAttributeCase(Case attributeCase) {
        this.attributeCase = attributeCase;
    }

    public Case getAttributeCase() {
        return this.attributeCase;
    }

    public void reset() {
        this.tagCase = Case.DEFAULT;
        this.attributeCase = Case.DEFAULT;
    }

    protected String resolveNodeName(Node node) {
        switch (this.tagCase) {
            case DEFAULT: {
                return node.getNodeName();
            }
            case RAW: {
                return node.getNodeRawName();
            }
            case LOWERCASE: {
                return node.getNodeRawName().toLowerCase();
            }
            case UPPERCASE: {
                return node.getNodeRawName().toUpperCase();
            }
        }
        return null;
    }

    protected String resolveAttributeName(Node node, Attribute attribute) {
        switch (this.attributeCase) {
            case DEFAULT: {
                return attribute.getName();
            }
            case RAW: {
                return attribute.getRawName();
            }
            case LOWERCASE: {
                return attribute.getRawName().toLowerCase();
            }
            case UPPERCASE: {
                return attribute.getRawName().toUpperCase();
            }
        }
        return null;
    }

    protected void renderAttribute(Node node, Attribute attribute, Appendable appendable) throws IOException {
        String name = this.resolveAttributeName(node, attribute);
        String value = attribute.getValue();
        appendable.append(name);
        if (value != null) {
            appendable.append('=');
            appendable.append('\"');
            appendable.append(HtmlEncoder.attributeDoubleQuoted(value));
            appendable.append('\"');
        }
    }

    @Override
    public void element(Element element) {
        try {
            this._element(element);
        }
        catch (IOException ioex) {
            throw new LagartoDOMException(ioex);
        }
    }

    protected void _element(Element element) throws IOException {
        String nodeName = this.resolveNodeName(element);
        this.appendable.append('<');
        this.appendable.append(nodeName);
        int attrCount = element.getAttributesCount();
        if (attrCount != 0) {
            for (int i = 0; i < attrCount; ++i) {
                Attribute attr = element.getAttribute(i);
                this.appendable.append(' ');
                this.renderAttribute(element, attr, this.appendable);
            }
        }
        int childCount = element.getChildNodesCount();
        if (element.selfClosed && childCount == 0) {
            this.appendable.append("/>");
            return;
        }
        this.appendable.append('>');
        if (element.voidElement) {
            return;
        }
        if (childCount != 0) {
            this.elementBody(element);
        }
        this.appendable.append("</");
        this.appendable.append(nodeName);
        this.appendable.append('>');
    }

    protected void elementBody(Element element) throws IOException {
        int childCount = element.getChildNodesCount();
        if (element.isRawTag()) {
            for (int i = 0; i < childCount; ++i) {
                Node childNode = element.getChild(i);
                if (childNode.getNodeType() == Node.NodeType.TEXT) {
                    this.appendable.append(childNode.getNodeValue());
                    continue;
                }
                childNode.visit(this);
            }
        } else {
            element.visitChildren(this);
        }
    }

    public static enum Case {
        DEFAULT,
        RAW,
        LOWERCASE,
        UPPERCASE;

    }
}

