/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc.component;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import jodd.madvoc.ActionConfig;
import jodd.madvoc.ActionDef;
import jodd.madvoc.ActionNames;
import jodd.madvoc.MadvocException;
import jodd.madvoc.MadvocUtil;
import jodd.madvoc.RootPackages;
import jodd.madvoc.ScopeData;
import jodd.madvoc.ScopeType;
import jodd.madvoc.component.ActionMethodParamNameResolver;
import jodd.madvoc.component.ActionsManager;
import jodd.madvoc.component.ContextInjectorComponent;
import jodd.madvoc.component.FiltersManager;
import jodd.madvoc.component.InterceptorsManager;
import jodd.madvoc.component.MadvocConfig;
import jodd.madvoc.component.ScopeDataResolver;
import jodd.madvoc.filter.ActionFilter;
import jodd.madvoc.injector.Target;
import jodd.madvoc.interceptor.ActionInterceptor;
import jodd.madvoc.meta.ActionAnnotation;
import jodd.madvoc.meta.ActionAnnotationData;
import jodd.madvoc.meta.FilteredBy;
import jodd.madvoc.meta.InterceptedBy;
import jodd.madvoc.meta.MadvocAction;
import jodd.madvoc.path.ActionNamingStrategy;
import jodd.madvoc.result.ActionResult;
import jodd.petite.meta.PetiteInject;
import jodd.util.AnnotationDataReader;
import jodd.util.ArraysUtil;
import jodd.util.ClassLoaderUtil;
import jodd.util.StringUtil;

public class ActionMethodParser {
    @PetiteInject
    protected ContextInjectorComponent contextInjectorComponent;
    @PetiteInject
    protected ActionsManager actionsManager;
    @PetiteInject
    protected InterceptorsManager interceptorsManager;
    @PetiteInject
    protected FiltersManager filtersManager;
    @PetiteInject
    protected MadvocConfig madvocConfig;
    @PetiteInject
    protected ScopeDataResolver scopeDataResolver;
    @PetiteInject
    protected ActionMethodParamNameResolver actionMethodParamNameResolver;

    public ActionDef parseActionDef(Class<?> actionClass, Method actionMethod) {
        ActionNamingStrategy namingStrategy;
        ActionAnnotationData annotationData = this.detectActionAnnotationData(actionMethod);
        ActionNames actionNames = new ActionNames();
        this.readPackageActionPath(actionNames, actionClass);
        this.readClassActionPath(actionNames, actionClass);
        this.readMethodActionPath(actionNames, actionMethod.getName(), annotationData);
        this.readMethodExtension(actionNames, annotationData);
        this.readMethodHttpMethod(actionNames, annotationData);
        Class<? extends ActionNamingStrategy> actionPathNamingStrategy = this.parseMethodNamingStrategy(annotationData);
        try {
            namingStrategy = actionPathNamingStrategy.newInstance();
            this.contextInjectorComponent.injectContext(new Target(namingStrategy));
        }
        catch (Exception ex) {
            throw new MadvocException(ex);
        }
        return namingStrategy.buildActionDef(actionClass, actionMethod, actionNames);
    }

    public ActionConfig parse(Class<?> actionClass, Method actionMethod, ActionDef actionDef) {
        ActionInterceptor[] actionInterceptors = this.parseActionInterceptors(actionClass, actionMethod);
        ActionFilter[] actionFilters = this.parseActionFilters(actionClass, actionMethod);
        if (actionDef == null) {
            actionDef = this.parseActionDef(actionClass, actionMethod);
        }
        ActionAnnotationData annotationData = this.detectActionAnnotationData(actionMethod);
        this.detectAndRegisterAlias(annotationData, actionDef);
        boolean async = this.parseMethodAsyncFlag(annotationData);
        Class<? extends ActionResult> actionResult = this.parseActionResult(annotationData);
        return this.createActionConfig(actionClass, actionMethod, actionResult, actionFilters, actionInterceptors, actionDef, async);
    }

    protected ActionAnnotationData detectActionAnnotationData(Method actionMethod) {
        ActionAnnotation<?> actionAnnotation;
        AnnotationDataReader.AnnotationData annotationData = null;
        ActionAnnotation<?>[] actionAnnotationArray = this.madvocConfig.getActionAnnotationInstances();
        int n = actionAnnotationArray.length;
        for (int i = 0; i < n && (annotationData = (actionAnnotation = actionAnnotationArray[i]).readAnnotationData(actionMethod)) == null; ++i) {
        }
        return annotationData;
    }

    protected void detectAndRegisterAlias(ActionAnnotationData annotationData, ActionDef actionDef) {
        String alias = this.parseMethodAlias(annotationData);
        if (alias != null) {
            String aliasPath = StringUtil.cutToIndexOf(actionDef.getActionPath(), "#");
            this.actionsManager.registerPathAlias(alias, aliasPath);
        }
    }

    protected Class<? extends ActionResult> parseActionResult(ActionAnnotationData annotationData) {
        if (annotationData == null) {
            return null;
        }
        Class<ActionResult> actionResult = annotationData.getResult();
        if (actionResult == ActionResult.class) {
            return null;
        }
        return actionResult;
    }

    protected ActionInterceptor[] parseActionInterceptors(Class<?> actionClass, Method actionMethod) {
        Class[] interceptorClasses = this.readActionInterceptors(actionMethod);
        if (interceptorClasses == null) {
            interceptorClasses = this.readActionInterceptors(actionClass);
        }
        if (interceptorClasses == null) {
            interceptorClasses = this.madvocConfig.getDefaultInterceptors();
        }
        return (ActionInterceptor[])this.interceptorsManager.resolveAll(interceptorClasses);
    }

    protected ActionFilter[] parseActionFilters(Class<?> actionClass, Method actionMethod) {
        Class[] filterClasses = this.readActionFilters(actionMethod);
        if (filterClasses == null) {
            filterClasses = this.readActionFilters(actionClass);
        }
        if (filterClasses == null) {
            filterClasses = this.madvocConfig.getDefaultFilters();
        }
        return (ActionFilter[])this.filtersManager.resolveAll(filterClasses);
    }

    protected Class<? extends ActionInterceptor>[] readActionInterceptors(AnnotatedElement actionClassOrMethod) {
        Class<? extends ActionInterceptor>[] result = null;
        InterceptedBy interceptedBy = actionClassOrMethod.getAnnotation(InterceptedBy.class);
        if (interceptedBy != null && (result = interceptedBy.value()).length == 0) {
            result = null;
        }
        return result;
    }

    protected Class<? extends ActionFilter>[] readActionFilters(AnnotatedElement actionClassOrMethod) {
        Class<? extends ActionFilter>[] result = null;
        FilteredBy filteredBy = actionClassOrMethod.getAnnotation(FilteredBy.class);
        if (filteredBy != null && (result = filteredBy.value()).length == 0) {
            result = null;
        }
        return result;
    }

    protected void readPackageActionPath(ActionNames actionNames, Class actionClass) {
        MadvocAction madvocActionAnnotation;
        String packageActionPath;
        Package actionPackage = actionClass.getPackage();
        String actionPackageName = actionPackage.getName();
        RootPackages rootPackages = this.madvocConfig.getRootPackages();
        String packagePath = rootPackages.getPackageActionPath(actionPackageName);
        if (packagePath == null) {
            packagePath = rootPackages.findPackagePathForActionPackage(actionPackageName);
            String rootPackage = null;
            if (packagePath != null) {
                rootPackage = rootPackages.findRootPackageForActionPath(packagePath);
            }
            String packageName = actionPackageName;
            String madvocRootPackageClassName = this.madvocConfig.getMadvocRootPackageClassName();
            if (madvocRootPackageClassName != null) {
                while (true) {
                    String className = packageName + '.' + madvocRootPackageClassName;
                    try {
                        Class madvocRootPackageClass = ClassLoaderUtil.loadClass(className, actionClass.getClassLoader());
                        String mapping = "";
                        MadvocAction madvocAction = madvocRootPackageClass.getAnnotation(MadvocAction.class);
                        if (madvocAction != null) {
                            mapping = madvocAction.value();
                        }
                        this.madvocConfig.getRootPackages().addRootPackage(packageName, mapping);
                        packagePath = rootPackages.findPackagePathForActionPackage(actionPackageName);
                    }
                    catch (ClassNotFoundException ignore) {
                        int dotNdx = packageName.lastIndexOf(46);
                        if (dotNdx != -1) {
                            packageName = packageName.substring(0, dotNdx);
                            if (rootPackage == null || !packageName.equals(rootPackage)) continue;
                        }
                    }
                    break;
                }
            }
            rootPackages.registerPackageActionPath(actionPackageName, packagePath);
        }
        String string = packageActionPath = (madvocActionAnnotation = actionPackage.getAnnotation(MadvocAction.class)) != null ? madvocActionAnnotation.value().trim() : null;
        if (StringUtil.isEmpty(packageActionPath)) {
            packageActionPath = null;
        }
        if (packageActionPath == null) {
            if (packagePath == null) {
                return;
            }
            packageActionPath = packagePath;
        }
        actionNames.setPackageNames(StringUtil.stripChar(packagePath, '/'), StringUtil.surround(packageActionPath, "/"));
    }

    protected void readClassActionPath(ActionNames actionNames, Class actionClass) {
        String classActionPath;
        MadvocAction madvocActionAnnotation = actionClass.getAnnotation(MadvocAction.class);
        String string = classActionPath = madvocActionAnnotation != null ? madvocActionAnnotation.value().trim() : null;
        if (StringUtil.isEmpty(classActionPath)) {
            classActionPath = null;
        }
        String name = actionClass.getSimpleName();
        name = StringUtil.uncapitalize(name);
        name = MadvocUtil.stripLastCamelWord(name);
        if (classActionPath == null) {
            classActionPath = name;
        }
        actionNames.setClassNames(name, classActionPath);
    }

    protected void readMethodActionPath(ActionNames actionNames, String methodName, ActionAnnotationData annotationData) {
        String methodActionPath;
        String string = methodActionPath = annotationData != null ? annotationData.getValue() : null;
        if (methodActionPath == null) {
            methodActionPath = methodName;
        } else if (methodActionPath.equals("#")) {
            return;
        }
        for (String path : this.madvocConfig.getDefaultActionMethodNames()) {
            if (!methodActionPath.equals(path)) continue;
            methodActionPath = null;
            break;
        }
        actionNames.setMethodNames(methodName, methodActionPath);
    }

    protected void readMethodExtension(ActionNames actionNames, ActionAnnotationData annotationData) {
        String annExtension;
        String extension = this.madvocConfig.getDefaultExtension();
        if (annotationData != null && (annExtension = annotationData.getExtension()) != null) {
            extension = annExtension.equals("#") ? null : annExtension;
        }
        actionNames.setExtension(extension);
    }

    protected String parseMethodAlias(ActionAnnotationData annotationData) {
        String alias = null;
        if (annotationData != null) {
            alias = annotationData.getAlias();
        }
        return alias;
    }

    private void readMethodHttpMethod(ActionNames actionNames, ActionAnnotationData annotationData) {
        String method = null;
        if (annotationData != null) {
            method = annotationData.getMethod();
        }
        actionNames.setHttpMethod(method);
    }

    private boolean parseMethodAsyncFlag(ActionAnnotationData annotationData) {
        boolean sync = false;
        if (annotationData != null) {
            sync = annotationData.isAsync();
        }
        return sync;
    }

    private Class<? extends ActionNamingStrategy> parseMethodNamingStrategy(ActionAnnotationData annotationData) {
        Class<ActionNamingStrategy> actionNamingStrategyClass = null;
        if (annotationData != null && (actionNamingStrategyClass = annotationData.getPath()) == ActionNamingStrategy.class) {
            actionNamingStrategyClass = null;
        }
        if (actionNamingStrategyClass == null) {
            actionNamingStrategyClass = this.madvocConfig.getDefaultNamingStrategy();
        }
        return actionNamingStrategyClass;
    }

    public ActionConfig createActionConfig(Class actionClass, Method actionClassMethod, Class<? extends ActionResult> actionResult, ActionFilter[] filters, ActionInterceptor[] interceptors, ActionDef actionDef, boolean async) {
        Class<?>[] paramTypes = actionClassMethod.getParameterTypes();
        ActionConfig.MethodParam[] params = new ActionConfig.MethodParam[paramTypes.length];
        Annotation[][] paramAnns = actionClassMethod.getParameterAnnotations();
        String[] methodParamNames = null;
        Class[] types = ArraysUtil.insert(paramTypes, actionClass, 0);
        ScopeData[][] allScopeData = new ScopeData[ScopeType.values().length][];
        for (int i = 0; i < types.length; ++i) {
            Class type = types[i];
            ScopeData[] scopeData = null;
            if (i > 0) {
                if (methodParamNames == null) {
                    methodParamNames = this.actionMethodParamNameResolver.resolveParamNames(actionClassMethod);
                }
                int paramIndex = i - 1;
                String paramName = methodParamNames[paramIndex];
                scopeData = this.scopeDataResolver.resolveScopeData(paramName, type, paramAnns[paramIndex]);
                params[paramIndex] = new ActionConfig.MethodParam(paramTypes[paramIndex], paramName, this.scopeDataResolver.detectAnnotationType(paramAnns[paramIndex]));
            }
            if (scopeData == null) {
                scopeData = this.scopeDataResolver.resolveScopeData(type);
            }
            if (scopeData == null) continue;
            for (int j = 0; j < ScopeType.values().length; ++j) {
                if (allScopeData[j] == null) {
                    allScopeData[j] = new ScopeData[types.length];
                }
                allScopeData[j][i] = scopeData[j];
            }
        }
        return new ActionConfig(actionClass, actionClassMethod, filters, interceptors, actionDef, actionResult, async, allScopeData, params);
    }
}

