/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc.config;

import java.io.File;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import jodd.introspector.ClassDescriptor;
import jodd.introspector.ClassIntrospector;
import jodd.introspector.MethodDescriptor;
import jodd.io.findfile.ClassFinder;
import jodd.log.Logger;
import jodd.log.LoggerFactory;
import jodd.madvoc.MadvocException;
import jodd.madvoc.component.ActionsManager;
import jodd.madvoc.component.MadvocConfig;
import jodd.madvoc.component.ResultsManager;
import jodd.madvoc.config.MadvocConfigurator;
import jodd.madvoc.meta.ActionAnnotation;
import jodd.madvoc.meta.MadvocAction;
import jodd.madvoc.result.ActionResult;
import jodd.petite.meta.PetiteInject;
import jodd.util.ClassLoaderUtil;
import jodd.util.ClassUtil;

public class AutomagicMadvocConfigurator
extends ClassFinder
implements MadvocConfigurator {
    private static final Logger log = LoggerFactory.getLogger(AutomagicMadvocConfigurator.class);
    @PetiteInject
    protected MadvocConfig madvocConfig;
    @PetiteInject
    protected ActionsManager actionsManager;
    @PetiteInject
    protected ResultsManager resultsManager;
    protected String actionClassSuffix = "Action";
    protected String resultClassSuffix = "Result";
    protected long elapsed = 0L;

    @Override
    public void configure() {
        this.configure(ClassLoaderUtil.getDefaultClasspath());
    }

    public void configure(File[] classpath) {
        this.elapsed = System.currentTimeMillis();
        this.rulesEntries.smartMode();
        try {
            this.scanPaths(classpath);
        }
        catch (Exception ex) {
            throw new MadvocException("Scan classpath error", ex);
        }
        this.elapsed = System.currentTimeMillis() - this.elapsed;
        log.info("Madvoc configured in " + this.elapsed + " ms. Total actions: " + this.actionsManager.getActionsCount());
    }

    @Override
    protected void onEntry(ClassFinder.EntryData entryData) {
        block7: {
            String entryName = entryData.getName();
            if (entryName.endsWith(this.actionClassSuffix)) {
                try {
                    this.onActionClass(entryName);
                }
                catch (ClassNotFoundException cnfex) {
                    if (log.isDebugEnabled()) {
                        log.debug("Invalid action skipped: {}" + entryName);
                    }
                    break block7;
                }
            }
            if (entryName.endsWith(this.resultClassSuffix)) {
                try {
                    this.onResultClass(entryName);
                }
                catch (ClassNotFoundException cnfex) {
                    if (!log.isDebugEnabled()) break block7;
                    log.debug("Invalid result skipped: {}" + entryName);
                }
            }
        }
    }

    public boolean checkClass(Class clazz) {
        try {
            if (clazz.isAnonymousClass()) {
                return false;
            }
            if (clazz.isArray() || clazz.isEnum()) {
                return false;
            }
            if (clazz.isInterface()) {
                return false;
            }
            if (clazz.isLocalClass()) {
                return false;
            }
            if (clazz.isMemberClass() ^ Modifier.isStatic(clazz.getModifiers())) {
                return false;
            }
            if (clazz.isPrimitive()) {
                return false;
            }
            int modifiers = clazz.getModifiers();
            return !Modifier.isAbstract(modifiers);
        }
        catch (Throwable ignore) {
            return false;
        }
    }

    protected void onActionClass(String className) throws ClassNotFoundException {
        MethodDescriptor[] allMethodDescriptors;
        Class actionClass = this.loadClass(className);
        if (actionClass == null) {
            return;
        }
        if (!this.checkClass(actionClass)) {
            return;
        }
        if (actionClass.getAnnotation(MadvocAction.class) == null) {
            return;
        }
        ClassDescriptor cd = ClassIntrospector.lookup(actionClass);
        for (MethodDescriptor methodDescriptor : allMethodDescriptors = cd.getAllMethodDescriptors()) {
            if (!methodDescriptor.isPublic()) continue;
            Method method = methodDescriptor.getMethod();
            boolean hasAnnotation = false;
            for (ActionAnnotation<?> actionAnnotation : this.madvocConfig.getActionAnnotationInstances()) {
                if (!actionAnnotation.hasAnnotation(method)) continue;
                hasAnnotation = true;
                break;
            }
            if (!hasAnnotation) continue;
            this.actionsManager.register(actionClass, method);
        }
    }

    protected void onResultClass(String className) throws ClassNotFoundException {
        Class resultClass = this.loadClass(className);
        if (resultClass == null) {
            return;
        }
        if (!this.checkClass(resultClass)) {
            return;
        }
        if (ClassUtil.isTypeOf(resultClass, ActionResult.class)) {
            this.resultsManager.register(resultClass);
        }
    }
}

