/*
 * Decompiled with CFR 0.152.
 */
package jodd.joy.crypt;

import java.io.UnsupportedEncodingException;
import jodd.joy.crypt.BlockCipher;
import jodd.util.Bits;

public class Threefish
extends BlockCipher {
    private static final long EXTENDED_KEY_SCHEDULE_CONST = 0x5555555555555555L;
    public static final int BLOCK_SIZE_BITS_256 = 256;
    public static final int BLOCK_SIZE_BITS_512 = 512;
    public static final int BLOCK_SIZE_BITS_1024 = 1024;
    private static final int ROUNDS_72 = 72;
    private static final int ROUNDS_80 = 80;
    private static final int WORDS_4 = 4;
    private static final int WORDS_8 = 8;
    private static final int WORDS_16 = 16;
    private static final int TWEAK_VALUES = 3;
    private static final int SUBKEY_INTERVAL = 4;
    private static final int[] PI4 = new int[]{0, 3, 2, 1};
    private static final int[] PI8 = new int[]{2, 1, 4, 7, 6, 5, 0, 3};
    private static final int[] PI16 = new int[]{0, 9, 2, 13, 6, 11, 4, 15, 10, 7, 12, 3, 14, 5, 8, 1};
    private static final int[] RPI4 = new int[]{0, 3, 2, 1};
    private static final int[] RPI8 = new int[]{6, 1, 0, 7, 2, 5, 4, 3};
    private static final int[] RPI16 = new int[]{0, 15, 2, 11, 6, 13, 4, 9, 14, 1, 8, 5, 10, 3, 12, 7};
    private static final int DEPTH_OF_D_IN_R = 8;
    private static final int[][] R4 = new int[][]{{5, 56}, {36, 28}, {13, 46}, {58, 44}, {26, 20}, {53, 35}, {11, 42}, {59, 50}};
    private static final int[][] R8 = new int[][]{{38, 30, 50, 53}, {48, 20, 43, 31}, {34, 14, 15, 27}, {26, 12, 58, 7}, {33, 49, 8, 42}, {39, 27, 41, 14}, {29, 26, 11, 9}, {33, 51, 39, 35}};
    private static final int[][] R16 = new int[][]{{55, 43, 37, 40, 16, 22, 38, 12}, {25, 25, 46, 13, 14, 13, 52, 57}, {33, 8, 18, 57, 21, 12, 32, 54}, {34, 43, 25, 60, 44, 9, 59, 34}, {28, 7, 47, 48, 51, 9, 35, 41}, {17, 6, 18, 25, 43, 42, 40, 15}, {58, 7, 32, 45, 19, 18, 2, 56}, {47, 49, 27, 58, 37, 48, 53, 56}};
    private final long[] t = new long[3];
    private final long[] x = new long[2];
    private final long[] y = new long[2];
    private final int blockSize;
    private final int nr;
    private long[] k;
    private int nw;
    private int[] pi;
    private int[] rpi;
    private int[][] r;
    private long[] vd;
    private long[] ed;
    private long[] fd;
    private long[] ksd;

    public Threefish(int blockSize) {
        super(blockSize);
        this.blockSize = blockSize;
        switch (blockSize) {
            case 256: 
            case 512: {
                this.nr = 72;
                break;
            }
            case 1024: {
                this.nr = 80;
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal blocksize, use 256, 512 or 1024 bit values as blocksize");
            }
        }
    }

    public Threefish(int blockSize, int rounds) {
        super(blockSize);
        this.blockSize = blockSize;
        switch (blockSize) {
            case 256: 
            case 512: 
            case 1024: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal blocksize, use 256, 512 or 1024 bit values as blocksize");
            }
        }
        if (rounds <= 0 || rounds % 4 != 0) {
            throw new IllegalArgumentException("Number of rounds should be at least 1 and should be a multiple of 4");
        }
        this.nr = rounds;
    }

    public void init(long[] key, long[] tweak) {
        int newNw = key.length;
        if (this.nw != newNw) {
            this.nw = newNw;
            switch (this.nw) {
                case 4: {
                    this.pi = PI4;
                    this.rpi = RPI4;
                    this.r = R4;
                    break;
                }
                case 8: {
                    this.pi = PI8;
                    this.rpi = RPI8;
                    this.r = R8;
                    break;
                }
                case 16: {
                    this.pi = PI16;
                    this.rpi = RPI16;
                    this.r = R16;
                    break;
                }
                default: {
                    throw new RuntimeException("Invalid threefish key");
                }
            }
            this.k = new long[this.nw + 1];
            this.vd = new long[this.nw];
            this.ed = new long[this.nw];
            this.fd = new long[this.nw];
            this.ksd = new long[this.nw];
        }
        System.arraycopy(key, 0, this.k, 0, key.length);
        long knw = 0x5555555555555555L;
        for (int i = 0; i < this.nw; ++i) {
            knw ^= this.k[i];
        }
        this.k[this.nw] = knw;
        this.t[0] = tweak[0];
        this.t[1] = tweak[1];
        this.t[2] = this.t[0] ^ this.t[1];
    }

    public void blockEncrypt(long[] p, long[] c) {
        System.arraycopy(p, 0, this.vd, 0, this.nw);
        for (int d = 0; d < this.nr; ++d) {
            if (d % 4 == 0) {
                int s = d / 4;
                this.keySchedule(s);
                for (int i = 0; i < this.nw; ++i) {
                    this.ed[i] = this.vd[i] + this.ksd[i];
                }
            } else {
                System.arraycopy(this.vd, 0, this.ed, 0, this.nw);
            }
            for (int j = 0; j < this.nw / 2; ++j) {
                this.x[0] = this.ed[j * 2];
                this.x[1] = this.ed[j * 2 + 1];
                this.mix(j, d);
                this.fd[j * 2] = this.y[0];
                this.fd[j * 2 + 1] = this.y[1];
            }
            for (int i = 0; i < this.nw; ++i) {
                this.vd[i] = this.fd[this.pi[i]];
            }
        }
        this.keySchedule(this.nr / 4);
        for (int i = 0; i < this.nw; ++i) {
            c[i] = this.vd[i] + this.ksd[i];
        }
    }

    private void mix(int j, int d) {
        this.y[0] = this.x[0] + this.x[1];
        long rotl = this.r[d % 8][j];
        this.y[1] = this.x[1] << (int)rotl | this.x[1] >>> (int)(64L - rotl);
        this.y[1] = this.y[1] ^ this.y[0];
    }

    public void blockDecrypt(long[] c, long[] p) {
        System.arraycopy(c, 0, this.vd, 0, this.nw);
        for (int d = this.nr; d > 0; --d) {
            if (d % 4 == 0) {
                int s = d / 4;
                this.keySchedule(s);
                for (int i = 0; i < this.nw; ++i) {
                    this.fd[i] = this.vd[i] - this.ksd[i];
                }
            } else {
                System.arraycopy(this.vd, 0, this.fd, 0, this.nw);
            }
            for (int i = 0; i < this.nw; ++i) {
                this.ed[i] = this.fd[this.rpi[i]];
            }
            for (int j = 0; j < this.nw / 2; ++j) {
                this.y[0] = this.ed[j * 2];
                this.y[1] = this.ed[j * 2 + 1];
                this.demix(j, d - 1);
                this.vd[j * 2] = this.x[0];
                this.vd[j * 2 + 1] = this.x[1];
            }
        }
        this.keySchedule(0);
        for (int i = 0; i < this.nw; ++i) {
            p[i] = this.vd[i] - this.ksd[i];
        }
    }

    private void demix(int j, int d) {
        this.y[1] = this.y[1] ^ this.y[0];
        long rotr = this.r[d % 8][j];
        this.x[1] = this.y[1] << (int)(64L - rotr) | this.y[1] >>> (int)rotr;
        this.x[0] = this.y[0] - this.x[1];
    }

    private void keySchedule(int s) {
        for (int i = 0; i < this.nw; ++i) {
            this.ksd[i] = this.k[(s + i) % (this.nw + 1)];
            if (i == this.nw - 3) {
                int n = i;
                this.ksd[n] = this.ksd[n] + this.t[s % 3];
                continue;
            }
            if (i == this.nw - 2) {
                int n = i;
                this.ksd[n] = this.ksd[n] + this.t[(s + 1) % 3];
                continue;
            }
            if (i != this.nw - 1) continue;
            int n = i;
            this.ksd[n] = this.ksd[n] + (long)s;
        }
    }

    public void init(String keyMessage, long tweak1, long tweak2) {
        byte[] key;
        byte[] keyData;
        long[] tweak = new long[]{tweak1, tweak2};
        System.arraycopy(keyData, 0, key, 0, (key = new byte[this.blockSize / 8]).length < (keyData = this.getBytes(keyMessage)).length ? key.length : keyData.length);
        this.init(Threefish.bytesToLongs(key), tweak);
    }

    public byte[] encryptBlock(byte[] content, int offset) {
        long[] contentBlock = Threefish.bytesToLongs(content, offset, this.blockSizeInBytes);
        long[] encryptedBlock = new long[this.blockSize / 64];
        this.blockEncrypt(contentBlock, encryptedBlock);
        return Threefish.longsToBytes(encryptedBlock);
    }

    public byte[] decryptBlock(byte[] encryptedContent, int offset) {
        long[] encryptedBlock = Threefish.bytesToLongs(encryptedContent, offset, this.blockSizeInBytes);
        long[] decryptedBlock = new long[encryptedBlock.length];
        this.blockDecrypt(encryptedBlock, decryptedBlock);
        return Threefish.longsToBytes(decryptedBlock);
    }

    public byte[] encryptString(String plain) {
        return this.encrypt(this.getBytes(plain));
    }

    public String decryptString(byte[] encrypted) {
        try {
            return new String(this.decrypt(encrypted), "UTF-8");
        }
        catch (UnsupportedEncodingException ignore) {
            return null;
        }
    }

    protected byte[] getBytes(String string) {
        try {
            return string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ignore) {
            return null;
        }
    }

    protected static long[] bytesToLongs(byte[] ba) {
        return Threefish.bytesToLongs(ba, 0, ba.length);
    }

    protected static long[] bytesToLongs(byte[] ba, int offset, int size) {
        long[] result = new long[size >> 3];
        int i8 = offset;
        for (int i = 0; i < result.length; ++i) {
            result[i] = Bits.getLong((byte[])ba, (int)i8);
            i8 += 8;
        }
        return result;
    }

    protected static byte[] longsToBytes(long[] la) {
        byte[] result = new byte[la.length << 3];
        int i8 = 0;
        for (long l : la) {
            Bits.putLong((byte[])result, (int)i8, (long)l);
            i8 += 8;
        }
        return result;
    }
}

