/*
 * Decompiled with CFR 0.152.
 */
package org.joinfaces.autoconfigure.faces;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jakarta.faces.application.ProjectStage;
import lombok.Generated;
import org.joinfaces.autoconfigure.faces.JakartaFaces3AutoConfiguration;
import org.joinfaces.autoconfigure.faces.JakartaFaces3Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;

@AutoConfiguration(before={JakartaFaces3AutoConfiguration.class})
@ConditionalOnClass(value={ProjectStage.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
public class ProjectStageAutoConfiguration {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProjectStageAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(value={"debug"})
    public static ProjectStageCustomizer developmentProjectStageCustomizer() {
        return new ProjectStageCustomizer(ProjectStage.Development);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(value={"debug"}, havingValue="false", matchIfMissing=true)
    public static ProjectStageCustomizer productionProjectStageCustomizer() {
        return new ProjectStageCustomizer(ProjectStage.Production);
    }

    public static class ProjectStageCustomizer
    implements BeanPostProcessor {
        private final ProjectStage projectStage;

        public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
            if (bean instanceof JakartaFaces3Properties && ((JakartaFaces3Properties)bean).getProjectStage() == null) {
                ((JakartaFaces3Properties)bean).setProjectStage(this.projectStage);
            }
            return bean;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ProjectStageCustomizer(ProjectStage projectStage) {
            this.projectStage = projectStage;
        }
    }
}

