/*
 * Decompiled with CFR 0.152.
 */
package org.joinfaces.configuration;

import java.util.Map;
import org.joinfaces.configuration.ConditionalOnClassVersion;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.type.AnnotatedTypeMetadata;

public class ClassVersionCondition
extends SpringBootCondition {
    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        Map annotationAttributes = metadata.getAnnotationAttributes(ConditionalOnClassVersion.class.getName(), false);
        Class clazz = (Class)annotationAttributes.get("value");
        String version = (String)annotationAttributes.get("versionRegex");
        String specificationVersion = clazz.getPackage().getSpecificationVersion();
        if (specificationVersion != null && specificationVersion.matches(version)) {
            return ConditionOutcome.match((ConditionMessage)ConditionMessage.forCondition(ConditionalOnClassVersion.class, (Object[])new Object[0]).found("Specification-Version").items(new Object[]{specificationVersion}));
        }
        String implementationVersion = clazz.getPackage().getImplementationVersion();
        if (implementationVersion != null && implementationVersion.matches(version)) {
            return ConditionOutcome.match((ConditionMessage)ConditionMessage.forCondition(ConditionalOnClassVersion.class, (Object[])new Object[0]).found("Implementation-Version").items(new Object[]{implementationVersion}));
        }
        if (specificationVersion == null && implementationVersion == null) {
            return ConditionOutcome.noMatch((ConditionMessage)ConditionMessage.forCondition(ConditionalOnClassVersion.class, (Object[])new Object[0]).didNotFind("manifest attributes").items(new Object[]{"Specification-Version", "Implementation-Version"}));
        }
        return ConditionOutcome.noMatch((ConditionMessage)ConditionMessage.forCondition(ConditionalOnClassVersion.class, (Object[])new Object[0]).found("version", "versions").items(new Object[]{specificationVersion, implementationVersion}));
    }
}

