/*
 * Decompiled with CFR 0.152.
 */
package org.jomc.model;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.jomc.model.ModelContext;
import org.jomc.model.ModelErrorHandler;
import org.jomc.model.ModelException;
import org.jomc.model.ModelProcessor;
import org.jomc.model.ModelProvider;
import org.jomc.model.ModelValidationReport;
import org.jomc.model.ModelValidator;
import org.jomc.model.Modules;
import org.jomc.model.ObjectFactory;
import org.jomc.model.Text;
import org.jomc.model.Texts;
import org.jomc.model.bootstrap.BootstrapContext;
import org.jomc.model.bootstrap.BootstrapException;
import org.jomc.model.bootstrap.Schema;
import org.jomc.model.bootstrap.Schemas;
import org.jomc.model.bootstrap.Service;
import org.jomc.model.bootstrap.Services;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultModelContext
extends ModelContext {
    private static final String[] SCHEMA_EXTENSIONS = new String[]{"xsd"};
    private Reference<Services> cachedServices = new SoftReference<Object>(null);
    private Reference<Schemas> cachedSchemas = new SoftReference<Object>(null);
    private Reference<Set<URI>> cachedSchemaResources = new SoftReference<Object>(null);

    public DefaultModelContext(ClassLoader classLoader) {
        super(classLoader);
    }

    @Override
    public Modules findModules() throws ModelException {
        try {
            Text text = new Text();
            text.setLanguage("en");
            text.setValue(DefaultModelContext.getMessage("contextModulesInfo", new Object[0]));
            Modules modules = new Modules();
            modules.setDocumentation(new Texts());
            modules.getDocumentation().setDefaultLanguage("en");
            modules.getDocumentation().getText().add(text);
            List<Service> providers = this.getServices().getServices(ModelProvider.class);
            if (providers != null) {
                for (Service provider : providers) {
                    Class modelProviderClass = this.findClass(provider.getClazz());
                    if (modelProviderClass == null) {
                        throw new ModelException(DefaultModelContext.getMessage("serviceNotFound", provider.getOrdinal(), provider.getIdentifier(), provider.getClazz()));
                    }
                    ModelProvider modelProvider = (ModelProvider)modelProviderClass.newInstance();
                    Modules provided = modelProvider.findModules(this);
                    if (provided == null) continue;
                    modules.getModule().addAll(provided.getModule());
                }
            }
            if (this.isLoggable(Level.FINEST)) {
                String line;
                StringWriter stringWriter = new StringWriter();
                Marshaller m = this.createMarshaller();
                m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
                m.marshal(new ObjectFactory().createModules(modules), (Writer)stringWriter);
                stringWriter.close();
                this.log(Level.FINEST, DefaultModelContext.getMessage("foundModules", new Object[0]), null);
                BufferedReader reader = new BufferedReader(new StringReader(stringWriter.toString()));
                while ((line = reader.readLine()) != null) {
                    this.log(Level.FINEST, "\t" + line, null);
                }
                reader.close();
            }
            return modules;
        }
        catch (BootstrapException e) {
            throw new ModelException(e.getMessage(), e);
        }
        catch (InstantiationException e) {
            throw new ModelException(e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new ModelException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ModelException(e.getMessage(), e);
        }
        catch (JAXBException e) {
            throw new ModelException(e.getMessage(), e);
        }
    }

    @Override
    public Modules processModules(Modules modules) throws ModelException {
        if (modules == null) {
            throw new NullPointerException("modules");
        }
        try {
            Modules processed = modules;
            List<Service> processors = this.getServices().getServices(ModelProcessor.class);
            if (processors != null) {
                for (Service processor : processors) {
                    Class modelProcessorClass = this.findClass(processor.getClazz());
                    if (modelProcessorClass == null) {
                        throw new ModelException(DefaultModelContext.getMessage("serviceNotFound", processor.getOrdinal(), processor.getIdentifier(), processor.getClazz()));
                    }
                    ModelProcessor modelProcessor = (ModelProcessor)modelProcessorClass.newInstance();
                    Modules current = modelProcessor.processModules(this, processed);
                    if (current == null) continue;
                    processed = current;
                }
            }
            if (this.isLoggable(Level.FINEST)) {
                String line;
                StringWriter stringWriter = new StringWriter();
                Marshaller m = this.createMarshaller();
                m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
                m.marshal(new ObjectFactory().createModules(processed), (Writer)stringWriter);
                stringWriter.close();
                this.log(Level.FINEST, DefaultModelContext.getMessage("processedModules", new Object[0]), null);
                BufferedReader reader = new BufferedReader(new StringReader(stringWriter.toString()));
                while ((line = reader.readLine()) != null) {
                    this.log(Level.FINEST, "\t" + line, null);
                }
                reader.close();
            }
            return processed;
        }
        catch (BootstrapException e) {
            throw new ModelException(e.getMessage(), e);
        }
        catch (InstantiationException e) {
            throw new ModelException(e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new ModelException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ModelException(e.getMessage(), e);
        }
        catch (JAXBException e) {
            throw new ModelException(e.getMessage(), e);
        }
    }

    @Override
    public ModelValidationReport validateModel(Source model) throws ModelException {
        if (model == null) {
            throw new NullPointerException("model");
        }
        javax.xml.validation.Schema schema = this.createSchema();
        Validator validator = schema.newValidator();
        ModelErrorHandler modelErrorHandler = new ModelErrorHandler(this);
        validator.setErrorHandler(modelErrorHandler);
        try {
            validator.validate(model);
        }
        catch (SAXException e) {
            if (this.isLoggable(Level.FINE)) {
                this.log(Level.FINE, e.getMessage(), e);
            }
            if (modelErrorHandler.getReport().isModelValid()) {
                throw new ModelException(e.getMessage(), e);
            }
        }
        catch (IOException e) {
            throw new ModelException(e.getMessage(), e);
        }
        return modelErrorHandler.getReport();
    }

    @Override
    public ModelValidationReport validateModel(Modules modules) throws ModelException {
        if (modules == null) {
            throw new NullPointerException("modules");
        }
        try {
            List<Service> validators = this.getServices().getServices(ModelValidator.class);
            ModelValidationReport report = new ModelValidationReport();
            if (validators != null) {
                for (Service validator : validators) {
                    Class modelValidatorClass = this.findClass(validator.getClazz());
                    if (modelValidatorClass == null) {
                        throw new ModelException(DefaultModelContext.getMessage("serviceNotFound", validator.getOrdinal(), validator.getIdentifier(), validator.getClazz()));
                    }
                    ModelValidator modelValidator = (ModelValidator)modelValidatorClass.newInstance();
                    ModelValidationReport current = modelValidator.validateModel(this, modules);
                    if (current == null) continue;
                    report.getDetails().addAll(current.getDetails());
                }
            }
            return report;
        }
        catch (BootstrapException e) {
            throw new ModelException(e.getMessage(), e);
        }
        catch (InstantiationException e) {
            throw new ModelException(e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new ModelException(e.getMessage(), e);
        }
    }

    @Override
    public EntityResolver createEntityResolver() throws ModelException {
        return new DefaultHandler(){

            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                InputSource schemaSource;
                block19: {
                    if (systemId == null) {
                        throw new NullPointerException("systemId");
                    }
                    schemaSource = null;
                    try {
                        Schema s = null;
                        Schemas classpathSchemas = DefaultModelContext.this.getSchemas();
                        if (publicId != null) {
                            s = classpathSchemas.getSchemaByPublicId(publicId);
                        }
                        if (s == null) {
                            s = classpathSchemas.getSchemaBySystemId(systemId);
                        }
                        if (s != null) {
                            schemaSource = new InputSource();
                            schemaSource.setPublicId(s.getPublicId() != null ? s.getPublicId() : publicId);
                            schemaSource.setSystemId(s.getSystemId());
                            if (s.getClasspathId() != null) {
                                URL resource = DefaultModelContext.this.findResource(s.getClasspathId());
                                if (resource != null) {
                                    schemaSource.setSystemId(resource.toExternalForm());
                                } else if (DefaultModelContext.this.isLoggable(Level.WARNING)) {
                                    DefaultModelContext.this.log(Level.WARNING, DefaultModelContext.getMessage("resourceNotFound", new Object[]{s.getClasspathId()}), null);
                                }
                            }
                            if (DefaultModelContext.this.isLoggable(Level.FINE)) {
                                DefaultModelContext.this.log(Level.FINE, DefaultModelContext.getMessage("resolutionInfo", new Object[]{publicId + ", " + systemId, schemaSource.getPublicId() + ", " + schemaSource.getSystemId()}), null);
                            }
                        }
                        if (schemaSource != null) break block19;
                        URI systemUri = new URI(systemId);
                        String schemaName = systemUri.getPath();
                        if (schemaName != null) {
                            int lastIndexOfSlash = schemaName.lastIndexOf(47);
                            if (lastIndexOfSlash != -1 && lastIndexOfSlash < schemaName.length()) {
                                schemaName = schemaName.substring(lastIndexOfSlash + 1);
                            }
                            for (URI uri : DefaultModelContext.this.getSchemaResources()) {
                                if (!uri.getPath().endsWith(schemaName)) continue;
                                schemaSource = new InputSource();
                                schemaSource.setPublicId(publicId);
                                schemaSource.setSystemId(uri.toASCIIString());
                                if (DefaultModelContext.this.isLoggable(Level.FINE)) {
                                    DefaultModelContext.this.log(Level.FINE, DefaultModelContext.getMessage("resolutionInfo", new Object[]{systemUri.toASCIIString(), schemaSource.getSystemId()}), null);
                                }
                                break block19;
                            }
                            break block19;
                        }
                        if (DefaultModelContext.this.isLoggable(Level.WARNING)) {
                            DefaultModelContext.this.log(Level.WARNING, DefaultModelContext.getMessage("unsupportedSystemIdUri", new Object[]{systemId, systemUri.toASCIIString()}), null);
                        }
                        schemaSource = null;
                    }
                    catch (URISyntaxException e) {
                        if (DefaultModelContext.this.isLoggable(Level.WARNING)) {
                            DefaultModelContext.this.log(Level.WARNING, DefaultModelContext.getMessage("unsupportedSystemIdUri", new Object[]{systemId, e.getMessage()}), null);
                        }
                        schemaSource = null;
                    }
                    catch (BootstrapException e) {
                        throw (IOException)new IOException(DefaultModelContext.getMessage("failedResolvingSchemas", new Object[0])).initCause(e);
                    }
                    catch (ModelException e) {
                        throw (IOException)new IOException(DefaultModelContext.getMessage("failedResolving", new Object[]{publicId, systemId, e.getMessage()})).initCause(e);
                    }
                }
                return schemaSource;
            }
        };
    }

    @Override
    public LSResourceResolver createResourceResolver() throws ModelException {
        return new LSResourceResolver(){

            public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, final String baseURI) {
                block10: {
                    String resolvePublicId = namespaceURI == null ? publicId : namespaceURI;
                    String resolveSystemId = systemId == null ? "" : systemId;
                    try {
                        if ("http://www.w3.org/2001/XMLSchema".equals(type)) {
                            final InputSource schemaSource = DefaultModelContext.this.createEntityResolver().resolveEntity(resolvePublicId, resolveSystemId);
                            if (schemaSource != null) {
                                return new LSInput(){

                                    public Reader getCharacterStream() {
                                        return schemaSource.getCharacterStream();
                                    }

                                    public void setCharacterStream(Reader characterStream) {
                                        DefaultModelContext.this.log(Level.WARNING, DefaultModelContext.getMessage("unsupportedOperation", new Object[]{"setCharacterStream", DefaultModelContext.class.getName() + ".LSResourceResolver"}), null);
                                    }

                                    public InputStream getByteStream() {
                                        return schemaSource.getByteStream();
                                    }

                                    public void setByteStream(InputStream byteStream) {
                                        DefaultModelContext.this.log(Level.WARNING, DefaultModelContext.getMessage("unsupportedOperation", new Object[]{"setByteStream", DefaultModelContext.class.getName() + ".LSResourceResolver"}), null);
                                    }

                                    public String getStringData() {
                                        return null;
                                    }

                                    public void setStringData(String stringData) {
                                        DefaultModelContext.this.log(Level.WARNING, DefaultModelContext.getMessage("unsupportedOperation", new Object[]{"setStringData", DefaultModelContext.class.getName() + ".LSResourceResolver"}), null);
                                    }

                                    public String getSystemId() {
                                        return schemaSource.getSystemId();
                                    }

                                    public void setSystemId(String systemId) {
                                        DefaultModelContext.this.log(Level.WARNING, DefaultModelContext.getMessage("unsupportedOperation", new Object[]{"setSystemId", DefaultModelContext.class.getName() + ".LSResourceResolver"}), null);
                                    }

                                    public String getPublicId() {
                                        return schemaSource.getPublicId();
                                    }

                                    public void setPublicId(String publicId) {
                                        DefaultModelContext.this.log(Level.WARNING, DefaultModelContext.getMessage("unsupportedOperation", new Object[]{"setPublicId", DefaultModelContext.class.getName() + ".LSResourceResolver"}), null);
                                    }

                                    public String getBaseURI() {
                                        return baseURI;
                                    }

                                    public void setBaseURI(String baseURI2) {
                                        DefaultModelContext.this.log(Level.WARNING, DefaultModelContext.getMessage("unsupportedOperation", new Object[]{"setBaseURI", DefaultModelContext.class.getName() + ".LSResourceResolver"}), null);
                                    }

                                    public String getEncoding() {
                                        return schemaSource.getEncoding();
                                    }

                                    public void setEncoding(String encoding) {
                                        DefaultModelContext.this.log(Level.WARNING, DefaultModelContext.getMessage("unsupportedOperation", new Object[]{"setEncoding", DefaultModelContext.class.getName() + ".LSResourceResolver"}), null);
                                    }

                                    public boolean getCertifiedText() {
                                        return false;
                                    }

                                    public void setCertifiedText(boolean certifiedText) {
                                        DefaultModelContext.this.log(Level.WARNING, DefaultModelContext.getMessage("unsupportedOperation", new Object[]{"setCertifiedText", DefaultModelContext.class.getName() + ".LSResourceResolver"}), null);
                                    }
                                };
                            }
                        } else if (DefaultModelContext.this.isLoggable(Level.WARNING)) {
                            DefaultModelContext.this.log(Level.WARNING, DefaultModelContext.getMessage("unsupportedResourceType", new Object[]{type}), null);
                        }
                    }
                    catch (SAXException e) {
                        if (DefaultModelContext.this.isLoggable(Level.SEVERE)) {
                            DefaultModelContext.this.log(Level.SEVERE, DefaultModelContext.getMessage("failedResolving", new Object[]{resolvePublicId, resolveSystemId, e.getMessage()}), e);
                        }
                    }
                    catch (IOException e) {
                        if (DefaultModelContext.this.isLoggable(Level.SEVERE)) {
                            DefaultModelContext.this.log(Level.SEVERE, DefaultModelContext.getMessage("failedResolving", new Object[]{resolvePublicId, resolveSystemId, e.getMessage()}), e);
                        }
                    }
                    catch (ModelException e) {
                        if (!DefaultModelContext.this.isLoggable(Level.SEVERE)) break block10;
                        DefaultModelContext.this.log(Level.SEVERE, DefaultModelContext.getMessage("failedResolving", new Object[]{resolvePublicId, resolveSystemId, e.getMessage()}), e);
                    }
                }
                return null;
            }
        };
    }

    @Override
    public javax.xml.validation.Schema createSchema() throws ModelException {
        try {
            SchemaFactory f = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schemas schemas = this.getSchemas();
            ArrayList<SAXSource> sources = new ArrayList<SAXSource>(schemas.getSchema().size());
            EntityResolver entityResolver = this.createEntityResolver();
            for (Schema s : schemas.getSchema()) {
                InputSource inputSource = entityResolver.resolveEntity(s.getPublicId(), s.getSystemId());
                if (inputSource == null) continue;
                sources.add(new SAXSource(inputSource));
            }
            if (sources.isEmpty()) {
                throw new ModelException(DefaultModelContext.getMessage("missingSchemas", new Object[0]));
            }
            f.setResourceResolver(this.createResourceResolver());
            return f.newSchema(sources.toArray(new Source[sources.size()]));
        }
        catch (BootstrapException e) {
            throw new ModelException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ModelException(e.getMessage(), e);
        }
        catch (SAXException e) {
            throw new ModelException(e.getMessage(), e);
        }
    }

    @Override
    public JAXBContext createContext() throws ModelException {
        try {
            StringBuilder packageNames = new StringBuilder();
            for (Schema schema : this.getSchemas().getSchema()) {
                if (schema.getContextId() == null) continue;
                packageNames.append(':').append(schema.getContextId());
                if (!this.isLoggable(Level.CONFIG)) continue;
                this.log(Level.CONFIG, DefaultModelContext.getMessage("foundContext", schema.getContextId()), null);
            }
            if (packageNames.length() == 0) {
                throw new ModelException(DefaultModelContext.getMessage("missingSchemas", new Object[0]));
            }
            return JAXBContext.newInstance((String)packageNames.toString().substring(1), (ClassLoader)this.getClassLoader());
        }
        catch (BootstrapException e) {
            throw new ModelException(e.getMessage(), e);
        }
        catch (JAXBException e) {
            throw new ModelException(e.getMessage(), e);
        }
    }

    @Override
    public Marshaller createMarshaller() throws ModelException {
        try {
            StringBuilder packageNames = new StringBuilder();
            StringBuilder schemaLocation = new StringBuilder();
            for (Schema schema : this.getSchemas().getSchema()) {
                if (schema.getContextId() != null) {
                    packageNames.append(':').append(schema.getContextId());
                }
                if (schema.getPublicId() == null || schema.getSystemId() == null) continue;
                schemaLocation.append(' ').append(schema.getPublicId()).append(' ').append(schema.getSystemId());
            }
            if (packageNames.length() == 0) {
                throw new ModelException(DefaultModelContext.getMessage("missingSchemas", new Object[0]));
            }
            Marshaller m = JAXBContext.newInstance((String)packageNames.toString().substring(1), (ClassLoader)this.getClassLoader()).createMarshaller();
            if (schemaLocation.length() != 0) {
                m.setProperty("jaxb.schemaLocation", (Object)schemaLocation.toString().substring(1));
            }
            return m;
        }
        catch (BootstrapException e) {
            throw new ModelException(e.getMessage(), e);
        }
        catch (JAXBException e) {
            throw new ModelException(e.getMessage(), e);
        }
    }

    @Override
    public Unmarshaller createUnmarshaller() throws ModelException {
        try {
            return this.createContext().createUnmarshaller();
        }
        catch (JAXBException e) {
            throw new ModelException(e.getMessage(), e);
        }
    }

    private Services getServices() throws BootstrapException {
        Services services = this.cachedServices.get();
        if (services == null) {
            services = BootstrapContext.createBootstrapContext(this.getClassLoader()).findServices();
            if (services != null && this.isLoggable(Level.CONFIG)) {
                for (Service s : services.getService()) {
                    this.log(Level.CONFIG, DefaultModelContext.getMessage("foundService", s.getOrdinal(), s.getIdentifier(), s.getClazz()), null);
                }
            }
            this.cachedServices = new SoftReference<Services>(services);
        }
        return services;
    }

    private Schemas getSchemas() throws BootstrapException {
        Schemas schemas = this.cachedSchemas.get();
        if (schemas == null) {
            schemas = BootstrapContext.createBootstrapContext(this.getClassLoader()).findSchemas();
            if (schemas != null && this.isLoggable(Level.CONFIG)) {
                for (Schema s : schemas.getSchema()) {
                    this.log(Level.CONFIG, DefaultModelContext.getMessage("foundSchema", s.getPublicId(), s.getSystemId(), s.getContextId(), s.getClasspathId()), null);
                }
            }
            this.cachedSchemas = new SoftReference<Schemas>(schemas);
        }
        return schemas;
    }

    private Set<URI> getSchemaResources() throws IOException, URISyntaxException {
        Set<URI> resources = this.cachedSchemaResources.get();
        if (resources == null) {
            resources = new HashSet<URI>();
            long t0 = System.currentTimeMillis();
            int count = 0;
            Enumeration<URL> e = this.getClassLoader().getResources("META-INF/MANIFEST.MF");
            while (e.hasMoreElements()) {
                ++count;
                URL manifestUrl = e.nextElement();
                String externalForm = manifestUrl.toExternalForm();
                String baseUrl = externalForm.substring(0, externalForm.indexOf("META-INF"));
                InputStream manifestStream = manifestUrl.openStream();
                Manifest mf = new Manifest(manifestStream);
                manifestStream.close();
                if (this.isLoggable(Level.FINE)) {
                    this.log(Level.FINE, DefaultModelContext.getMessage("processing", externalForm), null);
                }
                for (Map.Entry<String, Attributes> entry : mf.getEntries().entrySet()) {
                    for (int i = SCHEMA_EXTENSIONS.length - 1; i >= 0; --i) {
                        if (!entry.getKey().toLowerCase().endsWith('.' + SCHEMA_EXTENSIONS[i].toLowerCase())) continue;
                        URL schemaUrl = new URL(baseUrl + entry.getKey());
                        resources.add(schemaUrl.toURI());
                        if (!this.isLoggable(Level.FINE)) continue;
                        this.log(Level.FINE, DefaultModelContext.getMessage("foundSchemaCandidate", schemaUrl.toExternalForm()), null);
                    }
                }
            }
            if (this.isLoggable(Level.FINE)) {
                this.log(Level.FINE, DefaultModelContext.getMessage("contextReport", count, "META-INF/MANIFEST.MF", System.currentTimeMillis() - t0), null);
            }
            this.cachedSchemaResources = new SoftReference<Set<URI>>(resources);
        }
        return resources;
    }

    private static String getMessage(String key, Object ... args) {
        return MessageFormat.format(ResourceBundle.getBundle(DefaultModelContext.class.getName().replace('.', '/'), Locale.getDefault()).getString(key), args);
    }
}

