/*
 * Decompiled with CFR 0.152.
 */
package org.jomc.model;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.logging.Level;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.util.JAXBResult;
import javax.xml.bind.util.JAXBSource;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;
import org.jomc.model.ModelContext;
import org.jomc.model.ModelException;
import org.jomc.model.ModelProcessor;
import org.jomc.model.Modules;
import org.jomc.model.ObjectFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultModelProcessor
implements ModelProcessor {
    private static final String DEFAULT_TRANSFORMER_LOCATION = "META-INF/jomc.xsl";
    private static volatile String defaultTransformerLocation;
    private String transformerLocation;

    public static String getDefaultTransformerLocation() {
        if (defaultTransformerLocation == null) {
            defaultTransformerLocation = System.getProperty("org.jomc.model.DefaultModelProcessor.defaultTransformerLocation", DEFAULT_TRANSFORMER_LOCATION);
        }
        return defaultTransformerLocation;
    }

    public static void setDefaultTransformerLocation(String value) {
        defaultTransformerLocation = value;
    }

    public String getTransformerLocation() {
        if (this.transformerLocation == null) {
            this.transformerLocation = DefaultModelProcessor.getDefaultTransformerLocation();
        }
        return this.transformerLocation;
    }

    public void setTransformerLocation(String value) {
        this.transformerLocation = value;
    }

    public List<Transformer> findTransformers(final ModelContext context, String location) throws ModelException {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (location == null) {
            throw new NullPointerException("location");
        }
        try {
            long t0 = System.currentTimeMillis();
            LinkedList<Transformer> transformers = new LinkedList<Transformer>();
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Enumeration<URL> resources = context.findResources(location);
            ErrorListener errorListener = new ErrorListener(){

                public void warning(TransformerException exception) throws TransformerException {
                    if (context.isLoggable(Level.WARNING)) {
                        context.log(Level.WARNING, exception.getMessage(), exception);
                    }
                }

                public void error(TransformerException exception) throws TransformerException {
                    if (context.isLoggable(Level.SEVERE)) {
                        context.log(Level.SEVERE, exception.getMessage(), exception);
                    }
                    throw exception;
                }

                public void fatalError(TransformerException exception) throws TransformerException {
                    if (context.isLoggable(Level.SEVERE)) {
                        context.log(Level.SEVERE, exception.getMessage(), exception);
                    }
                    throw exception;
                }
            };
            transformerFactory.setErrorListener(errorListener);
            int count = 0;
            while (resources.hasMoreElements()) {
                ++count;
                URL url = resources.nextElement();
                if (context.isLoggable(Level.FINE)) {
                    context.log(Level.FINE, this.getMessage("processing", new Object[]{url.toExternalForm()}), null);
                }
                InputStream in = url.openStream();
                Transformer transformer = transformerFactory.newTransformer(new StreamSource(in));
                in.close();
                transformer.setErrorListener(errorListener);
                transformers.add(transformer);
            }
            if (context.isLoggable(Level.FINE)) {
                context.log(Level.FINE, this.getMessage("contextReport", new Object[]{count, location, System.currentTimeMillis() - t0}), null);
            }
            return transformers.isEmpty() ? null : transformers;
        }
        catch (IOException e) {
            throw new ModelException(e.getMessage(), e);
        }
        catch (TransformerConfigurationException e) {
            throw new ModelException(e.getMessage(), e);
        }
    }

    @Override
    public Modules processModules(ModelContext context, Modules modules) throws ModelException {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (modules == null) {
            throw new NullPointerException("modules");
        }
        try {
            ObjectFactory objectFactory = new ObjectFactory();
            JAXBContext jaxbContext = context.createContext();
            List<Transformer> transformers = this.findTransformers(context, this.getTransformerLocation());
            Modules processed = new Modules(modules);
            if (transformers != null) {
                for (Transformer t : transformers) {
                    JAXBElement<Modules> e = objectFactory.createModules(processed);
                    JAXBSource source = new JAXBSource(jaxbContext, e);
                    JAXBResult result = new JAXBResult(jaxbContext);
                    t.transform((Source)source, (Result)result);
                    processed = (Modules)((JAXBElement)result.getResult()).getValue();
                }
            }
            return processed;
        }
        catch (TransformerException e) {
            throw new ModelException(e.getMessage(), e);
        }
        catch (JAXBException e) {
            throw new ModelException(e.getMessage(), e);
        }
    }

    private String getMessage(String key, Object args) {
        return new MessageFormat(ResourceBundle.getBundle(DefaultModelProcessor.class.getName().replace('.', '/'), Locale.getDefault()).getString(key)).format(args);
    }
}

